/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.client.common;

import _504.iec62325.wss._1._0.MsgFaultMsg;
import _504.iec62325.wss._1._0.PortTFEDIType;
import _504.iec62325.wss._1._0.ServiceEME;
import ch.iec.tc57._2011.schema.message.HeaderType;
import ch.iec.tc57._2011.schema.message.PayloadType;
import ch.iec.tc57._2011.schema.message.RequestMessage;
import ch.iec.tc57._2011.schema.message.ResponseMessage;
import es.ree.eemws.client.common.SendHandler;
import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.error.ErrorMessages;
import es.ree.eemws.core.utils.iec61968100.EnumNoun;
import es.ree.eemws.core.utils.iec61968100.EnumVerb;
import es.ree.eemws.core.utils.iec61968100.MessageMetaData;
import es.ree.eemws.core.utils.operations.HandlerException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import org.w3c.dom.Element;

public abstract class ParentClient {
    private static final QName SERVICE_NAME = new QName("urn:iec62325.504:wss:1:0", "ServiceEME");
    private static final String WSDL_FILE = "urn-iec62325-504-wss-1-0.wsdl";
    private URL endPoint = null;
    private boolean signRequest = true;
    private boolean verifyResponse = true;
    private X509Certificate certificate = null;
    private PrivateKey privateKey = null;
    private MessageMetaData messageMetaData = new MessageMetaData();

    public final void setEndPoint(String url) throws MalformedURLException {
        this.endPoint = new URL(url);
    }

    public final void setEndPoint(URL url) {
        this.endPoint = url;
    }

    public final void setSignRequest(boolean flag) {
        this.signRequest = flag;
    }

    public final void setVerifyResponse(boolean flag) {
        this.verifyResponse = flag;
    }

    public final void setCertificate(X509Certificate inCertificate) {
        this.certificate = inCertificate;
    }

    public final void setPrivateKey(PrivateKey inPrivateKey) {
        this.privateKey = inPrivateKey;
    }

    public final MessageMetaData getMessageMetaData() {
        return this.messageMetaData;
    }

    protected final ResponseMessage sendMessage(RequestMessage message) throws HandlerException {
        ResponseMessage retValue = null;
        try {
            ServiceEME service = new ServiceEME(this.getClass().getClassLoader().getResource(WSDL_FILE), SERVICE_NAME);
            PortTFEDIType port = service.getServiceEMEPort();
            BindingProvider bindingProvider = (BindingProvider)port;
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.endPoint.toString());
            this.messageMetaData = new MessageMetaData();
            Binding binding = bindingProvider.getBinding();
            List handlerList = binding.getHandlerChain();
            handlerList.add(new SendHandler(this.signRequest, this.verifyResponse, this.messageMetaData, this.certificate, this.privateKey));
            binding.setHandlerChain(handlerList);
            retValue = port.request(message);
            MessageMetaData metadata = this.getMessageMetaData();
            if (metadata.getException() != null) {
                throw (HandlerException)metadata.getException();
            }
        }
        catch (MsgFaultMsg ex) {
            throw new HandlerException(EnumErrorCatalog.ERR_HAND_010, (Exception)((Object)ex), new String[0]);
        }
        catch (RuntimeException ex) {
            String errStr = ex.getMessage();
            if (errStr.indexOf("trustAnchors") != -1 || errStr.indexOf("PKIX path building failed") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_013, new String[0]);
            }
            if (errStr.indexOf("No subject alternative") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_014, new String[0]);
            }
            if (errStr.indexOf("UnknownHostException") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_015, new String[0]);
            }
            if (errStr.indexOf("The server sent HTTP status code 404:") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_016, new String[0]);
            }
            if (errStr.indexOf("The server sent HTTP status code 403:") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_017, new String[0]);
            }
            if (errStr.indexOf("The server sent HTTP status code 401:") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_018, new String[0]);
            }
            if (errStr.indexOf("The server sent HTTP status code 200:") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_019, new String[0]);
            }
            if (errStr.indexOf("Connection refused") != -1 || errStr.indexOf("Connection timed out") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_020, new String[0]);
            }
            if (errStr.indexOf("The server sent HTTP status code 400:") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_021, new String[0]);
            }
            if (errStr.indexOf("unrecognized_name") != -1) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_023, new String[0]);
            }
            throw new HandlerException(EnumErrorCatalog.ERR_HAND_022, (Exception)ex, new String[0]);
        }
        return retValue;
    }

    protected void validateResponse(ResponseMessage responseMessage, String expectedNoun) throws HandlerException {
        this.validateResponse(responseMessage, expectedNoun, false);
    }

    protected void validateResponse(ResponseMessage responseMessage, boolean canBeEmpty) throws HandlerException {
        this.validateResponse(responseMessage, null, canBeEmpty);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateResponse(ResponseMessage responseMessage, String expectedNoun, boolean canBeEmpty) throws HandlerException {
        String rootTag;
        boolean empty;
        HeaderType header = responseMessage.getHeader();
        if (header == null) {
            throw new HandlerException(EnumErrorCatalog.ERR_HAND_002, new String[]{ErrorMessages.NO_HEADER});
        }
        String verb = header.getVerb();
        String noun = header.getNoun();
        if (expectedNoun != null && !expectedNoun.equals(noun)) {
            throw new HandlerException(EnumErrorCatalog.ERR_HAND_012, new String[]{verb, noun, EnumVerb.REPLY.toString(), expectedNoun});
        }
        PayloadType payload = responseMessage.getPayload();
        if (payload == null) {
            throw new HandlerException(EnumErrorCatalog.ERR_HAND_011, new String[0]);
        }
        List anies = payload.getAnies();
        boolean compressed = payload.getCompressed() != null;
        boolean bl = empty = anies.isEmpty() && !compressed;
        if (empty) {
            if (!canBeEmpty) throw new HandlerException(EnumErrorCatalog.ERR_HAND_011, new String[0]);
            if (EnumVerb.REPLY.toString().equals(verb)) return;
            throw new HandlerException(EnumErrorCatalog.ERR_HAND_012, new String[]{verb, ErrorMessages.NO_NOUN_EXPECTED, EnumVerb.REPLY.toString(), ErrorMessages.NO_NOUN_EXPECTED});
        }
        if (compressed) {
            rootTag = EnumNoun.COMPRESSED.toString();
        } else {
            Element message = (Element)anies.get(0);
            if (message == null) {
                throw new HandlerException(EnumErrorCatalog.ERR_HAND_011, new String[0]);
            }
            rootTag = message.getLocalName();
        }
        if (EnumVerb.REPLY.toString().equals(verb) && rootTag.equals(noun)) return;
        throw new HandlerException(EnumErrorCatalog.ERR_HAND_012, new String[]{verb, noun, EnumVerb.REPLY.toString(), rootTag});
    }
}

