/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.client.common;

import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.iec61968100.EnumMessageStatus;
import es.ree.eemws.core.utils.iec61968100.GenericCodedException;
import es.ree.eemws.core.utils.iec61968100.MessageMetaData;
import es.ree.eemws.core.utils.iec61968100.StringBuilderMessage;
import es.ree.eemws.core.utils.operations.HandlerException;
import es.ree.eemws.core.utils.security.SignatureManager;
import es.ree.eemws.core.utils.security.SignatureManagerException;
import es.ree.eemws.core.utils.security.SignatureSyntaxException;
import es.ree.eemws.core.utils.security.SignatureVerificationException;
import es.ree.eemws.core.utils.xml.XMLUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.xml.sax.SAXException;

public final class SendHandler
implements SOAPHandler<SOAPMessageContext> {
    private boolean flagSignRequest;
    private boolean flagVerifyResponseSignature;
    private X509Certificate certificate = null;
    private PrivateKey privateKey = null;
    private MessageMetaData messageData = null;
    private static final Logger LOGGER = Logger.getLogger(SendHandler.class.getName());

    public SendHandler(boolean flgSignRequest, boolean flgVerifyRespSign, MessageMetaData msgMetaData, X509Certificate inCertificate, PrivateKey inPrivateKey) {
        this.flagSignRequest = flgSignRequest;
        this.flagVerifyResponseSignature = flgVerifyRespSign;
        this.messageData = msgMetaData;
        this.certificate = inCertificate;
        this.privateKey = inPrivateKey;
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public void close(MessageContext mc) {
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        try {
            this.messageData.setStatus(EnumMessageStatus.FAILED);
            this.messageData.setServerTimestamp(Calendar.getInstance());
            this.messageData.setRejectText(new StringBuilderMessage(messageContext).getStringMessage().toString());
            this.logSoapConversation(messageContext);
        }
        catch (SOAPException e) {
            LOGGER.log(Level.FINE, "Unable to convert soap message to xml...", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(SOAPMessageContext messageContext) {
        boolean returnValue = true;
        boolean output = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        try {
            if (output && this.flagSignRequest) {
                StringBuilderMessage sbm = new StringBuilderMessage(messageContext);
                if (this.certificate != null && this.privateKey != null) {
                    SignatureManager.signString((StringBuilder)sbm.getStringMessage(), (PrivateKey)this.privateKey, (X509Certificate)this.certificate);
                } else {
                    SignatureManager.signString((StringBuilder)sbm.getStringMessage());
                }
                messageContext.getMessage().getSOAPBody().removeContents();
                messageContext.getMessage().getSOAPBody().addDocument(XMLUtil.string2Document((StringBuilder)sbm.getStringMessage()));
            } else if (!output) {
                StringBuilderMessage sbm = new StringBuilderMessage(messageContext);
                this.messageData.setStatus(sbm.getStatus());
                this.messageData.setServerTimestamp(Calendar.getInstance());
                if (this.flagVerifyResponseSignature) {
                    X509Certificate x509Certificate = SignatureManager.verifyString((StringBuilder)sbm.getStringMessage());
                    this.messageData.setSignatureCertificate(x509Certificate);
                }
            }
        }
        catch (SignatureVerificationException e) {
            returnValue = false;
            this.messageData.setSignatureCertificate(e.getDetails().getSignatureCertificate());
            this.messageData.setException((GenericCodedException)new HandlerException(EnumErrorCatalog.ERR_HAND_007, (Exception)((Object)e), new String[0]));
        }
        catch (SignatureSyntaxException e) {
            returnValue = false;
            this.messageData.setException((GenericCodedException)new HandlerException(EnumErrorCatalog.ERR_HAND_008, (Exception)((Object)e), new String[0]));
        }
        catch (SignatureManagerException e) {
            returnValue = false;
            this.messageData.setException((GenericCodedException)new HandlerException(EnumErrorCatalog.ERR_HAND_009, (Exception)((Object)e), new String[0]));
        }
        catch (IOException | ParserConfigurationException | SOAPException | SAXException e) {
            returnValue = false;
            this.messageData.setException((GenericCodedException)new HandlerException(EnumErrorCatalog.ERR_HAND_004, (Exception)e, new String[0]));
        }
        finally {
            this.logSoapConversation(messageContext);
        }
        return returnValue;
    }

    private void logSoapConversation(SOAPMessageContext messageContext) {
        if (LOGGER.isLoggable(Level.FINE)) {
            boolean output = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
            if (output) {
                LOGGER.fine(">>> out message >>>");
            } else {
                LOGGER.fine("<<< input message <<<");
            }
            try {
                LOGGER.fine(new StringBuilderMessage(messageContext).getStringMessage().toString());
                LOGGER.fine("---- end of message ---- ");
            }
            catch (SOAPException e) {
                LOGGER.log(Level.FINE, "Unable to convert soap message to xml...", e);
            }
        }
    }
}

