/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.client.get;

import ch.iec.tc57._2011.schema.message.RequestMessage;
import ch.iec.tc57._2011.schema.message.ResponseMessage;
import es.ree.eemws.client.common.ParentClient;
import es.ree.eemws.client.get.RetrievedMessage;
import es.ree.eemws.core.utils.iec61968100.EnumFilterElement;
import es.ree.eemws.core.utils.iec61968100.EnumNoun;
import es.ree.eemws.core.utils.iec61968100.EnumVerb;
import es.ree.eemws.core.utils.iec61968100.GenericCodedException;
import es.ree.eemws.core.utils.iec61968100.MessageUtil;
import es.ree.eemws.core.utils.operations.HandlerException;
import es.ree.eemws.core.utils.operations.get.GetOperationException;
import es.ree.eemws.core.utils.operations.get.GetRequestMessageValidator;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public final class GetMessage
extends ParentClient {
    private static final boolean SIGN_REQUEST = false;
    private static final boolean VERIFY_RESPONSE_SIGNATURE = true;

    public GetMessage() {
        this.setSignRequest(false);
        this.setVerifyResponse(true);
    }

    public RetrievedMessage get(String messageIdentification, Integer messageVersion) throws GetOperationException {
        return this.get(messageIdentification, messageVersion, null, null);
    }

    public RetrievedMessage get(BigInteger code) throws GetOperationException {
        return this.get(null, null, code.longValue(), null);
    }

    public RetrievedMessage get(Long code) throws GetOperationException {
        return this.get(null, null, code, null);
    }

    public RetrievedMessage get(String queue) throws GetOperationException {
        return this.get(null, null, null, queue);
    }

    public RetrievedMessage get(Map<String, String> msgOptions) throws GetOperationException {
        RetrievedMessage retValue = new RetrievedMessage();
        try {
            retValue.setMsgIdentification(msgOptions.get(EnumFilterElement.MESSAGE_IDENTIFICATION.toString()));
            retValue.setMsgVersion(msgOptions.get(EnumFilterElement.MESSAGE_VERSION.toString()));
            retValue.setMsgIdentification(msgOptions.get(EnumFilterElement.CODE.toString()));
            RequestMessage requestMessage = MessageUtil.createRequestWithOptions((EnumVerb)EnumVerb.GET, (EnumNoun)EnumNoun.ANY, msgOptions);
            GetRequestMessageValidator.validate((RequestMessage)requestMessage);
            ResponseMessage response = this.sendMessage(requestMessage);
            this.validateResponse(response, false);
            retValue.setMessage(response);
        }
        catch (HandlerException e) {
            throw new GetOperationException((GenericCodedException)e);
        }
        return retValue;
    }

    public RetrievedMessage get(String messageIdentification, Integer messageVersion, Long code, String queue) throws GetOperationException {
        HashMap<String, String> msgOptions = new HashMap<String, String>();
        if (messageIdentification != null) {
            msgOptions.put(EnumFilterElement.MESSAGE_IDENTIFICATION.toString(), messageIdentification);
        }
        if (messageVersion != null) {
            msgOptions.put(EnumFilterElement.MESSAGE_VERSION.toString(), messageVersion.toString());
        }
        if (code != null) {
            msgOptions.put(EnumFilterElement.CODE.toString(), code.toString());
        }
        if (queue != null) {
            msgOptions.put(EnumFilterElement.QUEUE.toString(), queue);
        }
        return this.get(msgOptions);
    }
}

