/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.client.get;

import ch.iec.tc57._2011.schema.message.ReplyType;
import ch.iec.tc57._2011.schema.message.ResponseMessage;
import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.file.GZIPUtil;
import es.ree.eemws.core.utils.iec61968100.EnumMessageFormat;
import es.ree.eemws.core.utils.iec61968100.EnumNoun;
import es.ree.eemws.core.utils.operations.get.GetOperationException;
import es.ree.eemws.core.utils.xml.XMLElementUtil;
import es.ree.eemws.core.utils.xml.XMLUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;

public final class RetrievedMessage {
    private static final String VERSION_SEPARATOR = ".";
    private byte[] binaryContent;
    private String xmlContent;
    private EnumMessageFormat format = EnumMessageFormat.XML;
    private String fileName;
    private ResponseMessage respMess;

    public boolean isBinary() {
        return this.format.equals((Object)EnumMessageFormat.BINARY);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setMsgIdentification(String messageIdentification) {
        if (messageIdentification != null) {
            this.fileName = messageIdentification;
        }
    }

    public void setMsgVersion(String messageVersion) {
        if (this.fileName != null) {
            this.fileName = this.fileName + VERSION_SEPARATOR + messageVersion;
        }
    }

    public byte[] getBinaryPayload() {
        return this.binaryContent;
    }

    public String getStringPayload() {
        return this.xmlContent;
    }

    public String getPrettyPayload() {
        String retValue = null;
        if (this.xmlContent != null) {
            retValue = XMLUtil.prettyPrint((String)XMLUtil.removeNameSpaces((String)this.xmlContent).toString()).toString();
        }
        return retValue;
    }

    public ResponseMessage getResponseMessage() {
        return this.respMess;
    }

    public void setMessage(ResponseMessage response) throws GetOperationException {
        this.respMess = response;
        try {
            if (response.getHeader().getNoun().equals(EnumNoun.COMPRESSED.toString())) {
                List lsIds;
                String msgFormat = response.getPayload().getFormat();
                if (msgFormat != null) {
                    this.format = EnumMessageFormat.fromString((String)msgFormat);
                    if (this.format == null) {
                        throw new GetOperationException(EnumErrorCatalog.ERR_GET_014, new String[]{msgFormat, EnumMessageFormat.getList()});
                    }
                }
                this.binaryContent = DatatypeConverter.parseBase64Binary((String)response.getPayload().getCompressed());
                if (msgFormat == null || this.format.equals((Object)EnumMessageFormat.XML)) {
                    this.xmlContent = new String(GZIPUtil.uncompress((byte[])this.binaryContent), StandardCharsets.UTF_8);
                    this.binaryContent = null;
                }
                if ((lsIds = response.getReply().getIDS()) != null) {
                    boolean loop = true;
                    Iterator ids = lsIds.iterator();
                    while (ids.hasNext() && loop) {
                        ReplyType.ID id = (ReplyType.ID)ids.next();
                        if (!"name".equals(id.getIdType())) continue;
                        this.fileName = id.getValue();
                        loop = false;
                    }
                }
                if (this.isBinary() && this.fileName == null) {
                    throw new GetOperationException(EnumErrorCatalog.ERR_GET_018, new String[0]);
                }
            } else {
                Element message = (Element)response.getPayload().getAnies().get(0);
                this.xmlContent = XMLElementUtil.element2String((Element)message);
            }
        }
        catch (IOException e) {
            throw new GetOperationException(EnumErrorCatalog.ERR_GET_015, (Exception)e, new String[0]);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new GetOperationException(EnumErrorCatalog.ERR_GET_015, e, new String[0]);
        }
    }
}

