/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.client.list;

import _504.iec62325.messages._1._0.MessageList;
import _504.iec62325.messages._1._0.StatusType;
import _504.iec62325.messages._1._0.TimeIntervalType;
import ch.iec.tc57._2011.schema.message.RequestMessage;
import ch.iec.tc57._2011.schema.message.ResponseMessage;
import es.ree.eemws.client.common.ParentClient;
import es.ree.eemws.client.list.MessageListEntry;
import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.iec61968100.EnumFilterElement;
import es.ree.eemws.core.utils.iec61968100.EnumIntervalTimeType;
import es.ree.eemws.core.utils.iec61968100.EnumNoun;
import es.ree.eemws.core.utils.iec61968100.EnumVerb;
import es.ree.eemws.core.utils.iec61968100.GenericCodedException;
import es.ree.eemws.core.utils.iec61968100.MessageUtil;
import es.ree.eemws.core.utils.operations.HandlerException;
import es.ree.eemws.core.utils.operations.list.ListOperationException;
import es.ree.eemws.core.utils.operations.list.ListRequestMessageValidator;
import es.ree.eemws.core.utils.xml.XMLElementUtil;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Element;

public final class ListMessages
extends ParentClient {
    private static final boolean SIGN_REQUEST = false;
    private static final boolean VERIFY_RESPONSE_SIGNATURE = false;

    public ListMessages() {
        this.setSignRequest(false);
        this.setVerifyResponse(false);
    }

    public List<MessageListEntry> list(Date startTime, Date endTime) throws ListOperationException {
        return this.list(startTime, endTime, null, null, null, null);
    }

    public List<MessageListEntry> list(Date startTime, Date endTime, EnumIntervalTimeType intervalType) throws ListOperationException {
        return this.list(startTime, endTime, intervalType, null, null, null);
    }

    public List<MessageListEntry> list(Date startTime, Date endTime, EnumIntervalTimeType intervalType, String messageIdentification, String msgType, String owner) throws ListOperationException {
        return this.list(null, startTime, endTime, intervalType, messageIdentification, msgType, owner);
    }

    public List<MessageListEntry> list(Long code) throws ListOperationException {
        return this.list(code, null, null, null);
    }

    public List<MessageListEntry> list(Long code, String messageIdentification, String msgType, String owner) throws ListOperationException {
        return this.list(code, null, null, null, messageIdentification, msgType, owner);
    }

    public List<MessageListEntry> list(Map<String, String> msgOptions) throws ListOperationException {
        List<MessageListEntry> retValue = null;
        try {
            RequestMessage requestMessage = MessageUtil.createRequestWithOptions((EnumVerb)EnumVerb.GET, (EnumNoun)EnumNoun.MESSAGE_LIST, msgOptions);
            ListRequestMessageValidator.validate((RequestMessage)requestMessage);
            ResponseMessage response = this.sendMessage(requestMessage);
            this.validateResponse(response, EnumNoun.MESSAGE_LIST.toString());
            retValue = this.processPayload(response);
        }
        catch (HandlerException e) {
            throw new ListOperationException((GenericCodedException)e);
        }
        return retValue;
    }

    private List<MessageListEntry> list(Long code, Date startTime, Date endTime, EnumIntervalTimeType intervalType, String messageIdentification, String msgType, String owner) throws ListOperationException {
        HashMap<String, String> msgOptions = new HashMap<String, String>();
        if (code != null) {
            msgOptions.put(EnumFilterElement.CODE.toString(), Long.toString(code));
        }
        DateFormat df = DateFormat.getInstance();
        if (startTime != null) {
            msgOptions.put(EnumFilterElement.START_TIME.toString(), df.format(startTime));
        }
        if (endTime != null) {
            msgOptions.put(EnumFilterElement.END_TIME.toString(), df.format(endTime));
        }
        if (intervalType != null) {
            msgOptions.put(EnumFilterElement.INTERVAL_TYPE.toString(), intervalType.toString());
        }
        if (messageIdentification != null) {
            msgOptions.put(EnumFilterElement.MESSAGE_IDENTIFICATION.toString(), messageIdentification);
        }
        if (msgType != null) {
            msgOptions.put(EnumFilterElement.MESSAGE_TYPE.toString(), msgType);
        }
        if (owner != null) {
            msgOptions.put(EnumFilterElement.OWNER.toString(), owner);
        }
        return this.list(msgOptions);
    }

    private List<MessageListEntry> processPayload(ResponseMessage responseMessage) throws ListOperationException {
        ArrayList<MessageListEntry> listMessageData = new ArrayList<MessageListEntry>();
        try {
            Element message = (Element)responseMessage.getPayload().getAnies().get(0);
            MessageList messageList = (MessageList)XMLElementUtil.element2Obj((Element)message, MessageList.class);
            List lstMsgs = messageList.getMessages();
            for (MessageList.Message msg : lstMsgs) {
                TimeIntervalType interval;
                StatusType status;
                MessageListEntry messageData = new MessageListEntry();
                messageData.setCode(msg.getCode());
                messageData.setMessageIdentification(msg.getMessageIdentification());
                BigInteger version = msg.getMessageVersion();
                if (version != null) {
                    messageData.setVersion(version);
                }
                if ((status = msg.getStatus()) != null) {
                    messageData.setStatus(status.value());
                }
                if ((interval = msg.getApplicationTimeInterval()) != null) {
                    if (interval.getStart() != null) {
                        messageData.setApplicationStartTime(interval.getStart().toGregorianCalendar());
                    }
                    if (interval.getEnd() != null) {
                        messageData.setApplicationEndTime(interval.getEnd().toGregorianCalendar());
                    }
                }
                messageData.setServerTimestamp(msg.getServerTimestamp().toGregorianCalendar());
                messageData.setType(msg.getType());
                messageData.setOwner(msg.getOwner());
                listMessageData.add(messageData);
            }
        }
        catch (JAXBException ex) {
            throw new ListOperationException(EnumErrorCatalog.ERR_LST_019, (Exception)((Object)ex), new String[]{ex.getMessage()});
        }
        return listMessageData;
    }
}

