/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.client.list;

import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.operations.list.ListOperationException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Calendar;

public final class MessageListEntry
implements Serializable {
    private static final long serialVersionUID = 1592261739373083411L;
    private BigInteger code = null;
    private String messageIdentification = null;
    private BigInteger version = null;
    private String status = null;
    private Calendar applicationStartTime = null;
    private Calendar applicationEndTime = null;
    private Calendar serverTimestamp = null;
    private String type = null;
    private String owner = null;
    private static final char NAME_VERSION_SEPARATOR = '.';

    public BigInteger getCode() {
        return this.code;
    }

    public void setCode(BigInteger cod) {
        this.code = cod;
    }

    public String getMessageIdentification() {
        return this.messageIdentification;
    }

    public void setMessageIdentification(String id) {
        this.messageIdentification = id;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public void setVersion(BigInteger ver) {
        this.version = ver;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String stat) {
        this.status = stat;
    }

    public Calendar getApplicationStartTime() {
        return this.applicationStartTime;
    }

    public void setApplicationStartTime(Calendar time) {
        this.applicationStartTime = time;
    }

    public Calendar getApplicationEndTime() {
        return this.applicationEndTime;
    }

    public void setApplicationEndTime(Calendar time) {
        this.applicationEndTime = time;
    }

    public Calendar getServerTimestamp() {
        return this.serverTimestamp;
    }

    public void setServerTimestamp(Calendar time) {
        this.serverTimestamp = time;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String typ) {
        this.type = typ;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String own) {
        this.owner = own;
    }

    public void checkMandatoryElements() throws ListOperationException {
        if (this.getCode() == null) {
            throw new ListOperationException(EnumErrorCatalog.ERR_LST_012, new String[0]);
        }
        String codeStr = this.code.toString();
        if (this.getMessageIdentification() == null) {
            throw new ListOperationException(EnumErrorCatalog.ERR_LST_013, new String[0]);
        }
        String idMsg = this.getMessageIdentification();
        idMsg = this.getVersion() == null ? this.getMessageIdentification() : this.getMessageIdentification() + '.' + this.getVersion();
        if (this.getType() == null) {
            throw new ListOperationException(EnumErrorCatalog.ERR_LST_014, new String[]{codeStr, idMsg});
        }
        if (this.getApplicationStartTime() == null) {
            throw new ListOperationException(EnumErrorCatalog.ERR_LST_015, new String[]{codeStr, idMsg, this.getType()});
        }
        if (this.getServerTimestamp() == null) {
            throw new ListOperationException(EnumErrorCatalog.ERR_LST_016, new String[]{codeStr, idMsg, this.getType()});
        }
        if (this.getOwner() == null) {
            throw new ListOperationException(EnumErrorCatalog.ERR_LST_017, new String[]{codeStr, idMsg, this.getType()});
        }
    }
}

