/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.client.put;

import ch.iec.tc57._2011.schema.message.RequestMessage;
import ch.iec.tc57._2011.schema.message.ResponseMessage;
import es.ree.eemws.client.common.ParentClient;
import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.iec61968100.EnumMessageFormat;
import es.ree.eemws.core.utils.iec61968100.EnumVerb;
import es.ree.eemws.core.utils.iec61968100.GenericCodedException;
import es.ree.eemws.core.utils.iec61968100.MessageUtil;
import es.ree.eemws.core.utils.operations.HandlerException;
import es.ree.eemws.core.utils.operations.put.PutOperationException;
import es.ree.eemws.core.utils.xml.XMLUtil;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public final class PutMessage
extends ParentClient {
    private static final boolean SIGN_REQUEST = true;
    private static final boolean VERIFY_RESPONSE_SIGNATURE = true;
    private static final String COMPRESS_XML_THRESHOLD_CHARS_KEY = "XML_TO_BINARY_THRESHOLD_CHARS";
    private static Long compressXmlThresholdChars = Long.getLong("XML_TO_BINARY_THRESHOLD_CHARS");

    public PutMessage() {
        this.setSignRequest(true);
        this.setVerifyResponse(true);
    }

    public String put(String name, byte[] data) throws PutOperationException {
        return this.put(name, data, null);
    }

    public ResponseMessage putWithResponseMessage(String name, byte[] data) throws PutOperationException {
        return this.putWithResponseMessage(name, data, null);
    }

    public String put(String name, byte[] data, EnumMessageFormat format) throws PutOperationException {
        String retValue = null;
        try {
            retValue = MessageUtil.responsePayload2String((ResponseMessage)this.putWithResponseMessage(name, data, format));
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new PutOperationException(EnumErrorCatalog.ERR_PUT_014, e, new String[]{e.getMessage()});
        }
        return retValue;
    }

    public ResponseMessage putWithResponseMessage(String name, byte[] data, EnumMessageFormat format) throws PutOperationException {
        ResponseMessage retValue = null;
        try {
            RequestMessage requestMessage = MessageUtil.createRequestWithBinaryPayload((String)name, (byte[])data, (EnumMessageFormat)format);
            retValue = this.sendMessage(requestMessage);
            this.validateResponse(retValue, true);
        }
        catch (HandlerException e) {
            throw new PutOperationException((GenericCodedException)e);
        }
        return retValue;
    }

    public String put(StringBuilder xmlMessage) throws PutOperationException {
        String retValue = null;
        try {
            retValue = MessageUtil.responsePayload2String((ResponseMessage)this.putWithResponseMessage(xmlMessage));
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new PutOperationException(EnumErrorCatalog.ERR_PUT_015, e, new String[]{e.getMessage()});
        }
        return retValue;
    }

    public ResponseMessage putWithResponseMessage(StringBuilder xmlMessage) throws PutOperationException {
        ResponseMessage retValue = null;
        try {
            RequestMessage requestMessage;
            if (compressXmlThresholdChars != null && (long)xmlMessage.length() > compressXmlThresholdChars) {
                requestMessage = MessageUtil.createRequestWithCompressedXmlPayload((StringBuilder)xmlMessage);
            } else {
                String noun = XMLUtil.getRootTag((StringBuilder)xmlMessage);
                requestMessage = MessageUtil.createRequestWithPayload((String)EnumVerb.CREATE.toString(), (String)noun, (StringBuilder)xmlMessage);
            }
            retValue = this.sendMessage(requestMessage);
            this.validateResponse(retValue, true);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new PutOperationException(EnumErrorCatalog.ERR_PUT_014, e, new String[]{e.getMessage()});
        }
        catch (HandlerException e) {
            throw new PutOperationException((GenericCodedException)e);
        }
        return retValue;
    }
}

