/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.client.querydata;

import ch.iec.tc57._2011.schema.message.RequestMessage;
import ch.iec.tc57._2011.schema.message.ResponseMessage;
import es.ree.eemws.client.common.ParentClient;
import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.iec61968100.EnumFilterElement;
import es.ree.eemws.core.utils.iec61968100.EnumNoun;
import es.ree.eemws.core.utils.iec61968100.EnumVerb;
import es.ree.eemws.core.utils.iec61968100.GenericCodedException;
import es.ree.eemws.core.utils.iec61968100.MessageUtil;
import es.ree.eemws.core.utils.operations.HandlerException;
import es.ree.eemws.core.utils.operations.query.QueryOperationException;
import es.ree.eemws.core.utils.operations.query.QueryRequestMessageValidator;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public final class QueryData
extends ParentClient {
    private static final boolean SIGN_REQUEST = false;
    private static final boolean VERIFY_RESPONSE_SIGNATURE = true;

    public QueryData() {
        this.setSignRequest(false);
        this.setVerifyResponse(true);
    }

    public String query(String dataType) throws QueryOperationException {
        return this.query(dataType, null, null, null);
    }

    public ResponseMessage queryWithResponseMessage(String dataType) throws QueryOperationException {
        return this.queryWithResponseMessage(dataType, null, null, null);
    }

    public String query(String dataType, Date startTime) throws QueryOperationException {
        return this.query(dataType, startTime, null, null);
    }

    public String query(String dataType, Date startTime, Date endTime) throws QueryOperationException {
        return this.query(dataType, startTime, endTime, null);
    }

    public String query(Map<String, String> msgOptions) throws QueryOperationException {
        String retValue = null;
        try {
            retValue = MessageUtil.responsePayload2String((ResponseMessage)this.queryWithResponseMessage(msgOptions));
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new QueryOperationException(EnumErrorCatalog.ERR_QRY_012, e, new String[]{e.getMessage()});
        }
        return retValue;
    }

    public ResponseMessage queryWithResponseMessage(Map<String, String> msgOptions) throws QueryOperationException {
        ResponseMessage retValue = null;
        try {
            RequestMessage requestMessage = MessageUtil.createRequestWithOptions((EnumVerb)EnumVerb.GET, (EnumNoun)EnumNoun.QUERY_DATA, msgOptions);
            QueryRequestMessageValidator.validate((RequestMessage)requestMessage);
            retValue = this.sendMessage(requestMessage);
            this.validateResponse(retValue, EnumNoun.QUERY_DATA.toString());
        }
        catch (HandlerException e) {
            throw new QueryOperationException((GenericCodedException)e);
        }
        return retValue;
    }

    public String query(String dataType, Date startTime, Date endTime, Map<String, String> others) throws QueryOperationException {
        return this.query(this.prepareOptions(dataType, startTime, endTime, others));
    }

    public ResponseMessage queryWithResponseMessage(String dataType, Date startTime, Date endTime, Map<String, String> others) throws QueryOperationException {
        return this.queryWithResponseMessage(this.prepareOptions(dataType, startTime, endTime, others));
    }

    private Map<String, String> prepareOptions(String dataType, Date startTime, Date endTime, Map<String, String> others) {
        DateFormat df;
        HashMap<String, String> msgOptions = new HashMap<String, String>(others);
        msgOptions.put(EnumFilterElement.DATA_TYPE.toString(), dataType);
        if (startTime != null) {
            df = DateFormat.getInstance();
            msgOptions.put(EnumFilterElement.START_TIME.toString(), df.format(startTime));
        }
        if (endTime != null) {
            df = DateFormat.getInstance();
            msgOptions.put(EnumFilterElement.END_TIME.toString(), df.format(endTime));
        }
        return msgOptions;
    }
}

