/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.config;

import es.ree.eemws.core.utils.config.ConfigException;
import es.ree.eemws.core.utils.file.FileUtil;
import es.ree.eemws.core.utils.i18n.Messages;
import es.ree.eemws.core.utils.security.CryptoException;
import es.ree.eemws.core.utils.security.CryptoManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ConfigManager {
    private Properties config = new Properties();
    private static final String KEY_STORE = "javax.net.ssl.keyStore";
    private static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String KEY_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String KEY_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String KEY_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String DEFAULT_KEY_STORE_TYPE = "PKCS12";
    private static final String DEFAULT_TRUST_STORE_TYPE = "JKS";
    private static final String DEFAULT_KEY_STORE_PASSWORD = "";
    private static final String[] SYSTEM_KEYS = new String[]{"javax.net.ssl.trustStore", "javax.net.ssl.trustStorePassword", "javax.net.ssl.trustStoreType", "javax.net.ssl.keyStore", "javax.net.ssl.keyStorePassword", "javax.net.ssl.keyStoreType", "https.proxyHost", "https.proxyPort", "https.proxyUser", "https.proxyPassword"};
    private static final String PASSWORD_TOKEN = "PASSWORD";
    private static final String NEW_LINE = "\n";
    private static final String EQUALS = "=";

    public Properties readConfigFile(String configFileName) throws ConfigException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (InputStream isProps = loader.getResourceAsStream(configFileName);){
            File configFile;
            if (isProps == null) {
                throw new ConfigException(Messages.getString("CONFIG_UNABLE_TO_READ_CONFIG_FILE", configFileName));
            }
            this.config = new Properties();
            this.config.load(isProps);
            boolean shouldCypherFile = this.clearPasswords();
            this.loadAndCheckSecurityConfig();
            this.setSystem();
            if (shouldCypherFile && (configFile = new File(FileUtil.getFullPathOfResoruce(configFileName))).canWrite()) {
                this.cypherFile(configFile);
            }
        }
        catch (IOException e) {
            throw new ConfigException(Messages.getString("CONFIG_UNABLE_TO_READ_CONFIG_FILE", configFileName), e);
        }
        return this.config;
    }

    public String getValue(String key) {
        return this.config.getProperty(key);
    }

    public String getValue(String key, String defaultValue) {
        return this.config.getProperty(key, defaultValue);
    }

    private void cypherFile(File configFile) throws ConfigException {
        String failedKey = DEFAULT_KEY_STORE_PASSWORD;
        try {
            String fullFilePath = configFile.getAbsolutePath();
            String[] fullFileConfig = FileUtil.read(fullFilePath).split(NEW_LINE);
            StringBuilder bul = new StringBuilder();
            for (String line : fullFileConfig) {
                String[] pair;
                String key;
                if (!line.trim().startsWith("#") && line.toUpperCase().indexOf(PASSWORD_TOKEN) != -1 && line.indexOf(EQUALS) != -1 && (key = (pair = line.split(EQUALS))[0]).toUpperCase().indexOf(PASSWORD_TOKEN) != -1 && this.config.containsKey(key)) {
                    String value = pair[1].trim();
                    String configValue = this.config.getProperty(key);
                    if (configValue.equals(value)) {
                        failedKey = key;
                        value = CryptoManager.encrypt(value);
                        line = key + EQUALS + value;
                    }
                }
                bul.append(line);
                bul.append(NEW_LINE);
            }
            FileUtil.write(fullFilePath, bul.toString());
        }
        catch (CryptoException e) {
            throw new ConfigException(Messages.getString("CONFIG_UNABLE_TO_CIPHER_PASSWORD", failedKey), e);
        }
        catch (IOException e) {
            throw new ConfigException(Messages.getString("CONFIG_UNABLE_TO_SAVE_CONFIG", new Object[0]), e);
        }
    }

    private boolean clearPasswords() throws ConfigException {
        boolean hasPasswordEntryClear = false;
        String failedKey = DEFAULT_KEY_STORE_PASSWORD;
        try {
            Set<Map.Entry<Object, Object>> configKeysAndValues = this.config.entrySet();
            for (Map.Entry<Object, Object> keyAndValue : configKeysAndValues) {
                String key = (String)keyAndValue.getKey();
                String value = (String)keyAndValue.getValue();
                if (key.toUpperCase().indexOf(PASSWORD_TOKEN) == -1) continue;
                failedKey = key;
                String clearValue = CryptoManager.decrypt(value);
                if (clearValue.equals(value)) {
                    hasPasswordEntryClear = true;
                }
                keyAndValue.setValue(clearValue);
            }
        }
        catch (CryptoException e) {
            throw new ConfigException(Messages.getString("CONFIG_UNABLE_TO_DECRYPT_PASSWORD", failedKey), e);
        }
        return hasPasswordEntryClear;
    }

    private void loadAndCheckSecurityConfig() throws ConfigException {
        if (this.config.getProperty(KEY_STORE_TYPE) == null) {
            this.config.setProperty(KEY_STORE_TYPE, DEFAULT_KEY_STORE_TYPE);
        }
        if (this.config.getProperty(KEY_TRUST_STORE_PASSWORD) == null) {
            this.config.setProperty(KEY_TRUST_STORE_PASSWORD, DEFAULT_KEY_STORE_PASSWORD);
        }
        if (this.config.getProperty(KEY_TRUST_STORE_TYPE) == null) {
            this.config.setProperty(KEY_TRUST_STORE_TYPE, DEFAULT_TRUST_STORE_TYPE);
        }
        this.loadAndCheckSecurityConfig(this.config.getProperty(KEY_STORE), this.config.getProperty(KEY_STORE_PASSWORD), this.config.getProperty(KEY_STORE_TYPE));
    }

    private void loadAndCheckSecurityConfig(String certFile, String passwd, String type) throws ConfigException {
        if (certFile != null) {
            try (FileInputStream isCertFile = new FileInputStream(certFile);){
                File f = new File(certFile);
                if (!f.canRead()) {
                    throw new ConfigException(Messages.getString("CONFIG_UNABLE_TO_READ_KEY_STORE", certFile));
                }
                KeyStore ks = KeyStore.getInstance(type);
                ks.load(isCertFile, passwd.toCharArray());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new ConfigException(Messages.getString("CONFIG_UNABLE_TO_LOAD_KEY_STORE", certFile), e);
            }
        }
    }

    private void setSystem() {
        for (String key : SYSTEM_KEYS) {
            String value = this.config.getProperty(key);
            if (value == null) continue;
            System.setProperty(key, value);
        }
    }
}

