/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.file;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public final class FileUtil {
    private static final int UTF8_BOM_HEADER = 65279;
    private static final String BACKUP_EXTENSION = ".bak_";

    private FileUtil() {
    }

    public static String read(String fullFileName) throws IOException {
        return Charset.defaultCharset().decode(ByteBuffer.wrap(Files.readAllBytes(Paths.get(fullFileName, new String[0])))).toString();
    }

    public static String readUTF8(String fullFileName) throws IOException {
        CharBuffer cb = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(Files.readAllBytes(Paths.get(fullFileName, new String[0]))));
        if (cb.length() > 1 && cb.charAt(0) == '\ufeff') {
            cb.get();
        }
        return cb.toString();
    }

    public static String read(String fullFileName, Charset encoding) throws IOException {
        return encoding.decode(ByteBuffer.wrap(Files.readAllBytes(Paths.get(fullFileName, new String[0])))).toString();
    }

    public static byte[] readBinary(String fullFileName) throws IOException {
        return Files.readAllBytes(Paths.get(fullFileName, new String[0]));
    }

    public static void write(String fullFileName, String content) throws IOException {
        Files.write(Paths.get(fullFileName, new String[0]), content.getBytes(Charset.defaultCharset()), StandardOpenOption.CREATE);
    }

    public static void write(String fullFileName, byte[] content) throws IOException {
        Files.write(Paths.get(fullFileName, new String[0]), content, StandardOpenOption.CREATE);
    }

    public static void writeUTF8(String fullFileName, String content) throws IOException {
        Files.write(Paths.get(fullFileName, new String[0]), content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
    }

    public static void write(String fullFileName, String content, Charset encoding) throws IOException {
        Files.write(Paths.get(fullFileName, new String[0]), content.getBytes(encoding), StandardOpenOption.CREATE);
    }

    public static boolean exists(String fullFileName) {
        return Files.exists(Paths.get(fullFileName, new String[0]), new LinkOption[0]);
    }

    public static String createBackup(String fullFileName) {
        String retValue = fullFileName;
        File f = new File(fullFileName);
        File f2 = new File(fullFileName);
        if (f.exists()) {
            int n = 1;
            while (f2.exists()) {
                f2 = new File(fullFileName + BACKUP_EXTENSION + n);
                ++n;
            }
            retValue = f.renameTo(f2) ? f2.getAbsolutePath() : null;
        }
        return retValue;
    }

    public static String getFullPathOfResoruce(String resourceName) {
        String retValue;
        try {
            retValue = new File(Thread.currentThread().getContextClassLoader().getResource(resourceName).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            retValue = null;
        }
        return retValue;
    }
}

