/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class GZIPUtil {
    private static final int BUFFER_SIZE = 1024;

    private GZIPUtil() {
    }

    public static byte[] compress(byte[] dataToCompress) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(dataToCompress.length);
        try (GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
            zipStream.write(dataToCompress);
        }
        return byteStream.toByteArray();
    }

    public static byte[] uncompress(byte[] contentBytes) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(contentBytes));){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = gzis.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

