/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.iec61968100;

import _504.iec62325.wss._1._0.MsgFaultMsg;
import ch.iec.tc57._2011.schema.message.ErrorType;
import ch.iec.tc57._2011.schema.message.FaultMessage;
import ch.iec.tc57._2011.schema.message.ReplyType;
import es.ree.eemws.core.utils.iec61968100.EnumMessageStatus;
import es.ree.eemws.core.utils.iec61968100.GenericCodedException;
import es.ree.eemws.core.utils.iec61968100.MessageMetaData;

public final class FaultUtil {
    private FaultUtil() {
    }

    public static FaultMessage getFaultMessageFromException(String msg, String code) {
        FaultMessage faultMessage = new FaultMessage();
        ReplyType replyType = new ReplyType();
        replyType.setResult(EnumMessageStatus.FAILED.toString());
        ErrorType errorType = new ErrorType();
        errorType.setDetails(msg);
        if (code != null) {
            errorType.setCode(code);
        }
        replyType.getErrors().add(errorType);
        faultMessage.setReply(replyType);
        return faultMessage;
    }

    public static MsgFaultMsg getMsgFaultFromException(GenericCodedException exception) {
        return new MsgFaultMsg(exception.getMessage(), FaultUtil.getFaultMessageFromException(exception.getMessage(), exception.getCode()));
    }

    public static MsgFaultMsg getMsgFaultFromMessage(String msg) {
        return new MsgFaultMsg(msg, FaultUtil.getFaultMessageFromException(msg, null));
    }

    public static MsgFaultMsg getMsgFaultFromMetaData(MessageMetaData mmd) {
        MsgFaultMsg msgFaultMsg = mmd.getException() == null ? FaultUtil.getMsgFaultFromMessage(mmd.getRejectText()) : FaultUtil.getMsgFaultFromException(mmd.getException());
        return msgFaultMsg;
    }
}

