/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.iec61968100;

import es.ree.eemws.core.utils.iec61968100.EnumMessageStatus;
import es.ree.eemws.core.utils.iec61968100.GenericCodedException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public final class MessageMetaData
implements Serializable {
    private static final long serialVersionUID = -4872587875516287663L;
    public static final String META_DATA_CONTEXT_KEY = "MSG_META_DATA";
    private Calendar serverTimestamp = null;
    private X509Certificate httpCertificate = null;
    private X509Certificate signCertificate = null;
    private String remoteUser = null;
    private String owner = null;
    private List<String> userRoles = new ArrayList<String>();
    private Long msgCode = null;
    private String messageType = null;
    private EnumMessageStatus status = EnumMessageStatus.OK;
    private String rejectText = null;
    private GenericCodedException exception;
    private boolean ignorable = false;

    public MessageMetaData() {
        this.serverTimestamp = Calendar.getInstance();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String own) {
        this.owner = own;
    }

    public Calendar getServerTimestamp() {
        return this.serverTimestamp;
    }

    public void setServerTimestamp(Calendar date) {
        this.serverTimestamp = date;
    }

    public X509Certificate getHttpCertificate() {
        return this.httpCertificate;
    }

    public void setHttpCertificate(X509Certificate x509Certificate) {
        this.httpCertificate = x509Certificate;
    }

    public void setSignatureCertificate(X509Certificate x509Certificate) {
        this.signCertificate = x509Certificate;
    }

    public X509Certificate getSignatureCertificate() {
        return this.signCertificate;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String inRemoteUser) {
        this.remoteUser = inRemoteUser;
    }

    public List<String> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(List<String> inRoles) {
        this.userRoles = inRoles;
    }

    public Long getCode() {
        return this.msgCode;
    }

    public void setCode(Long inCode) {
        this.msgCode = inCode;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String type) {
        this.messageType = type;
    }

    public void setException(GenericCodedException ex) {
        if (ex != null) {
            this.status = EnumMessageStatus.FAILED;
        }
        this.exception = ex;
    }

    public GenericCodedException getException() {
        return this.exception;
    }

    public EnumMessageStatus getStatus() {
        return this.status;
    }

    public void setStatus(EnumMessageStatus inStatus) {
        this.status = inStatus;
    }

    public String getRejectText() {
        if (this.rejectText == null && this.exception != null) {
            this.rejectText = this.exception.getMessage();
        }
        return this.rejectText;
    }

    public void setRejectText(String inRejectText) {
        if (inRejectText != null) {
            this.status = EnumMessageStatus.FAILED;
            if (this.rejectText != null) {
                if (this.rejectText.indexOf(inRejectText) == -1) {
                    this.rejectText = this.rejectText + " / " + inRejectText;
                }
            } else {
                this.rejectText = inRejectText;
            }
        }
    }

    public boolean isIgnorable() {
        return this.ignorable;
    }

    public void setIgnorable(boolean ign) {
        if (ign) {
            this.setStatus(EnumMessageStatus.FAILED);
        }
        this.ignorable = ign;
    }
}

