/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.iec61968100;

import ch.iec.tc57._2011.schema.message.HeaderType;
import ch.iec.tc57._2011.schema.message.OptionType;
import ch.iec.tc57._2011.schema.message.PayloadType;
import ch.iec.tc57._2011.schema.message.ReplyType;
import ch.iec.tc57._2011.schema.message.RequestMessage;
import ch.iec.tc57._2011.schema.message.RequestType;
import ch.iec.tc57._2011.schema.message.ResponseMessage;
import es.ree.eemws.core.utils.file.GZIPUtil;
import es.ree.eemws.core.utils.i18n.Messages;
import es.ree.eemws.core.utils.iec61968100.EnumFilterElement;
import es.ree.eemws.core.utils.iec61968100.EnumMessageFormat;
import es.ree.eemws.core.utils.iec61968100.EnumMessageStatus;
import es.ree.eemws.core.utils.iec61968100.EnumNoun;
import es.ree.eemws.core.utils.iec61968100.EnumVerb;
import es.ree.eemws.core.utils.iec61968100.StringBuilderMessage;
import es.ree.eemws.core.utils.xml.XMLElementUtil;
import es.ree.eemws.core.utils.xml.XMLGregorianCalendarFactory;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class MessageUtil {
    private static final String IEC_61968_100_SCHEMA_FILE = "http-iec-ch-TC57-2011-schema-message.xsd";

    private MessageUtil() {
    }

    public static RequestMessage createRequestWithOptions(EnumVerb verb, EnumNoun noun, Map<String, String> options) {
        return MessageUtil.createRequestWithOptions(verb.toString(), noun.toString(), options);
    }

    public static RequestMessage createRequestWithOptions(String verb, String noun, Map<String, String> options) {
        RequestMessage message = new RequestMessage();
        message.setHeader(MessageUtil.createHeader(verb, noun));
        RequestType resquest = new RequestType();
        if (options != null && !options.isEmpty()) {
            Set<Map.Entry<String, String>> entries = options.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                try {
                    DateFormat df;
                    String key = entry.getKey();
                    if (key.equals(EnumFilterElement.START_TIME.toString())) {
                        df = DateFormat.getInstance();
                        resquest.setStartTime(XMLGregorianCalendarFactory.getGMTInstance(df.parse(entry.getValue())));
                        continue;
                    }
                    if (key.equals(EnumFilterElement.END_TIME.toString())) {
                        df = DateFormat.getInstance();
                        resquest.setEndTime(XMLGregorianCalendarFactory.getGMTInstance(df.parse(entry.getValue())));
                        continue;
                    }
                    OptionType option = MessageUtil.createOption(key, entry.getValue());
                    resquest.getOptions().add(option);
                }
                catch (ParseException e) {
                    Logger.getLogger(".").fine("Invalid date parameter [" + entry.getKey() + "=" + entry.getValue() + "]");
                }
            }
        }
        message.setRequest(resquest);
        return message;
    }

    public static Map<String, Object> getRequestMessageOptions(RequestMessage message) {
        return MessageUtil.getInternalRequestMessageOptions(message, false);
    }

    public static Map<String, Object> getRequestMessageOptionsAllowingErrors(RequestMessage message) {
        return MessageUtil.getInternalRequestMessageOptions(message, true);
    }

    private static Map<String, Object> getInternalRequestMessageOptions(RequestMessage message, boolean allowInvalidValues) {
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        boolean stopIfError = !allowInvalidValues;
        RequestType msgRequest = message.getRequest();
        if (msgRequest == null) {
            if (stopIfError) {
                throw new IllegalArgumentException(Messages.getString("REQUEST_MESSAGE_HAS_NO_REQUEST", new Object[0]));
            }
        } else {
            List msgOptions;
            String startElementStr = EnumFilterElement.START_TIME.toString();
            String endElementStr = EnumFilterElement.END_TIME.toString();
            XMLGregorianCalendar time = msgRequest.getStartTime();
            if (time != null) {
                retValue.put(startElementStr, time);
            }
            if ((time = msgRequest.getEndTime()) != null) {
                retValue.put(endElementStr, time);
            }
            if ((msgOptions = msgRequest.getOptions()) != null) {
                for (OptionType optionType : msgOptions) {
                    Object obj;
                    Object optValue;
                    String optName;
                    block12: {
                        optName = optionType.getName();
                        optValue = optionType.getValue();
                        obj = null;
                        if (optName.equals(startElementStr) || optName.equals(endElementStr)) {
                            try {
                                optValue = XMLGregorianCalendarFactory.getInstance((String)optValue);
                            }
                            catch (ParseException e) {
                                if (!stopIfError) break block12;
                                throw new IllegalArgumentException(Messages.getString("INVALID_DATE_PARAMETER_VALUE", optName));
                            }
                        }
                    }
                    if ((obj = retValue.put(optName, optValue)) == null) continue;
                    if (stopIfError) {
                        throw new IllegalArgumentException(Messages.getString("INVALID_PARAMETER_TWICE", optName));
                    }
                    int cont = 1;
                    StringBuilder key = new StringBuilder();
                    key.append(optName).append("(").append(cont).append(")");
                    while (retValue.containsKey(key.toString())) {
                        key.setLength(0);
                        key.append(optName).append("(").append(++cont).append(")");
                    }
                    retValue.put(key.toString(), obj);
                }
            }
        }
        return retValue;
    }

    private static HeaderType createHeader(String verb, String noun) {
        HeaderType header = new HeaderType();
        header.setVerb(verb);
        header.setNoun(noun);
        header.setTimestamp(XMLGregorianCalendarFactory.getGMTInstanceMs(new Date()));
        return header;
    }

    private static OptionType createOption(String name, String value) {
        OptionType option = new OptionType();
        option.setName(name);
        if (value != null) {
            option.setValue(value);
        }
        return option;
    }

    public static RequestMessage createRequestWithPayload(String verb, String noun, StringBuilder xmlMessage) throws ParserConfigurationException, SAXException, IOException {
        RequestMessage message = new RequestMessage();
        message.setHeader(MessageUtil.createHeader(verb, noun));
        Element xml = XMLElementUtil.string2Element(xmlMessage.toString());
        PayloadType payload = new PayloadType();
        payload.getAnies().add(xml);
        message.setPayload(payload);
        return message;
    }

    public static RequestMessage createRequestWithCompressedXmlPayload(StringBuilder xmlMessage) throws IOException {
        byte[] compressedPayload = GZIPUtil.compress(xmlMessage.toString().getBytes(StandardCharsets.UTF_8));
        return MessageUtil.createRequestWithBinaryPayload(null, compressedPayload, EnumMessageFormat.XML);
    }

    public static RequestMessage createRequestWithBinaryPayload(String name, StringBuilder binaryB64, EnumMessageFormat format) {
        RequestMessage message = new RequestMessage();
        HeaderType header = MessageUtil.createHeader(EnumVerb.CREATE.toString(), EnumNoun.COMPRESSED.toString());
        message.setHeader(header);
        if (name != null) {
            RequestType resquest = new RequestType();
            RequestType.ID id = new RequestType.ID();
            id.setIdType("name");
            id.setValue(name);
            List ids = resquest.getIDS();
            ids.add(id);
            message.setRequest(resquest);
        }
        PayloadType payload = new PayloadType();
        payload.setCompressed(binaryB64.toString());
        if (format == null) {
            payload.setFormat(EnumMessageFormat.XML.toString());
        } else {
            payload.setFormat(format.toString());
        }
        message.setPayload(payload);
        return message;
    }

    public static RequestMessage createRequestWithBinaryPayload(String name, byte[] binary, EnumMessageFormat format) {
        return MessageUtil.createRequestWithBinaryPayload(name, new StringBuilder(DatatypeConverter.printBase64Binary((byte[])binary)), format);
    }

    public static ResponseMessage createResponseWithPayload(EnumNoun noun, EnumMessageStatus status, Element msgPayload) {
        return MessageUtil.createResponseWithPayload(noun.toString(), status, msgPayload);
    }

    public static ResponseMessage createResponseWithPayload(String noun, EnumMessageStatus status, Element msgPayload) {
        ResponseMessage response = new ResponseMessage();
        response.setHeader(MessageUtil.createHeader(EnumVerb.REPLY.toString(), noun));
        ReplyType reply = new ReplyType();
        reply.setResult(status.getStatus());
        response.setReply(reply);
        PayloadType payLoad = new PayloadType();
        response.setPayload(payLoad);
        payLoad.getAnies().add(msgPayload);
        return response;
    }

    public static ResponseMessage createResponseWithNoPayload(EnumMessageStatus status) {
        ResponseMessage response = new ResponseMessage();
        response.setHeader(MessageUtil.createHeader(EnumVerb.REPLY.toString(), EnumNoun.EMPTY.toString()));
        ReplyType reply = new ReplyType();
        reply.setResult(status.getStatus());
        response.setReply(reply);
        PayloadType payLoad = new PayloadType();
        response.setPayload(payLoad);
        return response;
    }

    public static ResponseMessage createResponseWithBinaryPayload(EnumMessageStatus status, String name, byte[] binary, EnumMessageFormat format) {
        return MessageUtil.createResponseWithBinaryPayload(status, name, new StringBuilder(DatatypeConverter.printBase64Binary((byte[])binary)), format);
    }

    public static ResponseMessage createResponseWithBinaryPayload(EnumMessageStatus status, String name, StringBuilder binaryB64, EnumMessageFormat format) {
        ResponseMessage response = new ResponseMessage();
        response.setHeader(MessageUtil.createHeader(EnumVerb.REPLY.toString(), EnumNoun.COMPRESSED.toString()));
        ReplyType reply = new ReplyType();
        reply.setResult(status.getStatus());
        ReplyType.ID id = new ReplyType.ID();
        reply.getIDS().add(id);
        id.setIdType("name");
        id.setValue(name);
        response.setReply(reply);
        PayloadType payLoad = new PayloadType();
        response.setPayload(payLoad);
        payLoad.setCompressed(binaryB64.toString());
        if (format == null) {
            payLoad.setFormat(EnumMessageFormat.XML.toString());
        } else {
            payLoad.setFormat(format.toString());
        }
        return response;
    }

    public static void validateMessage(StringBuilderMessage msg) throws SAXException {
        MessageUtil.validateMessage(msg.getStringMessage());
    }

    public static void validateMessage(StringBuilder stringMessage) throws SAXException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL schemaUrl = loader.getResource(IEC_61968_100_SCHEMA_FILE);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaUrl);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(stringMessage.toString())));
        }
        catch (IOException | NullPointerException e) {
            Logger.getLogger(".").log(Level.FINE, "Unable to read message", e);
        }
    }

    public static String responsePayload2String(ResponseMessage responseMessage) throws TransformerException, ParserConfigurationException {
        String retValue = null;
        PayloadType payload = responseMessage.getPayload();
        List anies = payload.getAnies();
        if (!anies.isEmpty()) {
            retValue = XMLElementUtil.element2String((Element)payload.getAnies().get(0));
        }
        return retValue;
    }
}

