/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.iec61968100;

import _504.iec62325.wss._1._0.MsgFaultMsg;
import ch.iec.tc57._2011.schema.message.FaultMessage;
import es.ree.eemws.core.utils.i18n.Messages;
import es.ree.eemws.core.utils.iec61968100.EnumMessageStatus;
import es.ree.eemws.core.utils.xml.XMLElementUtil;
import es.ree.eemws.core.utils.xml.XMLUtil;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.xml.sax.SAXException;

public final class StringBuilderMessage {
    private static final String TAG_MSG_PAYLOAD = "Payload";
    private static final String TAG_MSG_FORMAT = "Format";
    private static final String EMPTY_FORMAT_TAG_END = "Format/>";
    private static final String NON_EMPTY_FORMAT_TAG_END = "Format>";
    private static final String TAG_MSG_FAULT = "FaultMessage";
    private static final String TAG_DETAILS_FAULT = "details";
    private static final int MAX_LENGTH_TEST = 100;
    private static final int START_TAG_CHAR = 60;
    private static final String SOAP_BODY_TAG = "Body";
    private StringBuilder messageStr = null;

    public StringBuilderMessage(SOAPMessageContext context) throws SOAPException {
        try {
            this.messageStr = new StringBuilder(XMLUtil.getNodeValue(SOAP_BODY_TAG, new StringBuilder(XMLUtil.soapMessage2String(context.getMessage()))));
        }
        catch (NullPointerException e) {
            throw new SOAPException(Messages.getString("IEC_UNABLE_TO_RETRIEVE_FROM_CONTEXT", new Object[0]), (Throwable)e);
        }
    }

    public StringBuilderMessage() {
    }

    public void setStringMessage(StringBuilderMessage anotherMessage) {
        this.messageStr = anotherMessage.getStringMessage();
    }

    public StringBuilder getStringMessage() {
        return this.messageStr;
    }

    public String getNoun() {
        return this.getElement("Noun");
    }

    public String getVerb() {
        return this.getElement("Verb");
    }

    private String getElement(String elementName) {
        String retValue = null;
        if (this.messageStr != null) {
            retValue = XMLUtil.getNodeValue(elementName, this.messageStr);
        }
        return retValue;
    }

    public String getStringMessageNoPayload() {
        String retValue = null;
        if (this.messageStr != null) {
            int pos;
            String payLoad = this.getPayload();
            retValue = payLoad == null ? this.messageStr.toString() : ((pos = this.messageStr.indexOf(payLoad)) == -1 ? this.messageStr.toString() : this.messageStr.substring(0, pos) + this.messageStr.substring(pos + payLoad.length()));
        }
        return retValue;
    }

    public String getPayload() {
        String payL = this.getElement(TAG_MSG_PAYLOAD);
        if (payL != null) {
            int payLen = payL.length();
            String testStr = payLen > 100 ? payL.substring(payLen - 100, payLen).trim() : payL.trim();
            if (testStr.endsWith(EMPTY_FORMAT_TAG_END)) {
                payL = payL.substring(0, payL.lastIndexOf(60));
            } else if (testStr.endsWith(NON_EMPTY_FORMAT_TAG_END)) {
                int k;
                for (k = payL.lastIndexOf(60) - 1; payL.charAt(k) != '<' && k > 0; --k) {
                }
                payL = payL.substring(0, k);
            }
        }
        return payL;
    }

    public MsgFaultMsg getFault() {
        MsgFaultMsg retValue = null;
        if (this.messageStr != null) {
            try {
                FaultMessage fm = (FaultMessage)XMLElementUtil.element2Obj(XMLElementUtil.string2Element(XMLUtil.getNodeValue(TAG_MSG_FAULT, this.messageStr)), FaultMessage.class);
                String msg = XMLUtil.getNodeValue(TAG_DETAILS_FAULT, this.messageStr);
                if (msg == null) {
                    msg = "";
                }
                retValue = new MsgFaultMsg(msg, fm);
            }
            catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
                retValue = null;
            }
        }
        return retValue;
    }

    public EnumMessageStatus getStatus() {
        EnumMessageStatus retValue = null;
        String result = this.getElement("Result");
        if (result != null) {
            retValue = EnumMessageStatus.fromString(result);
        }
        return retValue;
    }
}

