/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.operations.get;

import ch.iec.tc57._2011.schema.message.RequestMessage;
import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.iec61968100.EnumFilterElement;
import es.ree.eemws.core.utils.iec61968100.EnumQueue;
import es.ree.eemws.core.utils.iec61968100.MessageUtil;
import es.ree.eemws.core.utils.operations.get.GetOperationException;
import java.util.HashSet;
import java.util.Map;

public final class GetRequestMessageValidator {
    public static Map<String, Object> validate(RequestMessage message) throws GetOperationException {
        Map<String, Object> getParameters = GetRequestMessageValidator.validateParametersValues(message);
        GetRequestMessageValidator.validateParametersNames(getParameters);
        return getParameters;
    }

    private static Map<String, Object> validateParametersValues(RequestMessage message) throws GetOperationException {
        Map<String, Object> getParameters;
        block15: {
            getParameters = null;
            try {
                String ver;
                getParameters = MessageUtil.getRequestMessageOptions(message);
                boolean getByCode = getParameters.get(EnumFilterElement.CODE.toString()) != null;
                boolean getByQueue = getParameters.get(EnumFilterElement.QUEUE.toString()) != null;
                boolean getById = getParameters.get(EnumFilterElement.MESSAGE_IDENTIFICATION.toString()) != null;
                int numGet = 0;
                if (getByCode) {
                    ++numGet;
                }
                if (getByQueue) {
                    ++numGet;
                }
                if (getById) {
                    ++numGet;
                }
                if (numGet > 1) {
                    throw new GetOperationException(EnumErrorCatalog.ERR_GET_003, new String[0]);
                }
                if (numGet == 0) {
                    throw new GetOperationException(EnumErrorCatalog.ERR_GET_004, new String[0]);
                }
                if (getByQueue) {
                    String queue = (String)getParameters.get(EnumFilterElement.QUEUE.toString());
                    if (!EnumQueue.NEXT.toString().equals(queue)) {
                        throw new GetOperationException(EnumErrorCatalog.ERR_GET_017, EnumQueue.NEXT.toString(), queue);
                    }
                    break block15;
                }
                if (getByCode) {
                    String val = (String)getParameters.get(EnumFilterElement.CODE.toString());
                    try {
                        Long code = Long.parseLong(val);
                        if (code < 0L) {
                            throw new GetOperationException(EnumErrorCatalog.ERR_GET_001, new String[0]);
                        }
                        break block15;
                    }
                    catch (NumberFormatException e) {
                        throw new GetOperationException(EnumErrorCatalog.ERR_GET_002, new String[0]);
                    }
                }
                if (!getById || (ver = (String)getParameters.get(EnumFilterElement.MESSAGE_VERSION.toString())) == null) break block15;
                try {
                    Integer.valueOf(ver);
                }
                catch (NumberFormatException e) {
                    throw new GetOperationException(EnumErrorCatalog.ERR_GET_019, ver);
                }
            }
            catch (IllegalArgumentException e) {
                throw new GetOperationException(EnumErrorCatalog.ERR_GET_011, e.getMessage());
            }
        }
        return getParameters;
    }

    private static void validateParametersNames(Map<String, Object> getParameters) throws GetOperationException {
        HashSet<String> parameterNames = new HashSet<String>(getParameters.keySet());
        parameterNames.remove(EnumFilterElement.MESSAGE_IDENTIFICATION.toString());
        parameterNames.remove(EnumFilterElement.MESSAGE_VERSION.toString());
        parameterNames.remove(EnumFilterElement.QUEUE.toString());
        parameterNames.remove(EnumFilterElement.CODE.toString());
        if (!parameterNames.isEmpty()) {
            throw new GetOperationException(EnumErrorCatalog.ERR_GET_012, (String)parameterNames.iterator().next());
        }
    }

    private GetRequestMessageValidator() {
    }
}

