/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.operations.list;

import ch.iec.tc57._2011.schema.message.RequestMessage;
import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.iec61968100.EnumFilterElement;
import es.ree.eemws.core.utils.iec61968100.EnumIntervalTimeType;
import es.ree.eemws.core.utils.iec61968100.EnumParameterLimit;
import es.ree.eemws.core.utils.iec61968100.MessageUtil;
import es.ree.eemws.core.utils.operations.OperationLimits;
import es.ree.eemws.core.utils.operations.list.ListOperationException;
import java.util.HashSet;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;

public final class ListRequestMessageValidator {
    private static final Integer DAYS_TO_MILLISECONDS = 86400000;

    public static Map<String, Object> validate(RequestMessage message) throws ListOperationException {
        return ListRequestMessageValidator.validate(message, null);
    }

    public static Map<String, Object> validate(RequestMessage message, OperationLimits limits) throws ListOperationException {
        Map<String, Object> listParameters = ListRequestMessageValidator.validateParametersValues(message, limits);
        ListRequestMessageValidator.validateParametersNames(listParameters);
        return listParameters;
    }

    private static Map<String, Object> validateParametersValues(RequestMessage message, OperationLimits limits) throws ListOperationException {
        Map<String, Object> listParameters;
        block13: {
            listParameters = null;
            try {
                EnumIntervalTimeType intervalT;
                boolean listByCode;
                listParameters = MessageUtil.getRequestMessageOptions(message);
                XMLGregorianCalendar startTime = (XMLGregorianCalendar)listParameters.get(EnumFilterElement.START_TIME.toString());
                XMLGregorianCalendar endTime = (XMLGregorianCalendar)listParameters.get(EnumFilterElement.END_TIME.toString());
                boolean bl = listByCode = listParameters.get(EnumFilterElement.CODE.toString()) != null;
                if (listByCode && (startTime != null || endTime != null) || !listByCode && (startTime == null || endTime == null) || listByCode && listParameters.get(EnumFilterElement.INTERVAL_TYPE.toString()) != null) {
                    throw new ListOperationException(EnumErrorCatalog.ERR_LST_005, new String[0]);
                }
                if (listByCode) {
                    String val = (String)listParameters.get(EnumFilterElement.CODE.toString());
                    try {
                        long code = Long.parseLong(val);
                        if (code < 0L) {
                            throw new ListOperationException(EnumErrorCatalog.ERR_LST_001, new String[0]);
                        }
                        break block13;
                    }
                    catch (NumberFormatException e) {
                        throw new ListOperationException(EnumErrorCatalog.ERR_LST_002, new String[0]);
                    }
                }
                String interval = (String)listParameters.get(EnumFilterElement.INTERVAL_TYPE.toString());
                if (interval == null) {
                    intervalT = EnumIntervalTimeType.DEFAULT_INTERVAL_TYPE;
                } else {
                    intervalT = EnumIntervalTimeType.fromString(interval);
                    if (intervalT == null) {
                        throw new ListOperationException(EnumErrorCatalog.ERR_LST_009, EnumIntervalTimeType.getList());
                    }
                }
                listParameters.put(EnumFilterElement.INTERVAL_TYPE.toString(), (Object)intervalT);
                if (endTime.compare(startTime) == -1) {
                    throw new ListOperationException(EnumErrorCatalog.ERR_LST_003, new String[0]);
                }
                if (limits != null) {
                    Integer maxAllowedInterval = null;
                    maxAllowedInterval = intervalT.equals((Object)EnumIntervalTimeType.APPLICATION) ? limits.getLimit(EnumParameterLimit.MAX_APPLICATION_TIME_INTERVAL_IN_DAYS_IN_LIST_REQUEST) : limits.getLimit(EnumParameterLimit.MAX_SERVER_TIME_INTERVAL_IN_DAYS_IN_LIST_REQUEST);
                    if (maxAllowedInterval != null && endTime.toGregorianCalendar().getTimeInMillis() - startTime.toGregorianCalendar().getTimeInMillis() > (long)(maxAllowedInterval * DAYS_TO_MILLISECONDS)) {
                        throw new ListOperationException(EnumErrorCatalog.ERR_LST_004, maxAllowedInterval.toString());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new ListOperationException(EnumErrorCatalog.ERR_LST_010, e.getMessage());
            }
        }
        return listParameters;
    }

    private static void validateParametersNames(Map<String, Object> listParameters) throws ListOperationException {
        HashSet<String> parameterNames = new HashSet<String>(listParameters.keySet());
        parameterNames.remove(EnumFilterElement.INTERVAL_TYPE.toString());
        parameterNames.remove(EnumFilterElement.CODE.toString());
        parameterNames.remove(EnumFilterElement.START_TIME.toString());
        parameterNames.remove(EnumFilterElement.END_TIME.toString());
        parameterNames.remove(EnumFilterElement.MESSAGE_TYPE.toString());
        parameterNames.remove(EnumFilterElement.OWNER.toString());
        parameterNames.remove(EnumFilterElement.MESSAGE_IDENTIFICATION.toString());
        if (!parameterNames.isEmpty()) {
            throw new ListOperationException(EnumErrorCatalog.ERR_LST_011, (String)parameterNames.iterator().next());
        }
    }

    private ListRequestMessageValidator() {
    }
}

