/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.operations.query;

import ch.iec.tc57._2011.schema.message.RequestMessage;
import es.ree.eemws.core.utils.error.EnumErrorCatalog;
import es.ree.eemws.core.utils.iec61968100.EnumFilterElement;
import es.ree.eemws.core.utils.iec61968100.MessageUtil;
import es.ree.eemws.core.utils.operations.query.QueryOperationException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;

public final class QueryRequestMessageValidator {
    private static final Set<String> EMPTY_SET = Collections.emptySet();

    public static Map<String, Object> validate(RequestMessage message) throws QueryOperationException {
        Map<String, Object> queryParameters = null;
        try {
            queryParameters = MessageUtil.getRequestMessageOptions(message);
            String idQuery = (String)queryParameters.get(EnumFilterElement.DATA_TYPE.toString());
            if (idQuery == null) {
                throw new QueryOperationException(EnumErrorCatalog.ERR_QRY_001, new String[0]);
            }
            XMLGregorianCalendar startTime = (XMLGregorianCalendar)queryParameters.get(EnumFilterElement.START_TIME.toString());
            XMLGregorianCalendar endTime = (XMLGregorianCalendar)queryParameters.get(EnumFilterElement.END_TIME.toString());
            if (startTime != null && endTime != null && endTime.compare(startTime) == -1) {
                throw new QueryOperationException(EnumErrorCatalog.ERR_QRY_003, new String[0]);
            }
        }
        catch (IllegalArgumentException e) {
            throw new QueryOperationException(EnumErrorCatalog.ERR_QRY_010, e.getMessage());
        }
        return queryParameters;
    }

    public static void validateParameterNames(String queryId, Set<String> receivedParameterNames) throws QueryOperationException {
        QueryRequestMessageValidator.validateParameterNames(queryId, EMPTY_SET, receivedParameterNames);
    }

    public static void validateParameterNames(String queryId, Set<String> validParameterNames, Set<String> receivedParameterNames) throws QueryOperationException {
        HashSet<String> parameterNames = new HashSet<String>(receivedParameterNames);
        parameterNames.removeAll(validParameterNames);
        parameterNames.remove(EnumFilterElement.DATA_TYPE.toString());
        if (!parameterNames.isEmpty()) {
            throw new QueryOperationException(EnumErrorCatalog.ERR_QRY_011, queryId, (String)parameterNames.iterator().next());
        }
    }

    private QueryRequestMessageValidator() {
    }
}

