/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.security;

import es.ree.eemws.core.utils.i18n.Messages;
import es.ree.eemws.core.utils.security.CryptoException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public final class CryptoManager {
    private static final String ALGORITHM = "AES";
    private static final String ALGORITHM_PREFIX = "{AES}";
    private static final String CIPHER_NAME = "AES/ECB/PKCS5Padding";
    private static final byte[] SECRET_KEY = new byte[]{107, 101, 101, 112, 116, 104, 105, 115, 115, 97, 102, 101, 112, 108, 122, 46};

    private CryptoManager() {
    }

    public static String encrypt(String value) throws CryptoException {
        String retValue = null;
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_NAME);
            SecretKeySpec secretKey = new SecretKeySpec(SECRET_KEY, ALGORITHM);
            cipher.init(1, secretKey);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            retValue = ALGORITHM_PREFIX + DatatypeConverter.printBase64Binary((byte[])encrypted);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException(Messages.getString("SECURITY_UNABLE_TO_CIPHER", new Object[0]), e);
        }
        return retValue;
    }

    public static String decrypt(String text) throws CryptoException {
        String retValue = null;
        try {
            if (text.indexOf(ALGORITHM_PREFIX) == -1) {
                retValue = text;
            } else {
                String textToDecode = text.substring(ALGORITHM_PREFIX.length());
                Cipher cipher = Cipher.getInstance(CIPHER_NAME);
                SecretKeySpec secretKey = new SecretKeySpec(SECRET_KEY, ALGORITHM);
                cipher.init(2, secretKey);
                byte[] bToDecript = DatatypeConverter.parseBase64Binary((String)textToDecode);
                retValue = new String(cipher.doFinal(bToDecript));
            }
        }
        catch (ArrayIndexOutOfBoundsException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException(Messages.getString("SECURITY_UNABLE_TO_DECRYPT", new Object[0]), e);
        }
        return retValue;
    }
}

