/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.security;

import es.ree.eemws.core.utils.i18n.Messages;
import es.ree.eemws.core.utils.security.SimpleKeySelectorResult;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;

public final class KeyValueKeySelector
extends KeySelector {
    private static final String ALGORITHM_DSA = "DSA";
    private static final String ALGORITHM_RSA = "RSA";
    private SimpleKeySelectorResult sKeyResult = null;
    private X509Certificate x509Cert;

    public X509Certificate getX509Certificate() {
        return this.x509Cert;
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            throw new KeySelectorException(Messages.getString("SECURITY_NULL_KEY_INFO", new Object[0]));
        }
        List<XMLStructure> list = keyInfo.getContent();
        int numInfo = list.size();
        for (int i = 0; this.sKeyResult == null && i < numInfo; ++i) {
            XMLStructure xmlStructure = list.get(i);
            if (xmlStructure instanceof X509Data) {
                Iterator<?> x509DataListContent = ((X509Data)xmlStructure).getContent().iterator();
                while (this.sKeyResult == null && x509DataListContent.hasNext()) {
                    Object obj = x509DataListContent.next();
                    if (!(obj instanceof X509Certificate)) continue;
                    this.x509Cert = (X509Certificate)obj;
                    this.sKeyResult = new SimpleKeySelectorResult(this.x509Cert.getPublicKey());
                }
                continue;
            }
            if (!(xmlStructure instanceof KeyValue)) continue;
            try {
                PublicKey pk = ((KeyValue)xmlStructure).getPublicKey();
                String algURI = method.getAlgorithm();
                String algName = pk.getAlgorithm();
                if ((!algName.equalsIgnoreCase(ALGORITHM_DSA) || !algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) && (!algName.equalsIgnoreCase(ALGORITHM_RSA) || !algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1"))) continue;
                this.sKeyResult = new SimpleKeySelectorResult(pk);
                continue;
            }
            catch (KeyException ke) {
                throw new KeySelectorException(ke);
            }
        }
        if (this.sKeyResult == null) {
            throw new KeySelectorException(Messages.getString("SECURITY_NO_VALID_KEY", new Object[0]));
        }
        return this.sKeyResult;
    }
}

