/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.security;

import es.ree.eemws.core.utils.i18n.Messages;
import es.ree.eemws.core.utils.security.KeyValueKeySelector;
import es.ree.eemws.core.utils.security.SignatureManagerException;
import es.ree.eemws.core.utils.security.SignatureSyntaxException;
import es.ree.eemws.core.utils.security.SignatureVerificationException;
import es.ree.eemws.core.utils.security.X509Util;
import es.ree.eemws.core.utils.xml.XMLUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import javax.xml.bind.DatatypeConverter;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class SignatureManager {
    private static final String SIGNATURE_URI = "";
    private static final String SIGNATURE_FACTORY_TYPE = "DOM";
    private static final String DIGEST_METHOD = "http://www.w3.org/2001/04/xmlenc#sha256";
    private static final String LEGACY_SHA1_DIGEST_METHOD = "http://www.w3.org/2000/09/xmldsig#sha1";
    private static final String CANONICALIZATION_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String USE_LEGACY_SHA1_SYSTEM_FLAG = "USE_LEGACY_SHA1";
    private static final String SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private static final String LEGACY_SHA1_SIGNATURE_METHOD = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private static final String TRANSFORM = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    private static final String HEADER_TAG = "Header";
    private static final String HEADER_NAME_SPACE = "http://iec.ch/TC57/2011/schema/message";
    private static final String SYSTEM_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String DEFAULT_KEY_STORE_TYPE = "PKCS12";
    private static final String SYSTEM_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String DEFAULT_KEY_STORE_PASSWORD = "";
    private static final String SYSTEM_KEY_STORE_FILE = "javax.net.ssl.keyStore";
    private static final String SIGNATURE_TAG = "Signature";

    private SignatureManager() {
    }

    public static X509Certificate verifyString(StringBuilder msgAsString) throws SignatureVerificationException, SignatureSyntaxException {
        try {
            return SignatureManager.verifyDocument(XMLUtil.string2Document(msgAsString));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SignatureVerificationException(Messages.getString("SECURITY_INVALID_DOCUMENT", new Object[0]), e);
        }
    }

    public static X509Certificate verifyDocument(Document msgAsDocument) throws SignatureVerificationException, SignatureSyntaxException {
        X509Certificate x509 = null;
        try {
            Node signatureNode = null;
            NodeList nl = msgAsDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_TAG);
            if (nl.getLength() != 1) {
                throw new SignatureVerificationException(Messages.getString("SECURITY_INVALID_DOCUMENT_NO_HEADER", SIGNATURE_TAG, "http://www.w3.org/2000/09/xmldsig#"));
            }
            signatureNode = nl.item(0);
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance(SIGNATURE_FACTORY_TYPE);
            KeyValueKeySelector keySelector = new KeyValueKeySelector();
            DOMValidateContext valContext = new DOMValidateContext(keySelector, signatureNode);
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            boolean coreValidity = signature.validate(valContext);
            boolean certValidity = true;
            x509 = keySelector.getX509Certificate();
            String msgError = Messages.getString("SECURITY_SIGNATURE_VALIDATION_FAILED", new Object[0]);
            CertificateException cause = null;
            if (x509 != null) {
                try {
                    X509Util.checkCertificate(x509);
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    certValidity = false;
                    msgError = Messages.getString("SECURITY_SIGNATURE_CERTIFICATE_NOT_VALID", new Date(), x509.getNotBefore(), x509.getNotAfter());
                    cause = e;
                }
                catch (CertificateException e) {
                    certValidity = false;
                    msgError = Messages.getString("SECURITY_SIGNATURE_NO_TRUSTED_CERT", new Object[0]);
                    cause = e;
                }
            }
            if (!coreValidity || !certValidity) {
                SignatureVerificationException sve = new SignatureVerificationException(msgError, cause);
                SignatureVerificationException.SignatureVerificationExceptionDetails details = sve.getDetails();
                details.setSignatureValid(signature.getSignatureValue().validate(valContext));
                details.setCertificateValid(certValidity);
                details.setSignatureCertificate(x509);
                for (Reference ref : signature.getSignedInfo().getReferences()) {
                    Boolean refValid = ref.validate(valContext);
                    String calculated = DatatypeConverter.printBase64Binary((byte[])ref.getCalculatedDigestValue());
                    String provided = DatatypeConverter.printBase64Binary((byte[])ref.getDigestValue());
                    details.addReferenceStatus(refValid, calculated, provided);
                }
                throw sve;
            }
        }
        catch (XMLSignatureException e) {
            throw new SignatureVerificationException(Messages.getString("SECURITY_UNABLE_TO_VERIFY", new Object[0]), e);
        }
        catch (NumberFormatException | MarshalException e) {
            throw new SignatureSyntaxException(Messages.getString("SECURITY_SIGNATURE_SYNTAX_ERROR", new Object[0]), e);
        }
        return x509;
    }

    public static void signDocument(Document msgAsDocument, RSAPrivateKey privateKey, X509Certificate cert) throws SignatureManagerException {
        SignatureManager.signDocument(msgAsDocument, (PrivateKey)privateKey, cert);
    }

    public static void signDocument(Document msgAsDocument) throws SignatureManagerException {
        RSAPrivateKey privateKey = null;
        X509Certificate certificate = null;
        String keyStoreFile = System.getProperty(SYSTEM_KEY_STORE_FILE);
        if (keyStoreFile == null) {
            throw new SignatureManagerException(Messages.getString("SECURITY_NO_SYSTEM_KEY_STORE", SYSTEM_KEY_STORE_FILE));
        }
        String keyStorePasswd = System.getProperty(SYSTEM_KEY_STORE_PASSWORD, "");
        String keyStoreType = System.getProperty(SYSTEM_KEY_STORE_TYPE, DEFAULT_KEY_STORE_TYPE);
        try (FileInputStream keystoreInputStream = new FileInputStream(keyStoreFile);){
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(keystoreInputStream, keyStorePasswd.toCharArray());
            Enumeration<String> keyAlias = ks.aliases();
            String entryAlias = null;
            boolean okAlias = false;
            GeneralSecurityException cause = null;
            while (!okAlias && keyAlias.hasMoreElements()) {
                try {
                    entryAlias = keyAlias.nextElement();
                    privateKey = (RSAPrivateKey)ks.getKey(entryAlias, keyStorePasswd.toCharArray());
                    certificate = (X509Certificate)ks.getCertificate(entryAlias);
                    certificate.checkValidity();
                    okAlias = privateKey != null;
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    okAlias = false;
                    cause = e;
                }
            }
            if (!okAlias) {
                throw new SignatureManagerException(Messages.getString("SECURITY_NO_USABLE_CERTIFICATE_FOUND", new Object[0]), cause);
            }
        }
        catch (FileNotFoundException e) {
            throw new SignatureManagerException(Messages.getString("SECURITY_UNABLE_TO_READ_KEY_STORE", keyStoreFile, SYSTEM_KEY_STORE_FILE), e);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new SignatureManagerException(Messages.getString("SECURITY_UNABLE_TO_LOAD_KEY_STORE", keyStoreFile, SYSTEM_KEY_STORE_TYPE, SYSTEM_KEY_STORE_PASSWORD), e);
        }
        catch (KeyStoreException e) {
            throw new SignatureManagerException(Messages.getString("SECURITY_UNABLE_TO_GET_KEY_STORE", keyStoreType, SYSTEM_KEY_STORE_TYPE), e);
        }
        SignatureManager.signDocument(msgAsDocument, privateKey, certificate);
    }

    public static void signString(StringBuilder msgAsString) throws SignatureManagerException {
        Document doc = null;
        try {
            doc = XMLUtil.string2Document(msgAsString);
            msgAsString.setLength(0);
            msgAsString.trimToSize();
            SignatureManager.signDocument(doc);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SignatureManagerException(Messages.getString("SECURITY_INVALID_DOCUMENT", new Object[0]), e);
        }
        finally {
            if (doc != null) {
                try {
                    msgAsString.append(XMLUtil.document2String(doc));
                }
                catch (TransformerException e) {
                    throw new SignatureManagerException(Messages.getString("SECURITY_INVALID_DOCUMENT", new Object[0]), e);
                }
            }
        }
    }

    public static void signString(StringBuilder msgAsString, PrivateKey privateKey, X509Certificate cert) throws SignatureManagerException {
        Document doc = null;
        try {
            doc = XMLUtil.string2Document(msgAsString);
            msgAsString.setLength(0);
            msgAsString.trimToSize();
            SignatureManager.signDocument(doc, privateKey, cert);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SignatureManagerException(Messages.getString("SECURITY_INVALID_DOCUMENT", new Object[0]), e);
        }
        finally {
            if (doc != null) {
                try {
                    msgAsString.append(XMLUtil.document2String(doc));
                }
                catch (TransformerException e) {
                    throw new SignatureManagerException(Messages.getString("SECURITY_INVALID_DOCUMENT", new Object[0]), e);
                }
            }
        }
    }

    public static void signDocument(Document msgAsDocument, PrivateKey privateKey, X509Certificate cert) throws SignatureManagerException {
        try {
            SignedInfo si;
            Reference ref;
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance(SIGNATURE_FACTORY_TYPE);
            if (System.getProperty(USE_LEGACY_SHA1_SYSTEM_FLAG) == null) {
                ref = fac.newReference("", fac.newDigestMethod(DIGEST_METHOD, null), Collections.singletonList(fac.newTransform(TRANSFORM, (TransformParameterSpec)null)), null, null);
                si = fac.newSignedInfo(fac.newCanonicalizationMethod(CANONICALIZATION_METHOD, (C14NMethodParameterSpec)null), fac.newSignatureMethod(SIGNATURE_METHOD, null), Collections.singletonList(ref));
            } else {
                ref = fac.newReference("", fac.newDigestMethod(LEGACY_SHA1_DIGEST_METHOD, null), Collections.singletonList(fac.newTransform(TRANSFORM, (TransformParameterSpec)null)), null, null);
                si = fac.newSignedInfo(fac.newCanonicalizationMethod(CANONICALIZATION_METHOD, (C14NMethodParameterSpec)null), fac.newSignatureMethod(LEGACY_SHA1_SIGNATURE_METHOD, null), Collections.singletonList(ref));
            }
            Node headerNode = null;
            NodeList nl = msgAsDocument.getElementsByTagNameNS(HEADER_NAME_SPACE, HEADER_TAG);
            if (nl.getLength() != 1) {
                throw new SignatureManagerException(Messages.getString("SECURITY_INVALID_DOCUMENT_NO_HEADER", HEADER_TAG, HEADER_NAME_SPACE));
            }
            headerNode = nl.item(0);
            DOMSignContext dsc = new DOMSignContext(privateKey, headerNode);
            KeyInfoFactory keyInfoFactory = fac.getKeyInfoFactory();
            ArrayList<Object> x509Content = new ArrayList<Object>();
            x509Content.add(keyInfoFactory.newX509IssuerSerial(cert.getIssuerDN().getName(), cert.getSerialNumber()));
            x509Content.add(cert.getSubjectX500Principal().getName());
            x509Content.add(cert);
            X509Data xd = keyInfoFactory.newX509Data(x509Content);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(xd));
            XMLSignature signature = fac.newXMLSignature(si, keyInfo);
            signature.sign(dsc);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureManagerException(Messages.getString("SECURITY_INVALID_GENERAL_ERROR", new Object[0]), e);
        }
        catch (MarshalException | XMLSignatureException e) {
            throw new SignatureManagerException(Messages.getString("SECURITY_INVALID_DOCUMENT_CANNOT_SIGN", new Object[0]), e);
        }
    }
}

