/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.security;

import es.ree.eemws.core.utils.i18n.Messages;
import es.ree.eemws.core.utils.security.SignatureManagerException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public final class SignatureVerificationException
extends SignatureManagerException {
    private static final long serialVersionUID = -1610760793648350360L;
    private final SignatureVerificationExceptionDetails details = new SignatureVerificationExceptionDetails();

    public SignatureVerificationException(String reasonText) {
        super(reasonText);
    }

    public SignatureVerificationException(String reasonText, Exception cause) {
        super(reasonText, cause);
    }

    public SignatureVerificationExceptionDetails getDetails() {
        return this.details;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.details.toString();
    }

    public final class SignatureVerificationExceptionDetails {
        private Boolean signatureStatus = null;
        private Boolean certificateValid = null;
        private X509Certificate signatureCertificate = null;
        private List<ReferenceStatus> references = new ArrayList<ReferenceStatus>();

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.signatureStatus != null) {
                if (this.signatureStatus.booleanValue()) {
                    sb.append(Messages.getString("SECURITY_SIGNATURE_STATUS_VALID", new Object[0]));
                } else {
                    sb.append(Messages.getString("SECURITY_SIGNATURE_STATUS_NO_VALID", new Object[0]));
                }
            }
            if (this.certificateValid != null) {
                if (this.certificateValid.booleanValue()) {
                    sb.append(Messages.getString("SECURITY_CERTIFICATE_STATUS_VALID", new Object[0]));
                } else {
                    sb.append(Messages.getString("SECURITY_CERTIFICATE_STATUS_NO_VALID", new Object[0]));
                }
            }
            int cont = 0;
            for (ReferenceStatus rs : this.references) {
                sb.append(Messages.getString("SECURITY_REFERENCE_STATUS", cont, rs.toString()));
                ++cont;
            }
            return sb.toString();
        }

        public void setSignatureCertificate(X509Certificate x509Cert) {
            this.signatureCertificate = x509Cert;
        }

        public X509Certificate getSignatureCertificate() {
            return this.signatureCertificate;
        }

        public void setSignatureValid(boolean status) {
            this.signatureStatus = status;
        }

        public boolean isSignatureValid() {
            return this.signatureStatus;
        }

        public void addReferenceStatus(Boolean refValid, String calculated, String provided) {
            this.references.add(new ReferenceStatus(refValid, calculated, provided));
        }

        public List<ReferenceStatus> getReferencesStatus() {
            return this.references;
        }

        public Boolean isRefereceValid(int index) {
            return this.references.get(index).isValid();
        }

        public void setCertificateValid(boolean certValidity) {
            this.certificateValid = certValidity;
        }

        public boolean isCertificateValid() {
            return this.certificateValid;
        }
    }

    public final class ReferenceStatus {
        private Boolean refValid;
        private String calculatedDigestValue;
        private String providedDigestValue;

        public ReferenceStatus(Boolean refV, String calcu, String prov) {
            this.refValid = refV;
            this.calculatedDigestValue = calcu;
            this.providedDigestValue = prov;
        }

        public Boolean isValid() {
            return this.refValid;
        }

        public String toString() {
            String msg = this.refValid != false ? Messages.getString("SECURITY_REFERENCE_STATUS_VALID", new Object[0]) : Messages.getString("SECURITY_REFERENCE_STATUS_NO_VALID", this.providedDigestValue, this.calculatedDigestValue);
            return msg;
        }
    }
}

