/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.security;

import es.ree.eemws.core.utils.i18n.Messages;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class X509Util {
    private static final String[] ALGORITHM_NAMES = new String[]{"SunX509", "IbmX509"};
    private static final String AUTHENTICATION_TYPE = "RSA";
    private static final X509TrustManager X509_TRUST_MANAGER;

    private X509Util() {
    }

    public static void checkCertificate(X509Certificate x509Cert) throws CertificateException {
        X509Util.checkCertificate(new X509Certificate[]{x509Cert});
    }

    public static void checkCertificate(X509Certificate[] x509Certs) throws CertificateException {
        X509_TRUST_MANAGER.checkClientTrusted(x509Certs, AUTHENTICATION_TYPE);
        for (int cont = 0; cont < x509Certs.length; ++cont) {
            x509Certs[cont].checkValidity();
        }
    }

    static {
        TrustManagerFactory tmf = null;
        for (int cont = 0; tmf == null && cont < ALGORITHM_NAMES.length; ++cont) {
            try {
                tmf = TrustManagerFactory.getInstance(ALGORITHM_NAMES[cont]);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (tmf == null) {
            throw new IllegalStateException(Messages.getString("SECURITY_NO_TRUST_VALIDATOR", new Object[0]));
        }
        try {
            tmf.init((KeyStore)null);
            X509_TRUST_MANAGER = (X509TrustManager)tmf.getTrustManagers()[0];
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(Messages.getString("SECURITY_UNABLE_TO_INITIALIZE_TRUST_VALIDATOR", tmf.getAlgorithm()), e);
        }
    }
}

