/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLElementUtil {
    private static final Map<Class<?>, JAXBContext> JAXB_CONTEXT_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Unmarshaller> UNMARSHALLER_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Marshaller> MARSHALLER_CACHE = new ConcurrentHashMap();

    private XMLElementUtil() {
    }

    public static Object element2Obj(Element element, Class<?> classType) throws JAXBException {
        Unmarshaller jaxbUnmarshaller = (Unmarshaller)UNMARSHALLER_CACHE.remove(classType);
        if (jaxbUnmarshaller == null) {
            jaxbUnmarshaller = XMLElementUtil.getJAXBContext(classType).createUnmarshaller();
        }
        Object retValue = jaxbUnmarshaller.unmarshal((Node)element, classType).getValue();
        UNMARSHALLER_CACHE.putIfAbsent(classType, jaxbUnmarshaller);
        return retValue;
    }

    public static Element string2Element(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setValidating(false);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new InputSource(new StringReader(xml)));
        return doc.getDocumentElement();
    }

    public static String element2String(Element element) throws TransformerException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        document.appendChild(document.importNode(element, true));
        DOMSource domSource = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(domSource, result);
        return stringWriter.toString();
    }

    public static Element obj2Element(Object obj) throws JAXBException {
        Class<?> classType = obj.getClass();
        Marshaller jaxbMarshaller = XMLElementUtil.getMarshaller(classType);
        DOMResult res = new DOMResult();
        jaxbMarshaller.marshal(obj, (Result)res);
        MARSHALLER_CACHE.putIfAbsent(classType, jaxbMarshaller);
        return ((Document)res.getNode()).getDocumentElement();
    }

    public static StringBuilder object2StringBuilder(Object obj) throws JAXBException {
        Class<?> classType = obj.getClass();
        Marshaller jaxbMarshaller = XMLElementUtil.getMarshaller(classType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jaxbMarshaller.marshal(obj, (OutputStream)baos);
        MARSHALLER_CACHE.putIfAbsent(classType, jaxbMarshaller);
        return new StringBuilder(baos.toString());
    }

    private static Marshaller getMarshaller(Class<?> classType) throws JAXBException {
        Marshaller jaxbMarshaller = (Marshaller)MARSHALLER_CACHE.remove(classType);
        if (jaxbMarshaller == null) {
            jaxbMarshaller = XMLElementUtil.getJAXBContext(classType).createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            jaxbMarshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        return jaxbMarshaller;
    }

    private static JAXBContext getJAXBContext(Class<?> classType) throws JAXBException {
        JAXBContext jaxbContext = JAXB_CONTEXT_CACHE.get(classType);
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{classType});
            JAXB_CONTEXT_CACHE.put(classType, jaxbContext);
        }
        return jaxbContext;
    }
}

