/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.xml;

import es.ree.eemws.core.utils.i18n.Messages;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class XMLGregorianCalendarFactory {
    private static final String ERR_MSG = Messages.getString("XML_GREGORIAN_CALENDAR", new Object[0]);
    private static final String Z_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    private XMLGregorianCalendarFactory() {
    }

    public static XMLGregorianCalendar getGMTInstance(Date date) {
        XMLGregorianCalendar retValue = XMLGregorianCalendarFactory.getGMTInstanceMs(date);
        retValue.setMillisecond(Integer.MIN_VALUE);
        return retValue;
    }

    public static XMLGregorianCalendar getGMTInstanceMs(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        XMLGregorianCalendar retValue = null;
        try {
            retValue = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal).normalize();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(ERR_MSG, e);
        }
        return retValue;
    }

    public static XMLGregorianCalendar getInstance(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(Z_DATE_FORMAT);
        sdf.setLenient(false);
        return XMLGregorianCalendarFactory.getInstance(sdf.parse(date));
    }

    public static XMLGregorianCalendar getInstance(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return XMLGregorianCalendarFactory.getInstance(cal);
    }

    public static XMLGregorianCalendar getInstance(Calendar date) {
        XMLGregorianCalendar retValue = null;
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date.getTime());
            retValue = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(ERR_MSG, e);
        }
        return retValue;
    }
}

