/*
 * Decompiled with CFR 0.152.
 */
package es.ree.eemws.core.utils.xml;

import es.ree.eemws.core.utils.i18n.Messages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private static final String STRING_XML_METHOD = "xml";
    private static final String STRING_XML_CODIFICATION = "UTF-8";
    private static final String STRING_XML_OMIT_DECLARATION = "yes";
    private static final String XMLNS = "xmlns";
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SIMPLE_QUOTE = '\'';
    private static final String END_TAG = ">";
    private static final String START_TAG = "<";
    private static final char START_TAG_CHAR = "<".charAt(0);
    private static final String START_CLOSE_TAG = "</";
    private static final String BLANK = " ";
    private static final String EMPTY = "";
    private static final String COLON = ":";
    private static final char COLON_CHAR = ":".charAt(0);
    private static final String NEW_LINE = "\n";
    private static final String SLASH = "/";
    private static final int TAB_SIZE = 4;
    private static final int TNSNAME_SEARCH_SIZE = 3000;

    private XMLUtil() {
    }

    public static String getNodeValue(String tag, StringBuilder doc) {
        String retValue = null;
        int pos = -1;
        int totLen = doc.length();
        do {
            String tag1 = tag + END_TAG;
            String tag2 = tag + BLANK;
            int len = tag.length();
            int pos1 = doc.indexOf(tag1, ++pos);
            int pos2 = doc.indexOf(tag2, pos);
            String finalToken = EMPTY;
            if (pos1 == -1 && pos2 == -1) {
                pos = totLen;
                continue;
            }
            if (pos2 == -1) {
                if (pos1 != -1) {
                    pos = pos1;
                    ++len;
                }
            } else {
                pos = pos2;
                finalToken = END_TAG;
            }
            if ((retValue = XMLUtil.extractValue(doc, pos, len, finalToken)) != null || pos2 == -1 || pos1 == -1) continue;
            pos = pos1;
            finalToken = EMPTY;
            retValue = XMLUtil.extractValue(doc, pos, ++len, finalToken);
        } while (pos < totLen && retValue == null);
        return retValue;
    }

    private static String extractValue(StringBuilder doc, int pos, int len, String finalToken) {
        String retValue = null;
        int end = doc.indexOf(END_TAG, pos) + 1;
        if (end != -1) {
            int posBegin;
            for (posBegin = pos - 1; doc.charAt(posBegin) != START_TAG_CHAR && posBegin > 0; --posBegin) {
            }
            String endTag = START_CLOSE_TAG + doc.substring(posBegin + 1, pos + len) + finalToken;
            int idx = doc.indexOf(endTag);
            if (idx != -1) {
                retValue = doc.substring(end, idx);
            }
        }
        return retValue;
    }

    public static Document string2Document(String msgAsString) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtil.string2Document(new StringBuilder(msgAsString));
    }

    public static Document string2Document(StringBuilder msgAsString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(msgAsString.toString())));
    }

    public static String document2String(Document doc) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("method", STRING_XML_METHOD);
        transformer.setOutputProperty("omit-xml-declaration", STRING_XML_OMIT_DECLARATION);
        transformer.setOutputProperty("encoding", STRING_XML_CODIFICATION);
        DOMSource domSource = new DOMSource(doc);
        transformer.transform(domSource, result);
        return stringWriter.toString();
    }

    public static StringBuilder prettyPrint(String whatToPretty) {
        StringBuilder output = new StringBuilder();
        try {
            String tab = NEW_LINE;
            String tabBlanks = EMPTY;
            StringBuilder buf = new StringBuilder();
            for (int cont = 0; cont < 4; ++cont) {
                buf.append(BLANK);
            }
            tabBlanks = buf.toString();
            String[] text = whatToPretty.trim().split(END_TAG);
            String current = EMPTY;
            String previous = BLANK;
            int pos = 0;
            for (int cont = 0; cont < text.length; ++cont) {
                int k;
                current = text[cont].trim().replaceAll(NEW_LINE, BLANK);
                if (!current.endsWith(SLASH) && !current.startsWith(START_CLOSE_TAG)) {
                    if (current.startsWith(START_TAG)) {
                        tab = tab + tabBlanks;
                    } else {
                        k = output.length();
                        output.delete(k - tab.length(), k);
                        tab = tab.substring(0, tab.length() - 4);
                    }
                } else if (current.startsWith(START_CLOSE_TAG)) {
                    tab = tab.substring(0, tab.length() - 4);
                    k = output.length();
                    output.delete(k - 4, k);
                    if (XMLUtil.isSameTag(previous, current)) {
                        output.setLength(pos - 1);
                        current = SLASH;
                    }
                }
                previous = current;
                output.append(current);
                output.append(END_TAG);
                pos = output.length();
                output.append(tab);
            }
        }
        catch (IndexOutOfBoundsException e) {
            output.setLength(0);
            output.append(whatToPretty);
        }
        return output;
    }

    private static boolean isSameTag(String previousTag, String currentTag) {
        String tag2;
        String tag1 = previousTag.substring(1);
        if (tag1.indexOf(BLANK) > 0) {
            tag1 = tag1.substring(0, tag1.indexOf(BLANK));
        }
        if ((tag2 = currentTag.substring(2)).indexOf(BLANK) > 0) {
            tag2 = tag2.substring(0, tag2.indexOf(BLANK));
        }
        return tag1.equals(tag2);
    }

    public static StringBuilder removeNameSpaces(String xml) {
        StringBuilder xmlOut = new StringBuilder(xml.trim());
        String prefix = XMLUtil.getTargetNameSpacePrefix(xmlOut = XMLUtil.removeExtraNS(xmlOut.toString()));
        if (prefix != null) {
            String retXml = xmlOut.toString();
            retXml = retXml.replaceAll(prefix + COLON, EMPTY);
            retXml = retXml.replaceFirst("xmlns:" + prefix, XMLNS);
            xmlOut = new StringBuilder(retXml);
        }
        return xmlOut;
    }

    private static StringBuilder removeExtraNS(String xml) {
        StringBuilder xmlOut = new StringBuilder(xml.trim());
        String ns = XMLUtil.getTargetNameSpace(xmlOut);
        String prefix = XMLUtil.getTargetNameSpacePrefix(xmlOut);
        prefix = prefix == null ? EMPTY : COLON + prefix;
        String newDoc = xml;
        int posEndTag = newDoc.indexOf(END_TAG);
        if (newDoc.charAt(posEndTag - 1) == '/') {
            --posEndTag;
        }
        String rootTag = newDoc.substring(0, posEndTag);
        String[] rootTags = rootTag.split("\\s");
        StringBuilder sb = new StringBuilder(rootTags[0]);
        sb.append(" xmlns" + prefix + "=\"" + ns + '\"' + BLANK);
        int len = rootTags.length;
        for (int i = 1; i < len; ++i) {
            if (rootTags[i].indexOf(XMLNS) != -1) continue;
            sb.append(rootTags[i]);
            sb.append(BLANK);
        }
        sb.setLength(sb.length() - 1);
        sb.append(xml.substring(posEndTag));
        return sb;
    }

    private static String getTargetNameSpacePrefix(StringBuilder xml) {
        String prefix = null;
        String subXml = xml.length() > 3000 ? xml.substring(0, 3000) : xml.toString();
        subXml = subXml + END_TAG;
        int startPos = subXml.indexOf(START_TAG);
        int endPos1 = subXml.indexOf(BLANK);
        int endPos2 = subXml.indexOf(END_TAG);
        if (endPos1 == -1) {
            endPos1 = endPos2;
        }
        if (endPos2 == -1) {
            endPos2 = endPos1;
        }
        try {
            String tag = subXml.substring(startPos, Math.min(endPos1, endPos2));
            if (tag.indexOf(COLON) != -1) {
                prefix = tag.substring(tag.indexOf(START_TAG) + 1, tag.indexOf(COLON));
            }
        }
        catch (IndexOutOfBoundsException e) {
            prefix = null;
        }
        return prefix;
    }

    public static String getRootTag(StringBuilder strXml) {
        int start;
        int posBlank;
        int posEndTag = strXml.lastIndexOf(END_TAG);
        int posCloseTag = strXml.lastIndexOf(SLASH);
        int end = posCloseTag == posEndTag - 1 ? ((posBlank = strXml.indexOf(BLANK)) == -1 ? posCloseTag : posBlank) : posEndTag;
        for (start = end - 1; start >= 0 && strXml.charAt(start) != COLON_CHAR && strXml.charAt(start) != '/' && strXml.charAt(start) != START_TAG_CHAR; --start) {
        }
        String retValue = start < 0 ? null : strXml.substring(start + 1, end);
        return retValue;
    }

    private static String getTargetNameSpace(StringBuilder xml) {
        String targetNamespace = null;
        String subXml = xml.length() > 3000 ? xml.substring(0, 3000) : xml.toString();
        String prefix = XMLUtil.getTargetNameSpacePrefix(xml);
        try {
            if (prefix == null) {
                int pos = subXml.indexOf(XMLNS);
                int pos2 = subXml.indexOf("xmlns:");
                if (pos != -1) {
                    while (pos == pos2 && pos != -1) {
                        pos = subXml.indexOf(XMLNS, pos + 1);
                        pos2 = subXml.indexOf("xmlns:", pos2 + 1);
                    }
                    if (pos != -1) {
                        pos = subXml.indexOf(34, pos);
                        pos2 = subXml.indexOf(34, pos + 1);
                        if (pos == -1) {
                            pos = subXml.indexOf(39, pos);
                            pos2 = subXml.indexOf(39, pos + 1);
                        }
                        targetNamespace = subXml.substring(pos + 1, pos2);
                    }
                }
            } else {
                prefix = "xmlns:" + prefix;
                int posIni = subXml.indexOf(prefix) + prefix.length();
                posIni = subXml.indexOf(34, posIni) + 1;
                int posFin = subXml.indexOf(34, posIni);
                if (posIni == -1) {
                    posIni = subXml.indexOf(prefix) + prefix.length();
                    posIni = subXml.indexOf(39, posIni) + 1;
                    posFin = subXml.indexOf(39, posIni);
                }
                targetNamespace = subXml.substring(posIni, posFin);
            }
        }
        catch (IndexOutOfBoundsException e) {
            targetNamespace = null;
        }
        return targetNamespace;
    }

    public static String soapMessage2String(SOAPMessage message) throws SOAPException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            return baos.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new SOAPException(Messages.getString("SOAP_UNABLE_TO_TRANSFORM", new Object[0]), (Throwable)e);
        }
    }
}

