/*
 * Decompiled with CFR 0.152.
 */
package es.sandbox.ui.messages.spring.config.annotation;

import es.sandbox.ui.messages.Context;
import es.sandbox.ui.messages.ContextBuilder;
import es.sandbox.ui.messages.CssClassesByLevel;
import es.sandbox.ui.messages.Level;
import es.sandbox.ui.messages.StoreAccessorFactory;
import es.sandbox.ui.messages.resolver.MessageResolverStrategy;
import es.sandbox.ui.messages.spring.config.FlashMessagesHandlerInterceptor;
import es.sandbox.ui.messages.spring.config.FlashMessagesMethodArgumentResolver;
import es.sandbox.ui.messages.spring.config.MessageSourceMessageResolverAdapter;
import es.sandbox.ui.messages.spring.scope.flash.FlashScopeStoreAccessorFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerExceptionResolverComposite;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

public class FlashMessagesConfigurationSupport
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private HandlerExceptionResolver handlerExceptionResolver;
    private MessageSource messageSource;
    private ApplicationContext applicationContext;

    @Autowired
    void setHandlerExceptionResolver(HandlerExceptionResolver handlerExceptionResolver) {
        this.handlerExceptionResolver = handlerExceptionResolver;
    }

    @Autowired
    void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    private void configureMessagesExceptionArgumentResolvers() {
        for (HandlerExceptionResolver resolver : ((HandlerExceptionResolverComposite)this.handlerExceptionResolver).getExceptionResolvers()) {
            if (!(resolver instanceof ExceptionHandlerExceptionResolver)) continue;
            this.configureCustomHandlerMethodArgumentResolver((ExceptionHandlerExceptionResolver)resolver);
        }
    }

    private void configureCustomHandlerMethodArgumentResolver(ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver) {
        ArrayList<FlashMessagesMethodArgumentResolver> resolvers = new ArrayList<FlashMessagesMethodArgumentResolver>();
        resolvers.addAll(exceptionHandlerExceptionResolver.getArgumentResolvers().getResolvers());
        resolvers.add(this.flashMessagesMethodArgumentResolver());
        exceptionHandlerExceptionResolver.setArgumentResolvers(resolvers);
        exceptionHandlerExceptionResolver.setApplicationContext(this.applicationContext);
        exceptionHandlerExceptionResolver.afterPropertiesSet();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(this.flashMessagesMethodArgumentResolver());
    }

    private FlashMessagesMethodArgumentResolver flashMessagesMethodArgumentResolver() {
        return new FlashMessagesMethodArgumentResolver(this.flashMessagesContext());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new FlashMessagesHandlerInterceptor(this.flashMessagesContext()));
    }

    @Bean
    Context flashMessagesContext() {
        return new ContextBuilder(this.configureFlashStoreAccessorFactory()).withMessageResolverStrategy(this.configureMessageResolverStrategy()).withLevels(this.includedLevels()).withCssClassesByLevel(this.cssClassesByLevel()).build();
    }

    protected StoreAccessorFactory configureFlashStoreAccessorFactory() {
        return new FlashScopeStoreAccessorFactory();
    }

    protected MessageResolverStrategy configureMessageResolverStrategy() {
        return new MessageSourceMessageResolverAdapter(this.messageSource);
    }

    private Level[] includedLevels() {
        return this.configureIncludedLevels();
    }

    protected Level[] configureIncludedLevels() {
        return Level.values();
    }

    private CssClassesByLevel cssClassesByLevel() {
        CssClassesByLevel cssClassesByLevel = new CssClassesByLevel();
        this.configureCssClassesByLevel(cssClassesByLevel);
        return cssClassesByLevel;
    }

    protected void configureCssClassesByLevel(CssClassesByLevel cssClassesByLevel) {
    }
}

