/*
 * Decompiled with CFR 0.152.
 */
package es.sandbox.ui.messages.spring.scope.flash;

import es.sandbox.ui.messages.Store;
import es.sandbox.ui.messages.StoreAccessor;
import es.sandbox.ui.messages.StoreNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.support.RequestContextUtils;

final class FlashScopeStoreAccessor
implements StoreAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlashScopeStoreAccessor.class);
    private final HttpServletRequest request;
    private final String parameterName;

    FlashScopeStoreAccessor(HttpServletRequest request, String flashParameter) throws NullPointerException, IllegalArgumentException {
        this.assertThatRequestIsNotNull(request);
        this.assertThatFlashParameterIsValid(flashParameter);
        LOGGER.trace("The messages will be stored in flash scope param [{}]", (Object)flashParameter);
        this.request = request;
        this.parameterName = flashParameter;
        this.initialize();
    }

    private void assertThatRequestIsNotNull(HttpServletRequest request) throws NullPointerException {
        if (request == null) {
            throw new NullPointerException("HttpServletRequest can't be null.");
        }
    }

    private void assertThatFlashParameterIsValid(String parameter) throws NullPointerException, IllegalArgumentException {
        if (parameter == null) {
            throw new NullPointerException("Flash parameter name can't be null.");
        }
        if (StringUtils.isBlank((CharSequence)parameter)) {
            throw new IllegalArgumentException("Flash parameter name can't be blank.");
        }
    }

    private void initialize() {
        if (!this.existsStoreInCurrentRequest()) {
            this.copyFromPreviousToCurrentRequest();
        }
    }

    public boolean contains() {
        return this.existsStoreInCurrentRequest() || this.existsStoreFromPreviousRequest();
    }

    public Store get() throws StoreNotFoundException {
        LOGGER.debug("Getting the current messsages store in use");
        return this.fromCurrentRequest();
    }

    public void put(Store store) {
        LOGGER.debug("Setting [{}] as the store in use.", (Object)store);
        this.currentRequestFlashMap().put((Object)this.parameterName, (Object)store);
    }

    private boolean existsStoreFromPreviousRequest() {
        return this.previousRequestFlashMap().containsKey(this.parameterName);
    }

    private boolean existsStoreInCurrentRequest() {
        return this.currentRequestFlashMap().containsKey((Object)this.parameterName);
    }

    private void copyFromPreviousToCurrentRequest() {
        Store previousStore = this.fromPreviousRequest();
        if (previousStore != null) {
            LOGGER.debug("There is a store from previous request in the input flash scope!");
            this.put(previousStore);
        }
    }

    private Store fromCurrentRequest() throws StoreNotFoundException {
        Store store = (Store)this.currentRequestFlashMap().get((Object)this.parameterName);
        if (store == null) {
            throw new StoreNotFoundException();
        }
        return store;
    }

    private Store fromPreviousRequest() {
        return (Store)this.previousRequestFlashMap().get(this.parameterName);
    }

    private Map<String, ?> previousRequestFlashMap() {
        Map inputFlashMap = RequestContextUtils.getInputFlashMap((HttpServletRequest)this.request);
        return inputFlashMap == null ? new HashMap() : inputFlashMap;
    }

    private FlashMap currentRequestFlashMap() {
        return RequestContextUtils.getOutputFlashMap((HttpServletRequest)this.request);
    }
}

