/*
 * Decompiled with CFR 0.152.
 */
package es.sandbox.ui.messages.spring.autoconfigure;

import es.sandbox.ui.messages.CssClassesByLevel;
import es.sandbox.ui.messages.Level;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="flash-messages")
public class FlashMessagesProperties {
    private List<String> levels = new ArrayList<String>();
    private final LevelConfig success = new LevelConfig();
    private final LevelConfig info = new LevelConfig();
    private final LevelConfig warning = new LevelConfig();
    private final LevelConfig error = new LevelConfig();

    public List<String> getLevels() {
        return this.levels;
    }

    public void setLevels(List<String> levels) {
        this.levels = levels;
    }

    public LevelConfig getSuccess() {
        return this.success;
    }

    public LevelConfig getInfo() {
        return this.info;
    }

    public LevelConfig getWarning() {
        return this.warning;
    }

    public LevelConfig getError() {
        return this.error;
    }

    public CssClassesByLevel getCssClassesByLevel() {
        CssClassesByLevel cssClassesByLevel = new CssClassesByLevel();
        if (this.success.isConfigured()) {
            cssClassesByLevel.put(Level.SUCCESS, this.success.cssClass);
        }
        if (this.info.isConfigured()) {
            cssClassesByLevel.put(Level.INFO, this.info.cssClass);
        }
        if (this.warning.isConfigured()) {
            cssClassesByLevel.put(Level.WARNING, this.warning.cssClass);
        }
        if (this.error.isConfigured()) {
            cssClassesByLevel.put(Level.ERROR, this.error.cssClass);
        }
        return cssClassesByLevel;
    }

    public static class LevelConfig {
        private String cssClass;

        public String getCssClass() {
            return this.cssClass;
        }

        public void setCssClass(String cssClass) {
            this.cssClass = cssClass;
        }

        public boolean isConfigured() {
            return this.cssClass != null && !this.cssClass.isEmpty();
        }
    }
}

