/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.client;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPMonReq;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import es.tid.util.UtilsFunctions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRequestManager {
    public Hashtable<Long, Object> locks;
    private Hashtable<Long, PCEPResponse> responses;
    private Hashtable<Long, PCEPReport> responsesInit;
    private Logger log = LoggerFactory.getLogger((String)"PCCClient");
    private DataOutputStream out = null;
    private long lastTime;
    public Hashtable<Long, Semaphore> semaphores;

    public ClientRequestManager() {
        this.locks = new Hashtable();
        this.responses = new Hashtable();
        this.responsesInit = new Hashtable();
        this.semaphores = new Hashtable();
    }

    public void notifyResponse(PCEPResponse pcres, long timeIni) {
        this.lastTime = timeIni;
        long idRequest = pcres.getResponse(0).getRequestParameters().getRequestID();
        this.log.debug("Entrando en Notify Response");
        Object object_lock = this.locks.remove(new Long(idRequest));
        if (object_lock != null) {
            this.responses.put(new Long(idRequest), pcres);
            object_lock.notifyAll();
        }
    }

    public void notifyResponseInit(PCEPReport pcres, long timeIni) {
        System.out.println("Entrando en Notify Resp Init");
        this.log.info("Entrando en Notify Resp Init");
        this.lastTime = timeIni;
        long idIni = ((StateReport)pcres.getStateReportList().get(0)).getSRP().getSRP_ID_number();
        System.out.println("Nos llega un" + idIni);
        this.responsesInit.put(new Long(idIni), pcres);
    }

    public void setDataOutputStream(DataOutputStream out) {
        this.out = out;
    }

    public PCEPMessage newRequest(PCEPMessage pcreq) {
        return this.newRequest(pcreq, 60000L);
    }

    public PCEPResponse newRequest(PCEPRequest pcreq) {
        return this.newRequest(pcreq, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCEPMessage newRequest(PCEPMessage pcreq, long maxTimeMs) {
        this.log.info("New Request. Request:" + pcreq.toString());
        Object object_lock = new Object();
        long idRequest = this.generateRandomID();
        Long idReqLong = new Long(idRequest);
        long timeIni = System.nanoTime();
        this.locks.put(idReqLong, object_lock);
        this.sendPCEPMessage(pcreq);
        Object object = object_lock;
        synchronized (object) {
            try {
                this.log.info("ESPERAREMOS " + maxTimeMs);
                object_lock.wait(maxTimeMs);
            }
            catch (InterruptedException e) {
                UtilsFunctions.exceptionToString(e);
            }
        }
        long timeIni2 = System.nanoTime();
        double reqTime_ms = (timeIni2 - timeIni) / 1000000L;
        this.log.debug("Request or timeout");
        PCEPMessage resp = (PCEPMessage)this.responses.remove(new Long(idRequest));
        if (resp == null) {
            this.log.warn("NO RESPONSE!!!!! me deshago del lock... con idReqLong " + idRequest);
            this.locks.remove(idReqLong);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCEPResponse newRequest(PCEPRequest pcreq, long maxTimeMs) {
        this.log.info("jm dentro de newRequest");
        this.log.info("New Request. Request:" + pcreq.toString());
        this.log.info("pcreq.getRequest(0).getXro(): " + pcreq.getRequest(0).getXro());
        Object object_lock = new Object();
        long idRequest = pcreq.getRequest(0).getRequestParameters().getRequestID();
        Long idReqLong = new Long(idRequest);
        long timeIni = System.nanoTime();
        this.locks.put(idReqLong, object_lock);
        this.sendRequest(pcreq);
        Object object = object_lock;
        synchronized (object) {
            try {
                this.log.info("ESPERAREMOS " + maxTimeMs);
                object_lock.wait(maxTimeMs);
            }
            catch (InterruptedException e) {
                UtilsFunctions.exceptionToString(e);
            }
        }
        long timeIni2 = System.nanoTime();
        double reqTime_ms = (timeIni2 - timeIni) / 1000000L;
        this.log.debug("Request or timeout");
        PCEPResponse resp = this.responses.remove(new Long(idRequest));
        if (resp == null) {
            this.log.warn("NO RESPONSE!!!!! me deshago del lock... con idReqLong " + idRequest);
            this.locks.remove(idReqLong);
        }
        return resp;
    }

    public void sendRequest(PCEPRequest req) {
        this.log.debug("Sending Request: :" + req);
        this.log.info("Sending PCEP Request");
        this.sendPCEPMessage((PCEPMessage)req);
    }

    public synchronized void sendPCEPMessage(PCEPMessage msg) {
        try {
            msg.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            this.log.info(UtilsFunctions.exceptionToString((Exception)((Object)e1)));
        }
        try {
            this.log.info("Sending message ::" + msg);
            this.out.write(msg.getBytes());
            this.out.flush();
            this.log.info("Sending message finish");
        }
        catch (IOException e) {
            this.log.info(UtilsFunctions.exceptionToString(e));
            this.log.warn("Error sending msg: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PCEPResponse newRequest(PCEPMonReq pcreq) {
        this.log.debug("New Request");
        Object object_lock = new Object();
        long idMonitoring = pcreq.getMonitoring().getMonitoringIdNumber();
        this.locks.put(new Long(idMonitoring), object_lock);
        this.sendRequest(pcreq);
        Object object = object_lock;
        synchronized (object) {
            try {
                this.log.debug("Request sent, waiting for response");
                object_lock.wait(60000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.log.debug("Request or timeout");
        PCEPResponse resp = this.responses.get(new Long(idMonitoring));
        if (resp == null) {
            this.log.warn("NO RESPONSE!!!!!");
        }
        return resp;
    }

    public synchronized void sendRequest(PCEPMonReq req) {
        try {
            req.encode();
        }
        catch (PCEPProtocolViolationException e1) {
            e1.printStackTrace();
        }
        try {
            this.log.debug("Sending Request message");
            this.out.write(req.getBytes());
            this.out.flush();
        }
        catch (IOException e) {
            this.log.warn("Error sending REQ: " + e.getMessage());
        }
    }

    private int generateRandomID() {
        Random generator = new Random();
        return generator.nextInt(Integer.MAX_VALUE);
    }

    public PCEPMessage initiate(PCEPInitiate pcini, long maxTimeMs) {
        this.log.info("Sending Initiate:" + pcini.toString());
        byte[] LSPname = ((PCEPIntiatedLSP)pcini.getPcepIntiatedLSPList().get(0)).getLsp().getSymbolicPathNameTLV_tlv().getSymbolicPathNameID();
        long idIni = ((PCEPIntiatedLSP)pcini.getPcepIntiatedLSPList().get(0)).getRsp().getSRP_ID_number();
        System.out.println("Sending with id " + idIni);
        Long idReqLong = new Long(idIni);
        long timeIni = System.nanoTime();
        Semaphore semapohore = new Semaphore(0);
        this.semaphores.put(idIni, semapohore);
        this.sendPCEPMessage((PCEPMessage)pcini);
        try {
            semapohore.tryAcquire(maxTimeMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            UtilsFunctions.exceptionToString(e);
        }
        long timeIni2 = System.nanoTime();
        double reqTime_ms = (timeIni2 - timeIni) / 1000000L;
        this.log.debug("Time: " + reqTime_ms);
        PCEPMessage resp = (PCEPMessage)this.responsesInit.remove(new Long(idIni));
        if (resp == null) {
            this.log.warn("NO RESPONSE!!!!! me deshago del lock... con idIni " + idIni);
            this.locks.remove(idReqLong);
        }
        return resp;
    }
}

