/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.client;

import es.tid.pce.client.ClientRequestManager;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.messages.PCEPResponse;
import es.tid.pce.pcep.messages.PCEPUpdate;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcep.objects.tlvs.PathSetupTLV;
import es.tid.pce.pcepsession.DeadTimerThread;
import es.tid.pce.pcepsession.GenericPCEPSession;
import es.tid.pce.pcepsession.KeepAliveThread;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.rsvp.objects.ERO;
import es.tid.util.UtilsFunctions;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Socket;
import java.util.Calendar;
import java.util.Timer;
import java.util.concurrent.Semaphore;
import org.slf4j.LoggerFactory;

public class PCCPCEPSession
extends GenericPCEPSession {
    public ClientRequestManager crm;
    private String peerPCE_IPaddress;
    public String localAddress;
    private int peerPCE_port;
    private static long sessionIDCounter = 0L;
    private static long reqIDCounter = 0L;
    private boolean running = true;
    private boolean no_delay = false;
    private PCEPSessionsInformation pcepSessionManager;
    public Semaphore sessionStarted;

    public PCCPCEPSession(String ip, int port, boolean no_delay, PCEPSessionsInformation pcepSessionManager) {
        super(pcepSessionManager);
        this.setFSMstate(0);
        this.log = LoggerFactory.getLogger((String)"PCCClient");
        this.peerPCE_IPaddress = ip;
        this.peerPCE_port = port;
        this.crm = new ClientRequestManager();
        this.keepAliveLocal = 30;
        this.deadTimerLocal = 120;
        this.timer = new Timer();
        this.no_delay = no_delay;
        this.pcepSessionManager = pcepSessionManager;
        this.sessionStarted = new Semaphore(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        this.log.info("Opening new PCEP Session with host " + this.peerPCE_IPaddress + " on port " + this.peerPCE_port);
        if (this.socket == null) {
            try {
                this.socket = this.localAddress != null ? new Socket(Inet4Address.getByName(this.peerPCE_IPaddress), this.peerPCE_port, Inet4Address.getByName(this.localAddress), 0) : new Socket(this.peerPCE_IPaddress, this.peerPCE_port);
                if (this.no_delay) {
                    this.socket.setTcpNoDelay(true);
                    this.log.info("No delay activated");
                }
                this.log.info("Socket opened");
            }
            catch (IOException e) {
                this.log.info(UtilsFunctions.exceptionToString(e));
                this.log.error("Couldn't get I/O for connection to " + this.peerPCE_IPaddress + " in port " + this.peerPCE_port);
                System.exit(1);
            }
        }
        this.initializePCEPSession(false, 15, 200, false, false, null, null, 0);
        this.crm.setDataOutputStream(this.out);
        this.log.info("PCE Session " + this.toString() + " succesfully established!!");
        this.deadTimerT = new DeadTimerThread(this, this.deadTimerLocal);
        this.startDeadTimer();
        this.keepAliveT = new KeepAliveThread(this.out, this.keepAliveLocal);
        this.startKeepAlive();
        this.log.info("Now PCE will be informed of all our LSPs");
        this.log.info("open:" + this.open);
        if (this.sessionStarted != null) {
            this.sessionStarted.release();
        }
        while (this.running) {
            try {
                this.log.info("Waiting for new PCEP Messages!");
                this.msg = this.readMsg(this.in);
            }
            catch (IOException e) {
                this.cancelDeadTimer();
                this.cancelKeepAlive();
                try {
                    this.in.close();
                    this.out.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                this.manageEndSession();
                this.log.warn("Finishing PCEP Session abruptly!");
                return;
            }
            if (this.msg == null) continue;
            this.log.info("New PCEP Message Read!");
            boolean pceMsg = true;
            switch (PCEPMessage.getMessageType((byte[])this.msg)) {
                case 1: {
                    this.log.info("OPEN message received");
                    this.log.warn("OPEN message ignored");
                    break;
                }
                case 2: {
                    this.log.info("KEEPALIVE message received");
                    break;
                }
                case 7: {
                    this.log.info("CLOSE message received");
                    this.killSession();
                    return;
                }
                case 6: {
                    this.log.info("ERROR message received");
                    break;
                }
                case 5: {
                    this.log.info("Received NOTIFY message");
                    break;
                }
                case 10: {
                    this.log.info("Received Report message");
                    long timeInii = System.nanoTime();
                    try {
                        PCEPReport m_report = new PCEPReport(this.msg);
                        this.log.info(m_report.toString());
                        this.crm.notifyResponseInit(m_report, timeInii);
                        Semaphore semaphore = this.crm.semaphores.get(new Long(((StateReport)m_report.getStateReportList().get(0)).getSRP().getSRP_ID_number()));
                        semaphore.release();
                    }
                    catch (PCEPProtocolViolationException e1) {
                        this.log.warn("Problem decoding report message, ignoring message" + e1.getMessage());
                        e1.printStackTrace();
                    }
                    break;
                }
                case 11: {
                    this.log.info("Received Message Update");
                    if (this.pcepSessionManager.isStateful()) {
                        try {
                            PCEPUpdate pupdt = new PCEPUpdate(this.msg);
                        }
                        catch (PCEPProtocolViolationException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    this.log.warn("Received Update message and sessions is not stateful");
                    break;
                }
                case 4: {
                    this.log.info("Received PCE RESPONSE message");
                    long timeIni = System.nanoTime();
                    try {
                        PCEPResponse pcres = new PCEPResponse(this.msg);
                        this.log.info("IdResponse: " + pcres.getResponse(0).getRequestParameters().getRequestID());
                        Object lock = this.crm.locks.get(new Long(pcres.getResponse(0).getRequestParameters().getRequestID()));
                        if (lock != null) {
                            Object object = lock;
                            synchronized (object) {
                                this.crm.notifyResponse(pcres, timeIni);
                                break;
                            }
                        }
                        this.log.warn("Ha llegado la response con ID: " + pcres.getResponse(0).getRequestParameters().getRequestID() + " Y el lock era null.");
                    }
                    catch (PCEPProtocolViolationException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 12: {
                    this.log.info("Received INITIATE message");
                    long timeIni = System.nanoTime();
                    try {
                        PCEPInitiate p_init = new PCEPInitiate(this.msg);
                        PathSetupTLV pstlv = ((PCEPIntiatedLSP)p_init.getPcepIntiatedLSPList().get(0)).getRsp().getPathSetupTLV();
                        if (pstlv != null && pstlv.isSR()) {
                            this.log.info("Found initiate message with segment routing..sending report");
                            ExplicitRouteObject srero = ((PCEPIntiatedLSP)p_init.getPcepIntiatedLSPList().get(0)).getEro();
                            SRP rsp = ((PCEPIntiatedLSP)p_init.getPcepIntiatedLSPList().get(0)).getRsp();
                            LSP lsp = ((PCEPIntiatedLSP)p_init.getPcepIntiatedLSPList().get(0)).getLsp();
                            PCEPReport pcrep = new PCEPReport();
                            StateReport srep = new StateReport();
                            Path path = new Path();
                            path.setEro(srero);
                            srep.setSRP(rsp);
                            srep.setLSP(lsp);
                            srep.setPath(path);
                            pcrep.addStateReport(srep);
                            this.log.info("Sending message to pce...");
                            this.sendPCEPMessage((PCEPMessage)pcrep);
                            this.log.info("Message sent!");
                            break;
                        }
                        this.log.info("Found initiate message without segment routing.");
                        ExplicitRouteObject ero = ((PCEPIntiatedLSP)p_init.getPcepIntiatedLSPList().get(0)).getEro();
                        ERO eroOther = new ERO();
                        eroOther.setEroSubobjects(ero.getEROSubobjectList());
                        Inet4Address destinationId = ((EndPointsIPv4)((PCEPIntiatedLSP)p_init.getPcepIntiatedLSPList().get(0)).getEndPoint()).getDestIP();
                    }
                    catch (Exception e) {
                        this.log.error("PROBLEMON");
                        e.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.log.info("PCREQ message received");
                    break;
                }
                default: {
                    this.log.info("ERROR: unexpected message PCCCEPSession with type : " + PCEPMessage.getMessageType((byte[])this.msg));
                    pceMsg = false;
                }
            }
            if (!pceMsg) continue;
            this.log.info("Reseting Dead Timer as PCEP Message has arrived");
            this.resetDeadTimer();
        }
    }

    private void manageEndSession() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.log.info(UtilsFunctions.exceptionToString(e));
            }
            try {
                this.socket = new Socket(this.peerPCE_IPaddress, this.peerPCE_port);
                this.log.info("Socket opened in retry after connection went down");
                this.run();
                return;
            }
            catch (IOException e) {
                this.log.info("Wasn't able to connect this time");
                continue;
            }
            break;
        }
    }

    public int getPeerPCE_port() {
        return this.peerPCE_port;
    }

    public String getPeerPCE_IPaddress() {
        return this.peerPCE_IPaddress;
    }

    public synchronized long getNewSessionIDCounter() {
        long newSessionId;
        if (sessionIDCounter == 0L) {
            Calendar rightNow = Calendar.getInstance();
            sessionIDCounter = newSessionId = (long)rightNow.get(13);
        } else {
            sessionIDCounter = sessionIDCounter >= 0xFFFFFFFDL ? (newSessionId = 1L) : (newSessionId = sessionIDCounter + 1L);
        }
        return newSessionId;
    }

    public static synchronized long getNewReqIDCounter() {
        long newReqId;
        if (reqIDCounter == 0L) {
            Calendar rightNow = Calendar.getInstance();
            reqIDCounter = newReqId = (long)rightNow.get(13);
        } else {
            reqIDCounter = reqIDCounter >= 0xFFFFFFFDL ? (newReqId = 1L) : (newReqId = reqIDCounter + 1L);
        }
        return newReqId;
    }

    @Override
    public void endSession() {
        this.log.info("Ending PCC session, abruptly?, who knows");
    }

    @Override
    public String toString() {
        return "(" + this.peerPCE_IPaddress + " - " + this.peerPCE_port + ")";
    }
}

