/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.client;

import es.tid.pce.client.QuickClientObj;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import java.util.LinkedList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickClientMain {
    public static final Logger Log = LoggerFactory.getLogger((String)"PCCClient");

    public static void main(String[] args) {
        Option gOpt = new Option("g", "Generalized end points");
        Option eroOpt = new Option("ero", "Explicit Route Object");
        Option iniOpt = new Option("ini", "Send init message");
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set of value");
        Option ofOpt = OptionBuilder.create((String)"of");
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set rgbw value");
        Option rgbwOpt = OptionBuilder.create((String)"rgbw");
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"local interface");
        Option liOpt = OptionBuilder.create((String)"li");
        Options options = new Options();
        options.addOption(liOpt);
        options.addOption(gOpt);
        options.addOption(eroOpt);
        options.addOption(iniOpt);
        options.addOption(ofOpt);
        options.addOption(rgbwOpt);
        if (args.length < 4) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("PCC-QuickClient <host> <port> <src> <dst> [options]", options);
            return;
        }
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            try {
                Logger log2 = LoggerFactory.getLogger((String)"PCEPParser");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                System.exit(1);
            }
            String ip = args[0];
            int port = Integer.valueOf(args[1]);
            QuickClientObj qcObj = new QuickClientObj(Log, ip, port);
            if (line.hasOption("li")) {
                qcObj.setLocalAddress(line.getOptionValue("li"));
            }
            qcObj.start();
            System.out.println("Creando el mensaje");
            Request req = qcObj.createReqMessage(args[2], args[3], line);
            System.out.println("Peticion " + req.toString());
            PCEPRequest p_r = new PCEPRequest();
            p_r.addRequest(req);
            LinkedList<PCEPMessage> messageList = new LinkedList<PCEPMessage>();
            System.out.println("Enviando mensaje");
            PCEPResponse res = qcObj.sendReqMessage(p_r, messageList);
            System.out.println("Enviado!!!");
            System.out.println("Respuesta " + res.toString());
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("PCC-QuickClient <host> <port> <src> <dst> [options]", options);
        }
        System.exit(-1);
    }
}

