/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.of.DataPathID;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.ErrorConstruct;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPError;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.messages.PCEPResponse;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.PCEPErrorObject;
import es.tid.pce.pcep.objects.SRP;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.ReachabilityManager;
import es.tid.util.UtilsFunctions;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputingResponse {
    private byte[] messageBytes;
    private int encodingType = 4;
    public LinkedList<Response> ResponseList;
    private Logger log = LoggerFactory.getLogger((String)"PCEP listener");
    public LinkedList<StateReport> ReportList;
    private ReachabilityManager reachabilityManager;

    public LinkedList<StateReport> getReportList() {
        return this.ReportList;
    }

    public void setReportList(LinkedList<StateReport> reportList) {
        this.ReportList = reportList;
    }

    public ComputingResponse() {
        this.ResponseList = new LinkedList();
        this.ReportList = new LinkedList();
    }

    public void addResponse(Response response) {
        this.ResponseList.add(response);
    }

    public Response getResponse(int index) {
        return this.ResponseList.get(index);
    }

    public void addReport(StateReport report) {
        this.ReportList.add(report);
    }

    public StateReport getResport(int index) {
        return this.ReportList.get(index);
    }

    public LinkedList<Response> getResponseList() {
        return this.ResponseList;
    }

    public void setResponsetList(LinkedList<Response> responseList) {
        this.ResponseList = responseList;
    }

    public void encode(boolean isFather) throws PCEPProtocolViolationException {
        switch (this.encodingType) {
            case 4: {
                PCEPResponse p_resp = new PCEPResponse();
                p_resp.setResponsetList(this.ResponseList);
                p_resp.encode();
                this.setMessageBytes(p_resp.getBytes());
                break;
            }
            case 12: {
                if (isFather) {
                    EroAndIP EaIP;
                    ExplicitRouteObject ero = this.ResponseList.get(0).getPath(0).geteRO();
                    int n = 2;
                    while ((EaIP = this.getNthSubERO(ero, n)) != null) {
                        this.createInitAndSend(EaIP);
                        ++n;
                    }
                    EaIP = this.getNthSubERO(ero, 1);
                    PCEPInitiate pInit = new PCEPInitiate();
                    LinkedList<PCEPIntiatedLSP> pcepIntiatedLSPList = new LinkedList<PCEPIntiatedLSP>();
                    PCEPIntiatedLSP pILSP = new PCEPIntiatedLSP();
                    LSP lsp = new LSP();
                    SRP rsp = new SRP();
                    ExplicitRouteObject ero_lsp = EaIP.ero;
                    pILSP.setLsp(lsp);
                    pILSP.setRsp(rsp);
                    pILSP.setEro(ero_lsp);
                    pcepIntiatedLSPList.add(pILSP);
                    try {
                        pInit.encode();
                    }
                    catch (Exception e) {
                        this.log.info(UtilsFunctions.exceptionToString(e));
                    }
                    this.setMessageBytes(pInit.getBytes());
                    break;
                }
                PCEPInitiate pInit = new PCEPInitiate();
                LinkedList<PCEPIntiatedLSP> pcepIntiatedLSPList = new LinkedList<PCEPIntiatedLSP>();
                for (int i = 0; i < this.ResponseList.size(); ++i) {
                    PCEPIntiatedLSP pILSP = new PCEPIntiatedLSP();
                    LSP lsp = new LSP();
                    SRP rsp = new SRP();
                    ExplicitRouteObject ero = this.ResponseList.get(i).getPath(0).geteRO();
                    pILSP.setLsp(lsp);
                    pILSP.setRsp(rsp);
                    pILSP.setEro(ero);
                    pcepIntiatedLSPList.add(pILSP);
                }
                pInit.setPcepIntiatedLSPList(pcepIntiatedLSPList);
                pInit.encode();
                this.log.info("Encoding Son Finished, pInit.getBytes(): " + pInit.getBytes());
                this.setMessageBytes(pInit.getBytes());
                break;
            }
            case 10: {
                if (this.ReportList.isEmpty()) {
                    PCEPError perror = new PCEPError();
                    ErrorConstruct error = new ErrorConstruct();
                    PCEPErrorObject e = new PCEPErrorObject();
                    e.setErrorType(24);
                    e.setErrorValue(3);
                    error.getErrorObjList().add(e);
                    perror.setError(error);
                    break;
                }
                PCEPReport p_rep = new PCEPReport();
                p_rep.setStateReportList(this.ReportList);
                p_rep.encode();
                this.setMessageBytes(p_rep.getBytes());
            }
        }
    }

    private void createInitAndSend(EroAndIP EaIP) {
        PCEPInitiate pInit = new PCEPInitiate();
        LinkedList<PCEPIntiatedLSP> pcepIntiatedLSPList = new LinkedList<PCEPIntiatedLSP>();
        PCEPIntiatedLSP pILSP = new PCEPIntiatedLSP();
        LSP lsp = new LSP();
        SRP rsp = new SRP();
        ExplicitRouteObject ero_lsp = EaIP.ero;
        pILSP.setLsp(lsp);
        pILSP.setRsp(rsp);
        pILSP.setEro(ero_lsp);
        pcepIntiatedLSPList.add(pILSP);
        try {
            pInit.encode();
            Socket clientSocket = new Socket(EaIP.address, 2222);
            DataOutputStream out_to_node = new DataOutputStream(clientSocket.getOutputStream());
            out_to_node.write(pInit.getBytes());
            out_to_node.flush();
        }
        catch (Exception e) {
            this.log.info(UtilsFunctions.exceptionToString(e));
        }
    }

    private EroAndIP getNthSubERO(ExplicitRouteObject ero, int n) {
        Inet4Address firstID = null;
        for (int i = 0; i < ero.getEROSubobjectList().size(); ++i) {
            if (!(ero.getEROSubobjectList().get(i) instanceof UnnumberIfIDEROSubobject)) continue;
            UnnumberIfIDEROSubobject unAux = (UnnumberIfIDEROSubobject)ero.getEROSubobjectList().get(i);
            firstID = this.reachabilityManager.getDomain(unAux.getRouterID());
            break;
        }
        int offset = 0;
        int i = 0;
        Inet4Address currentID = firstID;
        ExplicitRouteObject subERO = null;
        EroAndIP EaIP = new EroAndIP();
        EaIP.ero = subERO;
        for (int j = 0; j < n; ++j) {
            subERO = new ExplicitRouteObject();
            boolean hasDomainChanged = false;
            if (offset >= ero.getEROSubobjectList().size()) {
                return null;
            }
            while (offset < ero.getEROSubobjectList().size() && !hasDomainChanged) {
                EROSubobject currentERO = (EROSubobject)ero.getEROSubobjectList().get(offset);
                if (ero.getEROSubobjectList().get(offset) instanceof UnnumberIfIDEROSubobject) {
                    UnnumberIfIDEROSubobject unAux = (UnnumberIfIDEROSubobject)ero.getEROSubobjectList().get(i);
                    currentID = this.reachabilityManager.getDomain(unAux.getRouterID());
                    if (currentID != null && firstID.equals(currentID)) {
                        subERO.addEROSubobject(currentERO);
                    } else {
                        hasDomainChanged = true;
                    }
                } else {
                    subERO.addEROSubobject(currentERO);
                }
                ++offset;
            }
            try {
                EaIP.address = (Inet4Address)InetAddress.getByAddress(firstID.getAddress());
            }
            catch (UnknownHostException e) {
                this.log.info("NO EaIP.address; try EaIP.dataPathID");
                EaIP.dataPath = DataPathID.getByNameBytes((byte[])firstID.getAddress());
            }
            firstID = currentID;
            --offset;
        }
        return EaIP;
    }

    public void encode() throws PCEPProtocolViolationException {
        this.encode(false);
    }

    public int getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(int encodingType) {
        this.encodingType = encodingType;
    }

    public byte[] getBytes() {
        return this.messageBytes;
    }

    public void setMessageBytes(byte[] messageBytes) {
        this.messageBytes = messageBytes;
    }

    public ReachabilityManager getReachabilityManager() {
        return this.reachabilityManager;
    }

    public void setReachabilityManager(ReachabilityManager reachabilityManager) {
        this.reachabilityManager = reachabilityManager;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.ResponseList.size() * 100);
        sb.append("RESP: ");
        for (int i = 0; i < this.ResponseList.size(); ++i) {
            sb.append(this.ResponseList.get(i).toString());
        }
        return sb.toString();
    }

    private class EroAndIP {
        ExplicitRouteObject ero;
        Inet4Address address;
        DataPathID dataPath;

        private EroAndIP() {
        }
    }
}

