/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputingTask
extends FutureTask<ComputingResponse> {
    ComputingAlgorithm algorithm;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer.log");

    public ComputingTask(ComputingAlgorithm algorithm) {
        super(algorithm);
        this.algorithm = algorithm;
    }

    public ComputingResponse executeReservation() {
        AlgorithmReservation res = this.algorithm.getReserv();
        if (res != null) {
            ComputingResponse resp;
            this.log.info("Comienza la reserva");
            try {
                resp = (ComputingResponse)this.algorithm.getReserv().call();
            }
            catch (Exception e) {
                return null;
            }
            this.log.info("Acaba la reserva");
            return resp;
        }
        return null;
    }
}

