/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.InitiationRequest;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.parentPCE.MDLSPDB.MultiDomainLSPDB;
import es.tid.pce.parentPCE.MDLSPDB.SaveLSPinRedis;
import es.tid.pce.parentPCE.MD_LSP;
import es.tid.pce.parentPCE.ParentPCESession;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcep.objects.tlvs.EndPointIPv4TLV;
import es.tid.pce.pcep.objects.tlvs.SymbolicPathNameTLV;
import es.tid.pce.pcep.objects.tlvs.UnnumberedEndpointTLV;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.ReachabilityManager;
import java.net.Inet4Address;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniProcessorThread
extends Thread {
    private static int lspIdSeq = 1;
    private MultiDomainLSPDB multiDomainLSPDB;
    private LinkedBlockingQueue<InitiationRequest> lspInitiationRequestQueue;
    private ChildPCERequestManager childPCERequestManager;
    private ReachabilityManager reachabilityManager;
    private boolean running;
    SaveLSPinRedis savelsp;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public LinkedBlockingQueue<InitiationRequest> getLspInitiationRequestQueue() {
        return this.lspInitiationRequestQueue;
    }

    public void setLspInitiationRequestQueue(LinkedBlockingQueue<InitiationRequest> lspInitiationRequestQueue) {
        this.lspInitiationRequestQueue = lspInitiationRequestQueue;
    }

    public IniProcessorThread(LinkedBlockingQueue<InitiationRequest> lspInitiationRequestQueue, ReachabilityManager reachabilityManager, ChildPCERequestManager childPCERequestManager, MultiDomainLSPDB multiDomainLSPDB) {
        this.lspInitiationRequestQueue = lspInitiationRequestQueue;
        this.reachabilityManager = reachabilityManager;
        this.childPCERequestManager = childPCERequestManager;
        this.multiDomainLSPDB = multiDomainLSPDB;
        this.savelsp = new SaveLSPinRedis();
        this.savelsp.configure(multiDomainLSPDB, "127.0.0.1", 6379);
        this.running = true;
    }

    @Override
    public void run() {
        ExplicitRouteObject fullEro = null;
        while (this.running) {
            this.log.info("Waiting for a new Initiation Request");
            try {
                InitiationRequest iniReq = this.lspInitiationRequestQueue.take();
                PCEPIntiatedLSP pini = iniReq.getLspIniRequest();
                long sRP_ID_number = pini.getRsp().getSRP_ID_number();
                if (pini.getRsp().isrFlag()) {
                    this.delete(pini.getLsp().getLspId());
                } else {
                    boolean needComputation = false;
                    if (pini.getEro() != null) {
                        needComputation = false;
                        this.log.info("Provision Multidomain LSP  with ERO");
                    } else {
                        needComputation = true;
                        this.log.info("Provision Multidomain LSP that needs computation");
                    }
                    fullEro = needComputation ? null : pini.getEro();
                    LinkedList<PCEPInitiate> iniList = new LinkedList<PCEPInitiate>();
                    this.log.debug("Creating the bandwidth");
                    Bandwidth bw = null;
                    if (pini.getBandwidth() != null) {
                        bw = pini.getBandwidth().duplicate();
                    }
                    this.log.info("Creating the Domain list");
                    Iterator eroi = fullEro.getEROSubobjectList().iterator();
                    Inet4Address lastDomain = null;
                    Hashtable<Inet4Address, ExplicitRouteObject> eroSplit = new Hashtable<Inet4Address, ExplicitRouteObject>();
                    ExplicitRouteObject lastEro = null;
                    Inet4Address domain = null;
                    while (eroi.hasNext()) {
                        EROSubobject eroso = (EROSubobject)eroi.next();
                        if (eroso instanceof IPv4prefixEROSubobject) {
                            domain = this.reachabilityManager.getDomain(((IPv4prefixEROSubobject)eroso).getIpv4address());
                        } else if (eroso instanceof UnnumberIfIDEROSubobject) {
                            domain = this.reachabilityManager.getDomain(((UnnumberIfIDEROSubobject)eroso).getRouterID());
                            this.log.info("A3: " + domain);
                        }
                        if (domain != null) {
                            ExplicitRouteObject eeero;
                            if (lastDomain == null) {
                                lastEro = eeero = new ExplicitRouteObject();
                                eeero.addEROSubobject(eroso);
                                eroSplit.put(domain, eeero);
                                lastDomain = domain;
                                continue;
                            }
                            if (domain.equals(lastDomain)) {
                                lastEro.addEROSubobject(eroso);
                                continue;
                            }
                            this.log.info("New domaiiin");
                            lastEro = eeero = new ExplicitRouteObject();
                            eeero.addEROSubobject(eroso);
                            eroSplit.put(domain, eeero);
                            lastDomain = domain;
                            continue;
                        }
                        lastEro.addEROSubobject(eroso);
                    }
                    Enumeration domains = eroSplit.keys();
                    LinkedList<Object> domainList = new LinkedList<Object>();
                    while (domains.hasMoreElements()) {
                        domain = (Inet4Address)domains.nextElement();
                        this.log.info("Starting with domain " + domain);
                        PCEPInitiate ini = new PCEPInitiate();
                        PCEPIntiatedLSP inilsp = new PCEPIntiatedLSP();
                        ini.getPcepIntiatedLSPList().add(inilsp);
                        SRP srp = new SRP();
                        srp.setSRP_ID_number((long)ParentPCESession.getNewReqIDCounter());
                        inilsp.setRsp(srp);
                        this.log.info("Getting endpoints of Domain " + domain);
                        inilsp.setEndPoint(this.getEndPoints((ExplicitRouteObject)eroSplit.get(domain)));
                        inilsp.setEro((ExplicitRouteObject)eroSplit.get(domain));
                        inilsp.setBandwidth(bw);
                        LSP lsp = new LSP();
                        lsp.setLspId(0);
                        SymbolicPathNameTLV symbolicPathNameTLV_tlv = new SymbolicPathNameTLV();
                        String name = "IDEALIST " + ParentPCESession.getNewReqIDCounter();
                        byte[] symbolicPathNameID = name.getBytes();
                        symbolicPathNameTLV_tlv.setSymbolicPathNameID(symbolicPathNameID);
                        lsp.setSymbolicPathNameTLV_tlv(symbolicPathNameTLV_tlv);
                        inilsp.setLsp(lsp);
                        iniList.add(ini);
                        domainList.add(domain);
                    }
                    try {
                        if (this.childPCERequestManager == null) {
                            this.log.error("o ooooooooo");
                        }
                        LinkedList<ComputingResponse> reps = this.childPCERequestManager.executeInitiates(iniList, domainList);
                        this.log.info("Hay " + reps.size() + " reps");
                        MD_LSP mdlsp = new MD_LSP();
                        mdlsp.setFullERO(fullEro);
                        for (int i = 0; i < reps.size(); ++i) {
                            ComputingResponse cr = reps.get(i);
                            LinkedList<StateReport> lsr = cr.ReportList;
                            StateReport sr = lsr.get(0);
                            int id = sr.getLSP().getLspId();
                            mdlsp.getDomainLSPIDMap().put((Inet4Address)domainList.get(i), new Integer(id));
                            mdlsp.getDomainLSRMpa().put((Inet4Address)domainList.get(i), sr);
                        }
                        int lspId = IniProcessorThread.getID();
                        this.multiDomainLSPDB.getMultiDomain_LSP_list().put(lspId, mdlsp);
                        StateReport srmd = new StateReport();
                        SRP srp = new SRP();
                        srp.setSRP_ID_number(sRP_ID_number);
                        srmd.setSRP(srp);
                        LSP lsp = new LSP();
                        lsp.setLspId(lspId);
                        srmd.setLSP(lsp);
                        Path p = new Path();
                        p.setEro(fullEro);
                        srmd.setPath(p);
                        PCEPReport rep = new PCEPReport();
                        rep.getStateReportList().add(srmd);
                        rep.encode();
                        this.log.info("Mando: " + rep.toString());
                        iniReq.getOut().write(rep.getBytes());
                        iniReq.getOut().flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.error("PROBLEM SENDING THE INITIATES");
                    }
                }
                try {
                    this.savelsp.run();
                    continue;
                }
                catch (Exception e) {
                    this.log.warn("Save LSP in Redis fail");
                    e.printStackTrace();
                }
            }
            catch (InterruptedException e) {
                this.log.warn("There is no ini to make");
                e.printStackTrace();
            }
            break;
        }
    }

    public EndPoints getEndPoints(ExplicitRouteObject ero) {
        Iterator eroi = ero.getEROSubobjectList().iterator();
        GeneralizedEndPoints gep = new GeneralizedEndPoints();
        P2PEndpoints p2pEndpoints = new P2PEndpoints();
        EndPoint sourceEndPoint = null;
        EndPoint destinationEndPoint = null;
        gep.setP2PEndpoints(p2pEndpoints);
        while (eroi.hasNext()) {
            EndPointIPv4TLV epipv4;
            EROSubobject eroso = (EROSubobject)eroi.next();
            if (eroso instanceof IPv4prefixEROSubobject) {
                if (sourceEndPoint == null) {
                    sourceEndPoint = new EndPoint();
                    epipv4 = new EndPointIPv4TLV();
                    epipv4.setIPv4address(((IPv4prefixEROSubobject)eroso).getIpv4address());
                    sourceEndPoint.setEndPointIPv4TLV(epipv4);
                    continue;
                }
                if (eroi.hasNext()) continue;
                destinationEndPoint = new EndPoint();
                epipv4 = new EndPointIPv4TLV();
                epipv4.setIPv4address(((IPv4prefixEROSubobject)eroso).getIpv4address());
                destinationEndPoint.setEndPointIPv4TLV(epipv4);
                continue;
            }
            if (!(eroso instanceof UnnumberIfIDEROSubobject)) continue;
            if (sourceEndPoint == null) {
                sourceEndPoint = new EndPoint();
                epipv4 = new UnnumberedEndpointTLV();
                epipv4.setIPv4address(((UnnumberIfIDEROSubobject)eroso).getRouterID());
                epipv4.setIfID(((UnnumberIfIDEROSubobject)eroso).getInterfaceID());
                sourceEndPoint.setUnnumberedEndpoint((UnnumberedEndpointTLV)epipv4);
                destinationEndPoint = new EndPoint();
                UnnumberedEndpointTLV epipv42 = new UnnumberedEndpointTLV();
                epipv42.setIPv4address(((UnnumberIfIDEROSubobject)eroso).getRouterID());
                epipv42.setIfID(((UnnumberIfIDEROSubobject)eroso).getInterfaceID());
                destinationEndPoint.setUnnumberedEndpoint(epipv42);
                continue;
            }
            destinationEndPoint = new EndPoint();
            epipv4 = new UnnumberedEndpointTLV();
            epipv4.setIPv4address(((UnnumberIfIDEROSubobject)eroso).getRouterID());
            epipv4.setIfID(((UnnumberIfIDEROSubobject)eroso).getInterfaceID());
            destinationEndPoint.setUnnumberedEndpoint((UnnumberedEndpointTLV)epipv4);
        }
        p2pEndpoints.setSourceEndpoint(sourceEndPoint);
        p2pEndpoints.setDestinationEndPoints(destinationEndPoint);
        return gep;
    }

    public void delete(int lspID) {
        this.log.info("GOING TO DELTE " + lspID);
        MD_LSP mdlsp = this.multiDomainLSPDB.getMultiDomain_LSP_list().get(lspID);
        if (mdlsp == null) {
            this.log.error("LSP is NULL!!");
        }
        LinkedList<PCEPInitiate> iniList = new LinkedList<PCEPInitiate>();
        LinkedList<Object> domainList = new LinkedList<Object>();
        if (mdlsp != null) {
            this.log.info("LSP OK in DB!!!");
            Enumeration<Inet4Address> domains = mdlsp.getDomainLSPIDMap().keys();
            while (domains.hasMoreElements()) {
                Inet4Address domain = domains.nextElement();
                PCEPInitiate ini = new PCEPInitiate();
                PCEPIntiatedLSP inilsp = new PCEPIntiatedLSP();
                ini.getPcepIntiatedLSPList().add(inilsp);
                SRP srp = new SRP();
                srp.setSRP_ID_number((long)ParentPCESession.getNewReqIDCounter());
                inilsp.setRsp(srp);
                srp.setRFlag(true);
                LSP lsp = new LSP();
                SymbolicPathNameTLV symbolicPathNameTLV_tlv = new SymbolicPathNameTLV();
                StateReport SR = mdlsp.getDomainLSRMpa().get(domain);
                if (SR.getLSP().getSymbolicPathNameTLV_tlv() != null) {
                    symbolicPathNameTLV_tlv.setSymbolicPathNameID(SR.getLSP().getSymbolicPathNameTLV_tlv().getSymbolicPathNameID());
                    lsp.setSymbolicPathNameTLV_tlv(symbolicPathNameTLV_tlv);
                } else {
                    this.log.warn("NO SYMBOLIC PATH NAME TLV!!!");
                }
                lsp.setLspId(mdlsp.getDomainLSPIDMap().get(domain).intValue());
                inilsp.setLsp(lsp);
                iniList.add(ini);
                domainList.add(domain);
            }
            try {
                this.log.info("GOING TO send the deletes of " + lspID);
                this.childPCERequestManager.executeInitiates(iniList, domainList);
                this.log.info("Removing MD LSP " + lspID);
                this.multiDomainLSPDB.getMultiDomain_LSP_list().remove(lspID);
            }
            catch (Exception e) {
                this.log.error("PROBLEM SENDING THE DELETES");
            }
        }
    }

    public static synchronized int getID() {
        return ++lspIdSeq;
    }
}

