/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.ReportProcessorThread;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.server.lspdb.ReportDB_Handler;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportDispatcher {
    private final int nThreads;
    private final ReportProcessorThread[] threads;
    private LinkedBlockingQueue<PCEPReport> reportMessageQueue;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public ReportDispatcher(ReportDB_Handler lspDB, int nThreads) {
        this.nThreads = nThreads;
        this.reportMessageQueue = new LinkedBlockingQueue();
        this.threads = new ReportProcessorThread[nThreads];
        for (int i = 0; i < this.nThreads; ++i) {
            this.log.info("Starting Request Processor Thread");
            this.threads[i] = new ReportProcessorThread(this.reportMessageQueue, lspDB);
            this.threads[i].setPriority(10);
            this.threads[i].start();
        }
    }

    public void dispatchReport(PCEPReport pcepReport) {
        this.reportMessageQueue.add(pcepReport);
    }
}

