/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.server.lspdb.ReportDB_Handler;
import java.net.Inet4Address;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportProcessorThread
extends Thread {
    boolean running = true;
    LinkedBlockingQueue<PCEPReport> reportMessageQueue;
    ReportDB_Handler lspDB;
    Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public ReportProcessorThread(LinkedBlockingQueue<PCEPReport> reportMessageQueue, ReportDB_Handler lspDB) {
        this.lspDB = lspDB;
        this.reportMessageQueue = reportMessageQueue;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                PCEPReport report_m = this.reportMessageQueue.take();
                this.effectivelyDispatch(report_m);
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted Exception Captured in ReportProcessorThread");
                e.printStackTrace();
                break;
            }
        }
    }

    public void effectivelyDispatch(PCEPReport pcepReport) {
        this.log.info("Received new report message: " + pcepReport.toString());
        this.log.info("whith ID :" + ((StateReport)pcepReport.getStateReportList().get(0)).getLSP().getLspId());
        Inet4Address addres = ((StateReport)pcepReport.getStateReportList().get(0)).getLSP().getLspIdentifiers_tlv().getTunnelSenderIPAddress();
        Boolean isSyncOver = false;
        this.log.info("Size LSP:" + pcepReport.getStateReportList().size());
        this.log.info("Package received from adress: " + ((StateReport)pcepReport.getStateReportList().get(0)).getLSP().getLspIdentifiers_tlv().getTunnelSenderIPAddress());
        if (!isSyncOver.booleanValue()) {
            int numLSPs = pcepReport.getStateReportList().size();
            for (int j = 0; j < numLSPs; ++j) {
                boolean syncFlag = ((StateReport)pcepReport.getStateReportList().get(j)).getLSP().issFlag();
                if (syncFlag || ((StateReport)pcepReport.getStateReportList().get(j)).getLSP().getLspId() != 0) continue;
                isSyncOver = true;
                this.log.info("Sync is over");
            }
        }
        for (int i = 0; i < pcepReport.getStateReportList().size(); ++i) {
            this.lspDB.processReport(pcepReport);
        }
    }
}

