/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.AlgorithmRule;
import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.ComputingTask;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmManager;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmManagerSSON;
import es.tid.pce.computingEngine.algorithms.DefaultSVECPathComputing;
import es.tid.pce.computingEngine.algorithms.DefaultSinglePathComputing;
import es.tid.pce.computingEngine.algorithms.multiLayer.OperationsCounter;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.ErrorConstruct;
import es.tid.pce.pcep.constructs.MetricPCE;
import es.tid.pce.pcep.constructs.Notify;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.messages.PCEPError;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPNotification;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPResponse;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.EndPointsUnnumberedIntf;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.Notification;
import es.tid.pce.pcep.objects.ObjectiveFunction;
import es.tid.pce.pcep.objects.PCEPErrorObject;
import es.tid.pce.pcep.objects.PceId;
import es.tid.pce.pcep.objects.PceIdIPv4;
import es.tid.pce.pcep.objects.ProcTime;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.pcep.objects.tlvs.PathReservationTLV;
import es.tid.pce.server.ParentPCERequestManager;
import es.tid.pce.server.communicationpce.CollaborationPCESessionManager;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.TEDB;
import es.tid.util.Analysis;
import es.tid.util.UtilsFunctions;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessorThread
extends Thread {
    private Analysis idleTime;
    private Analysis procTime;
    private LinkedBlockingQueue<ComputingRequest> pathComputingRequestQueue;
    private Hashtable<String, TEDB> intraTEDBs;
    private LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue;
    private boolean running;
    private Hashtable<Integer, ComputingAlgorithmManager> singleAlgorithmList;
    private Hashtable<Integer, ComputingAlgorithmManagerSSON> singleAlgorithmListsson;
    private Hashtable<Integer, ComputingAlgorithmManager> svecAlgorithmList;
    private Hashtable<Integer, ComputingAlgorithmManagerSSON> svecAlgorithmListsson;
    private Logger log;
    private TEDB ted;
    private ComputingTask ft;
    private ParentPCERequestManager cpcerm;
    private Inet4Address source;
    private Inet4Address dest;
    private OperationsCounter opCounter;
    private boolean isChildPCE;
    private boolean isMultilayer = false;
    private boolean analyzeRequestTime;
    private boolean useMaxReqTime;
    private double maxProcTime;
    private long numReqProcessed = 0L;
    private long numAnswersSent = 0L;
    private long numNoPathOLSent = 0L;
    private ReservationManager reservationManager;
    CollaborationPCESessionManager collaborationPCESessionManager;

    public RequestProcessorThread(LinkedBlockingQueue<ComputingRequest> queue, TEDB ted, ParentPCERequestManager cpcerm, LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue, boolean analyzeRequestTime) {
        this.useMaxReqTime = false;
        this.pathComputingRequestQueue = queue;
        this.running = true;
        this.ted = ted;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.singleAlgorithmList = new Hashtable();
        this.svecAlgorithmList = new Hashtable();
        this.singleAlgorithmListsson = new Hashtable();
        this.cpcerm = cpcerm;
        if (cpcerm != null) {
            this.isChildPCE = true;
        }
        this.pathComputingRequestRetryQueue = pathComputingRequestRetryQueue;
        if (analyzeRequestTime) {
            this.idleTime = new Analysis();
            this.procTime = new Analysis();
            this.analyzeRequestTime = analyzeRequestTime;
        } else {
            analyzeRequestTime = false;
        }
    }

    public RequestProcessorThread(LinkedBlockingQueue<ComputingRequest> queue, TEDB ted, ParentPCERequestManager cpcerm, LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue, boolean analyzeRequestTime, boolean useMaxReqTime, ReservationManager reservationManager) {
        this.pathComputingRequestQueue = queue;
        this.running = true;
        this.ted = ted;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.singleAlgorithmList = new Hashtable();
        this.svecAlgorithmList = new Hashtable();
        this.singleAlgorithmListsson = new Hashtable();
        this.svecAlgorithmListsson = new Hashtable();
        this.cpcerm = cpcerm;
        if (cpcerm != null) {
            this.isChildPCE = true;
        }
        this.pathComputingRequestRetryQueue = pathComputingRequestRetryQueue;
        if (analyzeRequestTime) {
            this.idleTime = new Analysis();
            this.procTime = new Analysis();
            this.analyzeRequestTime = analyzeRequestTime;
            this.maxProcTime = 0.0;
        } else {
            analyzeRequestTime = false;
        }
        this.useMaxReqTime = useMaxReqTime;
        this.reservationManager = reservationManager;
        if (useMaxReqTime) {
            this.log.info("USING MAX REQ TIME");
        }
    }

    public RequestProcessorThread(LinkedBlockingQueue<ComputingRequest> queue, TEDB ted, ParentPCERequestManager cpcerm, LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue, boolean analyzeRequestTime, boolean useMaxReqTime, ReservationManager reservationManager, OperationsCounter OPcounter, boolean isMult) {
        this.pathComputingRequestQueue = queue;
        this.running = true;
        this.ted = ted;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.singleAlgorithmList = new Hashtable();
        this.svecAlgorithmList = new Hashtable();
        this.singleAlgorithmListsson = new Hashtable();
        this.svecAlgorithmListsson = new Hashtable();
        this.cpcerm = cpcerm;
        this.opCounter = OPcounter;
        this.isMultilayer = isMult;
        if (cpcerm != null) {
            this.isChildPCE = true;
        }
        this.pathComputingRequestRetryQueue = pathComputingRequestRetryQueue;
        if (analyzeRequestTime) {
            this.idleTime = new Analysis();
            this.procTime = new Analysis();
            this.analyzeRequestTime = analyzeRequestTime;
            this.maxProcTime = 0.0;
        } else {
            analyzeRequestTime = false;
        }
        this.useMaxReqTime = useMaxReqTime;
        this.reservationManager = reservationManager;
        if (useMaxReqTime) {
            this.log.info("USING MAX REQ TIME");
        }
    }

    public RequestProcessorThread(LinkedBlockingQueue<ComputingRequest> queue, TEDB ted, ParentPCERequestManager cpcerm, LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue, boolean analyzeRequestTime, Hashtable<String, TEDB> intraTEDBs) {
        this.useMaxReqTime = false;
        this.pathComputingRequestQueue = queue;
        this.running = true;
        this.ted = ted;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.singleAlgorithmList = new Hashtable();
        this.svecAlgorithmList = new Hashtable();
        this.singleAlgorithmListsson = new Hashtable();
        this.cpcerm = cpcerm;
        if (cpcerm != null) {
            this.isChildPCE = true;
        }
        this.intraTEDBs = intraTEDBs;
        this.pathComputingRequestRetryQueue = pathComputingRequestRetryQueue;
        if (analyzeRequestTime) {
            this.idleTime = new Analysis();
            this.procTime = new Analysis();
            this.analyzeRequestTime = analyzeRequestTime;
        } else {
            analyzeRequestTime = false;
        }
    }

    public RequestProcessorThread(LinkedBlockingQueue<ComputingRequest> queue, TEDB ted, ParentPCERequestManager cpcerm, LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue, boolean analyzeRequestTime, CollaborationPCESessionManager collaborationPCESessionManager) {
        this.useMaxReqTime = false;
        this.pathComputingRequestQueue = queue;
        this.running = true;
        this.ted = ted;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.singleAlgorithmList = new Hashtable();
        this.svecAlgorithmList = new Hashtable();
        this.cpcerm = cpcerm;
        if (cpcerm != null) {
            this.isChildPCE = true;
        }
        this.pathComputingRequestRetryQueue = pathComputingRequestRetryQueue;
        if (analyzeRequestTime) {
            this.idleTime = new Analysis();
            this.procTime = new Analysis();
            this.analyzeRequestTime = analyzeRequestTime;
        } else {
            analyzeRequestTime = false;
        }
        this.collaborationPCESessionManager = collaborationPCESessionManager;
    }

    public RequestProcessorThread(LinkedBlockingQueue<ComputingRequest> queue, TEDB ted, ParentPCERequestManager cpcerm, LinkedBlockingQueue<ComputingRequest> pathComputingRequestRetryQueue, boolean analyzeRequestTime, boolean useMaxReqTime, ReservationManager reservationManager, CollaborationPCESessionManager collaborationPCESessionManager) {
        this.pathComputingRequestQueue = queue;
        this.running = true;
        this.ted = ted;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.singleAlgorithmList = new Hashtable();
        this.svecAlgorithmList = new Hashtable();
        this.singleAlgorithmListsson = new Hashtable();
        this.cpcerm = cpcerm;
        if (cpcerm != null) {
            this.isChildPCE = true;
        }
        this.pathComputingRequestRetryQueue = pathComputingRequestRetryQueue;
        if (analyzeRequestTime) {
            this.idleTime = new Analysis();
            this.procTime = new Analysis();
            this.analyzeRequestTime = analyzeRequestTime;
            this.maxProcTime = 0.0;
        } else {
            analyzeRequestTime = false;
        }
        this.useMaxReqTime = useMaxReqTime;
        this.reservationManager = reservationManager;
        if (useMaxReqTime) {
            this.log.info("USING MAX REQ TIME");
        }
        this.collaborationPCESessionManager = collaborationPCESessionManager;
    }

    public void registerAlgorithm(AlgorithmRule rule, ComputingAlgorithmManager algortithmManager) {
        if (rule.svec) {
            this.svecAlgorithmList.put(new Integer(rule.of), algortithmManager);
        } else {
            this.singleAlgorithmList.put(new Integer(rule.of), algortithmManager);
        }
    }

    public void registerAlgorithmSSON(AlgorithmRule rule, ComputingAlgorithmManagerSSON algortithmManager) {
        if (rule.svec) {
            this.svecAlgorithmListsson.put(new Integer(rule.of), algortithmManager);
        } else {
            this.singleAlgorithmListsson.put(new Integer(rule.of), algortithmManager);
        }
    }

    public void removeAlgorithm(AlgorithmRule rule, ComputingAlgorithmManager algortithmManager) {
        this.singleAlgorithmList.remove(new Integer(rule.of));
        this.svecAlgorithmList.remove(new Integer(rule.of));
    }

    @Override
    public void run() {
        long timePreNanos = System.nanoTime();
        while (this.running) {
            long timeIniNanos;
            block71: {
                long destIF;
                long sourceIF;
                ComputingRequest pathCompReq;
                block69: {
                    block68: {
                        this.log.info("Waiting for a new Computing Request to process");
                        try {
                            double idleTimeV;
                            pathCompReq = this.pathComputingRequestQueue.take();
                            if (!this.analyzeRequestTime || !((idleTimeV = (double)(System.nanoTime() - timePreNanos) / 1000000.0) < 20000.0)) break block68;
                            this.idleTime.analyze(idleTimeV);
                        }
                        catch (InterruptedException e) {
                            this.log.warn("There is no path to compute");
                            e.printStackTrace();
                            break;
                        }
                    }
                    timeIniNanos = System.nanoTime();
                    if (pathCompReq.getRequestList().size() == 1) {
                        this.log.info("Processing New Path Computing request, id: " + pathCompReq.getRequestList().get(0).toString());
                    }
                    sourceIF = 0L;
                    destIF = 0L;
                    P2PEndpoints p2pep = null;
                    try {
                        if (this.ted.isITtedb()) {
                            this.log.info("Processing New Path Computing request, id: " + pathCompReq.getRequestList().get(0).toString());
                            this.source = ((GeneralizedEndPoints)pathCompReq.getRequestList().get(0).getEndPoints()).getP2PEndpoints().getSourceEndPoint().getEndPointIPv4TLV().getIPv4address();
                            this.dest = ((GeneralizedEndPoints)pathCompReq.getRequestList().get(0).getEndPoints()).getP2PEndpoints().getDestinationEndPoint().getEndPointIPv4TLV().getIPv4address();
                            break block69;
                        }
                        try {
                            if (pathCompReq.getRequestList().get(0).getEndPoints() instanceof GeneralizedEndPoints) {
                                this.source = ((EndPointsUnnumberedIntf)pathCompReq.getRequestList().get(0).getEndPoints()).getSourceIP();
                                this.dest = ((EndPointsUnnumberedIntf)pathCompReq.getRequestList().get(0).getEndPoints()).getDestIP();
                                sourceIF = ((EndPointsUnnumberedIntf)pathCompReq.getRequestList().get(0).getEndPoints()).getSourceIF();
                                destIF = ((EndPointsUnnumberedIntf)pathCompReq.getRequestList().get(0).getEndPoints()).getDestIF();
                                this.log.info("SubObjeto: EP-Unnumbered Interface: " + ((EndPointsUnnumberedIntf)pathCompReq.getRequestList().get(0).getEndPoints()).toString());
                                EndPointsIPv4 ep = new EndPointsIPv4();
                                ep.setDestIP(this.dest);
                                ep.setSourceIP(this.source);
                                pathCompReq.getRequestList().get(0).setEndPoints((EndPoints)ep);
                            }
                            this.source = ((EndPointsIPv4)pathCompReq.getRequestList().get(0).getEndPoints()).getSourceIP();
                            this.dest = ((EndPointsIPv4)pathCompReq.getRequestList().get(0).getEndPoints()).getDestIP();
                            this.log.info(" XXXX try source: " + this.source);
                            this.log.info(" XXXX try dest: " + this.dest);
                        }
                        catch (Exception e) {
                            if (pathCompReq.getRequestList().get(0).getEndPoints() instanceof GeneralizedEndPoints) {
                                p2pep = ((GeneralizedEndPoints)pathCompReq.getRequestList().get(0).getEndPoints()).getP2PEndpoints();
                                this.log.info("RequestProcessorThread GeneralizedEndPoints -> sourceDataPath:: " + p2pep.getSourceEndPoint() + " destDataPath :: " + p2pep.getDestinationEndPoint());
                                GeneralizedEndPoints ep = new GeneralizedEndPoints();
                                ep.setP2PEndpoints(p2pep);
                                pathCompReq.getRequestList().get(0).setEndPoints((EndPoints)ep);
                                this.source = p2pep.getSourceEndPoint().getEndPointIPv4TLV().getIPv4address();
                                this.dest = p2pep.getDestinationEndPoint().getEndPointIPv4TLV().getIPv4address();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.info("Shouldn't be here except in WLANs");
                    }
                }
                boolean requestToParent = false;
                if (!(!this.isChildPCE || ((DomainTEDB)this.ted).belongsToDomain((Object)this.source) && ((DomainTEDB)this.ted).belongsToDomain((Object)this.dest))) {
                    requestToParent = true;
                }
                if (requestToParent) {
                    this.log.info("Child PCE: Request is going to be fowarded to the Parent PCE");
                    PCEPRequest pcreq = new PCEPRequest();
                    Request request = pathCompReq.getRequestList().get(0).duplicate();
                    pcreq.addRequest(request);
                    PCEPResponse p_rep = this.cpcerm.newRequest(pcreq);
                    if (p_rep == null) {
                        this.log.warn("Parent doesn't answer");
                        this.sendNoPath(pathCompReq);
                    } else {
                        this.log.info("RESP: " + p_rep.toString());
                    }
                    ComputingResponse pcepresp = new ComputingResponse();
                    pcepresp.setResponsetList(p_rep.getResponseList());
                    try {
                        this.log.info("Encoding Computing Request");
                        pcepresp.encode();
                    }
                    catch (PCEPProtocolViolationException e1) {
                        this.log.info(UtilsFunctions.exceptionToString((Exception)((Object)e1)));
                    }
                    try {
                        this.log.info("oNE OF THE NODES IS NOT IN THE DOMAIN. Send Request to parent PCE,pcepresp:" + pcepresp + ",pathCompReq.getOut():" + pathCompReq.getOut());
                        pathCompReq.getOut().write(p_rep.getBytes());
                        pathCompReq.getOut().flush();
                    }
                    catch (IOException e) {
                        this.log.warn("Parent doesn't answer");
                        ComputingResponse m_resp = new ComputingResponse();
                        Response response = new Response();
                        RequestParameters rp = new RequestParameters();
                        rp.setRequestID(request.getRequestParameters().requestID);
                        response.setRequestParameters(rp);
                        NoPath noPath = new NoPath();
                        noPath.setNatureOfIssue(0);
                        NoPathTLV noPathTLV = new NoPathTLV();
                        noPath.setNoPathTLV(noPathTLV);
                        response.setNoPath(noPath);
                        m_resp.addResponse(response);
                        try {
                            m_resp.encode();
                            pathCompReq.getOut().write(m_resp.getBytes());
                            pathCompReq.getOut().flush();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        catch (PCEPProtocolViolationException e3) {
                            e3.printStackTrace();
                        }
                        this.log.info("Send NO PATH");
                        System.exit(0);
                    }
                    this.log.info("Response sent!!");
                    this.ft = null;
                } else {
                    int of = 0;
                    ComputingAlgorithmManager algortithmManager = null;
                    ComputingAlgorithmManagerSSON algortithmManagerSSON = null;
                    if (pathCompReq.getSvec() != null) {
                        DefaultSVECPathComputing dspc;
                        this.log.info("SVEC Request ");
                        ObjectiveFunction objectiveFunctionObject = pathCompReq.getSvec().getObjectiveFunction();
                        if (objectiveFunctionObject != null) {
                            of = objectiveFunctionObject.getOFcode();
                            this.log.info("ObjectiveFunction code " + of);
                            algortithmManager = this.svecAlgorithmList.get(new Integer(of));
                            if (algortithmManager == null) {
                                if (objectiveFunctionObject.isPbit()) {
                                    this.log.warn("OF not supported");
                                    PCEPError msg_error = new PCEPError();
                                    ErrorConstruct error_c = new ErrorConstruct();
                                    PCEPErrorObject error = new PCEPErrorObject();
                                    error.setErrorType(4);
                                    error.setErrorValue(4);
                                    error_c.getErrorObjList().add(error);
                                    msg_error.setError(error_c);
                                    try {
                                        msg_error.encode();
                                        pathCompReq.getOut().write(msg_error.getBytes());
                                        pathCompReq.getOut().flush();
                                    }
                                    catch (IOException e) {
                                        this.log.warn("IOException sending error to PCC: " + pathCompReq.getRequestList().get(0).toString());
                                        e.printStackTrace();
                                    }
                                    catch (PCEPProtocolViolationException e) {
                                        this.log.error("Malformed ERROR MESSAGE, CHECK PCE CODE:" + pathCompReq.getRequestList().get(0).toString());
                                        e.printStackTrace();
                                    }
                                    break;
                                }
                                this.log.warn("USING Default SVEC ");
                                dspc = new DefaultSVECPathComputing(pathCompReq, this.ted);
                                this.ft = new ComputingTask(dspc);
                            } else {
                                this.log.info("Custom SVEC OF " + of);
                                ComputingAlgorithm cpr = algortithmManager.getComputingAlgorithm(pathCompReq, this.ted);
                                this.ft = new ComputingTask(cpr);
                            }
                        } else {
                            this.log.info("Default SVEC ");
                            dspc = new DefaultSVECPathComputing(pathCompReq, this.ted);
                            this.ft = new ComputingTask(dspc);
                        }
                    } else {
                        boolean nopath = false;
                        this.log.debug("Non-svec request");
                        double totalTimeNs = System.nanoTime() - pathCompReq.getTimeStampNs();
                        double totalTimeMs = totalTimeNs / 1000000.0;
                        if (this.useMaxReqTime && totalTimeMs > (double)pathCompReq.getMaxTimeInPCE()) {
                            this.log.info("Request execeeded time, sending nopath");
                            this.ft = null;
                            this.log.info("Mando  no path request execeeded time.totalTimeMs " + totalTimeMs + "pathCompReq.getMaxTimeInPCE()");
                            this.sendNoPath(pathCompReq);
                            nopath = true;
                        }
                        if (!nopath) {
                            ObjectiveFunction objectiveFunctionObject = pathCompReq.getRequestList().get(0).getObjectiveFunction();
                            if (objectiveFunctionObject != null) {
                                of = objectiveFunctionObject.getOFcode();
                                this.log.debug("ObjectiveFunction code " + of);
                                algortithmManager = this.singleAlgorithmList.get(new Integer(of));
                                if (this.singleAlgorithmListsson != null) {
                                    algortithmManagerSSON = this.singleAlgorithmListsson.get(new Integer(of));
                                }
                                if (algortithmManager == null && algortithmManagerSSON == null) {
                                    if (objectiveFunctionObject.isPbit()) {
                                        this.log.warn("OF not supported!!");
                                        PCEPError msg_error = new PCEPError();
                                        ErrorConstruct error_c = new ErrorConstruct();
                                        PCEPErrorObject error = new PCEPErrorObject();
                                        error.setErrorType(4);
                                        error.setErrorValue(4);
                                        error_c.getErrorObjList().add(error);
                                        error_c.getRequestIdList().add(pathCompReq.getRequestList().get(0).getRequestParameters());
                                        msg_error.setError(error_c);
                                        try {
                                            msg_error.encode();
                                            pathCompReq.getOut().write(msg_error.getBytes());
                                            pathCompReq.getOut().flush();
                                        }
                                        catch (IOException e) {
                                            this.log.warn("IOException sending error to PCC: nons" + pathCompReq.getRequestList().get(0).toString());
                                            e.printStackTrace();
                                        }
                                        catch (PCEPProtocolViolationException e) {
                                            this.log.error("Malformed ERROR MESSAGE, CHECK PCE CODE. nons" + pathCompReq.getRequestList().get(0).toString());
                                            e.printStackTrace();
                                        }
                                        nopath = true;
                                        this.ft = null;
                                        this.log.warn("error message informing sent." + pathCompReq.getRequestList().get(0).toString());
                                    } else {
                                        this.log.info("Choosing default algotithm 1");
                                        this.log.info("pathCompReq:: " + pathCompReq.toString());
                                        DefaultSinglePathComputing dspc = new DefaultSinglePathComputing(pathCompReq, this.ted);
                                        this.ft = new ComputingTask(dspc);
                                    }
                                } else {
                                    this.log.info("Choosing algorithm of OF " + of);
                                    boolean ssonAlgorithm = false;
                                    if (this.singleAlgorithmListsson != null && this.singleAlgorithmListsson.size() != 0) {
                                        ssonAlgorithm = true;
                                        int mf = 0;
                                        ComputingAlgorithm cpr = algortithmManagerSSON.getComputingAlgorithm(pathCompReq, this.ted, mf);
                                        this.ft = new ComputingTask(cpr);
                                    }
                                    if (!ssonAlgorithm) {
                                        if (this.isMultilayer) {
                                            ComputingAlgorithm cpr = algortithmManager.getComputingAlgorithm(pathCompReq, this.ted, this.opCounter);
                                            this.ft = new ComputingTask(cpr);
                                        } else {
                                            ComputingAlgorithm cpr = algortithmManager.getComputingAlgorithm(pathCompReq, this.ted);
                                            this.ft = new ComputingTask(cpr);
                                        }
                                    }
                                }
                            } else {
                                this.log.info("Choosing default algotithm 2");
                                DefaultSinglePathComputing dspc = new DefaultSinglePathComputing(pathCompReq, this.ted);
                                this.ft = new ComputingTask(dspc);
                            }
                        }
                    }
                }
                if (this.ft != null) {
                    ComputingResponse rep;
                    try {
                        this.ft.run();
                        rep = (ComputingResponse)this.ft.get(pathCompReq.getMaxTimeInPCE(), TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        this.log.warn("Computation failed: " + e.getMessage() + " || " + UtilsFunctions.exceptionToString(e) + "  || " + ",MAXTIME: " + pathCompReq.getMaxTimeInPCE());
                        rep = null;
                    }
                    this.log.info("ReppPP:::" + rep);
                    if (sourceIF != 0L && destIF != 0L) {
                        this.trappingResponse(rep, sourceIF, destIF);
                    }
                    try {
                        if (rep != null) {
                            block72: {
                                ComputingResponse repRes = this.ft.executeReservation();
                                if (repRes != null) {
                                    rep = repRes;
                                }
                                long timeEndNanos = System.nanoTime();
                                double compTimeMicroSec = (double)(timeEndNanos - timeIniNanos) / 1000.0;
                                double toTimeMicroSec = (double)(timeEndNanos - pathCompReq.getTimeStampNs()) / 1000.0;
                                double toTimeMiliSec = (double)(timeEndNanos - pathCompReq.getTimeStampNs()) / 1000000.0;
                                boolean retry = false;
                                if (rep.ResponseList.getFirst().getNoPath() != null && pathCompReq.getRequestList().getFirst().getRequestParameters().isRetry()) {
                                    long maxReqTimeMs;
                                    double totalTimeMs = (System.nanoTime() - pathCompReq.getTimeStampNs()) / 1000000L;
                                    if (pathCompReq.getRequestList().getFirst().getRequestParameters().getMaxRequestTimeTLV() != null && totalTimeMs <= (double)(maxReqTimeMs = pathCompReq.getRequestList().getFirst().getRequestParameters().getMaxRequestTimeTLV().getMaxRequestTime()) && totalTimeMs < 60000.0) {
                                        this.log.info("Re-queueing comp req");
                                        this.pathComputingRequestRetryQueue.add(pathCompReq);
                                        retry = true;
                                    }
                                }
                                if (retry) break block71;
                                if (pathCompReq.getPccReqId() != null) {
                                    rep.getResponse(0).setPccIdreq(pathCompReq.getPccReqId());
                                }
                                if (pathCompReq.getMonitoring() != null) {
                                    this.log.info("Monitoring Info is requested");
                                    MetricPCE metricPCE = new MetricPCE();
                                    PceIdIPv4 pceId = new PceIdIPv4();
                                    Inet4Address pceIPAddress = null;
                                    try {
                                        pceIPAddress = (Inet4Address)Inet4Address.getByName("0.0.0.0");
                                    }
                                    catch (UnknownHostException e) {
                                        e.printStackTrace();
                                    }
                                    pceId.setPceIPAddress(pceIPAddress);
                                    metricPCE.setPceId((PceId)pceId);
                                    ProcTime procTime = new ProcTime();
                                    metricPCE.setProcTime(procTime);
                                    procTime.setCurrentProcessingTime((long)toTimeMiliSec);
                                    rep.getResponse(0).getMetricPCEList().add(metricPCE);
                                }
                                try {
                                    this.log.info(rep.toString());
                                    rep.encode();
                                }
                                catch (PCEPProtocolViolationException e) {
                                    this.log.error("PROBLEM ENCONDING RESPONSE, CHECK CODE!!" + e.getMessage());
                                    break;
                                }
                                try {
                                    this.log.info("Request processeed, about to send response");
                                    pathCompReq.getOut().write(rep.getBytes());
                                    pathCompReq.getOut().flush();
                                }
                                catch (IOException e) {
                                    this.log.warn("Could not send the response " + e.getMessage());
                                    if (rep.getResponse(0).getResConf() == null) break block72;
                                    this.log.warn("If your are using WLANs this is not going to work!!");
                                    this.reservationManager.cancelReservation(rep.getResponse(0).getResConf().getReservationID());
                                }
                            }
                            if (this.collaborationPCESessionManager != null && !rep.getResponseList().isEmpty() && rep.getResponseList().get(0).getNoPath() == null) {
                                PCEPNotification m_not = this.createNotificationMessage(rep, pathCompReq.getRequestList().get(0).getReservation().getTimer());
                                this.collaborationPCESessionManager.sendNotifyMessage((PCEPMessage)m_not);
                            }
                            break block71;
                        }
                        this.log.info("COMPUTING TIME execeeded time, sending NOPATH");
                        this.sendNoPath(pathCompReq);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!this.analyzeRequestTime) continue;
            double comp = (double)(System.nanoTime() - timeIniNanos) / 1000000.0;
            this.procTime.analyze(comp);
            timePreNanos = System.nanoTime();
            if (!(comp > this.maxProcTime)) continue;
            this.maxProcTime = comp;
        }
    }

    public void cancelCurrentComputation() {
        this.ft.cancel(true);
    }

    public Hashtable<Integer, ComputingAlgorithmManager> getSingleAlgorithmList() {
        return this.singleAlgorithmList;
    }

    public Hashtable<Integer, ComputingAlgorithmManager> getSvecAlgorithmList() {
        return this.svecAlgorithmList;
    }

    public Hashtable<Integer, ComputingAlgorithmManagerSSON> getSingleAlgorithmListsson() {
        return this.singleAlgorithmListsson;
    }

    public void setSingleAlgorithmListsson(Hashtable<Integer, ComputingAlgorithmManagerSSON> singleAlgorithmListsson) {
        this.singleAlgorithmListsson = singleAlgorithmListsson;
    }

    public Hashtable<Integer, ComputingAlgorithmManagerSSON> getSvecAlgorithmListsson() {
        return this.svecAlgorithmListsson;
    }

    public void setSvecAlgorithmListsson(Hashtable<Integer, ComputingAlgorithmManagerSSON> svecAlgorithmListsson) {
        this.svecAlgorithmListsson = svecAlgorithmListsson;
    }

    public Analysis getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(Analysis idleTime) {
        this.idleTime = idleTime;
    }

    public Analysis getProcTime() {
        return this.procTime;
    }

    public void setProcTime(Analysis procTime) {
        this.procTime = procTime;
    }

    private void trappingResponse(ComputingResponse resp, long sourceIF, long destIF) {
        this.log.info("First ERO SubObject type " + ((EROSubobject)resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().getFirst()).getClass());
        this.log.info("Second ERO SubObject type " + ((EROSubobject)resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().get(1)).getClass());
        this.log.info("Last ERO SubObject type " + ((EROSubobject)resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().getLast()).getClass());
        Inet4Address firstIP = ((UnnumberIfIDEROSubobject)resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().getFirst()).getRouterID();
        EROSubobject label = (EROSubobject)resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().get(1);
        resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().add(0, label);
        UnnumberIfIDEROSubobject firsteroso = new UnnumberIfIDEROSubobject();
        firsteroso.setRouterID(firstIP);
        firsteroso.setInterfaceID(sourceIF);
        firsteroso.setLoosehop(false);
        resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().add(0, firsteroso);
        int size = resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().size();
        Inet4Address lastIP = ((IPv4prefixEROSubobject)resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().getLast()).getIpv4address();
        resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().removeLast();
        UnnumberIfIDEROSubobject lasteroso = new UnnumberIfIDEROSubobject();
        lasteroso.setRouterID(lastIP);
        lasteroso.setInterfaceID(destIF);
        lasteroso.setLoosehop(false);
        resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().add(lasteroso);
        resp.getResponseList().get(0).getPath(0).geteRO().getEROSubobjectList().add(label);
    }

    private void sendNoPath(ComputingRequest pathCompReq) {
        this.log.info("SENDInd no path ID" + pathCompReq.getRequestList().getFirst().getRequestParameters().requestID);
        ComputingResponse m_resp = new ComputingResponse();
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(pathCompReq.getRequestList().getFirst().getRequestParameters().requestID);
        response.setRequestParameters(rp);
        NoPath noPath = new NoPath();
        noPath.setNatureOfIssue(0);
        NoPathTLV noPathTLV = new NoPathTLV();
        noPath.setNoPathTLV(noPathTLV);
        noPathTLV.setPCEunavailable(true);
        response.setNoPath(noPath);
        m_resp.addResponse(response);
        try {
            m_resp.encode();
            pathCompReq.getOut().write(m_resp.getBytes());
            pathCompReq.getOut().flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (PCEPProtocolViolationException e3) {
            e3.printStackTrace();
        }
        this.log.error("No path sent... should we send");
    }

    public double getMaxProcTime() {
        return this.maxProcTime;
    }

    public PCEPNotification createNotificationMessage(ComputingResponse resp, long timer) {
        this.log.info("Timer " + timer);
        PCEPNotification notificationMsg = new PCEPNotification();
        Notify notify = new Notify();
        Notification notif = new Notification();
        notif.setNotificationType(121);
        LinkedList<Notification> notificationList = new LinkedList<Notification>();
        PathReservationTLV pathReservationTLV = new PathReservationTLV();
        pathReservationTLV.setERO(((Path)resp.getResponseList().getFirst().getPathList().getFirst()).geteRO());
        boolean bidirect = resp.getResponseList().getFirst().getRequestParameters().isBidirect();
        pathReservationTLV.setTime(timer);
        pathReservationTLV.setBidirectional(bidirect);
        notif.setNotificationTLV(pathReservationTLV);
        notificationList.add(notif);
        notify.setNotificationList(notificationList);
        notificationMsg.addNotify(notify);
        return notificationMsg;
    }
}

