/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine;

import es.tid.pce.computingEngine.InitiationRequest;
import es.tid.pce.parentPCE.ParentPCESession;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.EndPointsUnnumberedIntf;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcep.objects.tlvs.EndPointIPv4TLV;
import es.tid.pce.pcep.objects.tlvs.SymbolicPathNameTLV;
import es.tid.pce.pcep.objects.tlvs.UnnumberedEndpointTLV;
import es.tid.pce.server.IniPCCManager;
import es.tid.pce.server.SD_LSP;
import es.tid.pce.server.SaveLSPinRedisSingleDom;
import es.tid.pce.server.lspdb.SingleDomainLSPDB;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import java.net.Inet4Address;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDomainIniProcessorThread
extends Thread {
    private static int lspIdSeq = 1;
    private SingleDomainLSPDB singleDomainLSPDB;
    private LinkedBlockingQueue<InitiationRequest> lspInitiationRequestQueue;
    private IniPCCManager iniManager;
    private boolean running;
    SaveLSPinRedisSingleDom savelsp;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public LinkedBlockingQueue<InitiationRequest> getLspInitiationRequestQueue() {
        return this.lspInitiationRequestQueue;
    }

    public void setLspInitiationRequestQueue(LinkedBlockingQueue<InitiationRequest> lspInitiationRequestQueue) {
        this.lspInitiationRequestQueue = lspInitiationRequestQueue;
    }

    public SingleDomainIniProcessorThread(LinkedBlockingQueue<InitiationRequest> lspInitiationRequestQueue, SingleDomainLSPDB singleDomainLSPDB, IniPCCManager iniManager) {
        this.lspInitiationRequestQueue = lspInitiationRequestQueue;
        this.singleDomainLSPDB = singleDomainLSPDB;
        this.iniManager = iniManager;
        if (singleDomainLSPDB.isExportDb()) {
            this.savelsp = new SaveLSPinRedisSingleDom();
            this.savelsp.configure(singleDomainLSPDB, "127.0.0.1", 6379);
            this.running = true;
        }
    }

    @Override
    public void run() {
        ExplicitRouteObject fullEro = null;
        while (this.running) {
            this.log.info("Waiting for a new Initiation Request");
            try {
                InitiationRequest iniReq = this.lspInitiationRequestQueue.take();
                PCEPIntiatedLSP pini = iniReq.getLspIniRequest();
                PCEPIntiatedLSP piniToNode = new PCEPIntiatedLSP();
                SRP srp = new SRP();
                long sRP_ID_number_to_node = ParentPCESession.getNewReqIDCounter();
                srp.setSRP_ID_number(sRP_ID_number_to_node);
                piniToNode.setRsp(srp);
                srp.setRFlag(pini.getRsp().isrFlag());
                long sRP_ID_number = pini.getRsp().getSRP_ID_number();
                if (pini.getRsp().isrFlag()) {
                    this.delete(pini.getLsp().getLspId(), sRP_ID_number, iniReq);
                    continue;
                }
                boolean needComputation = false;
                if (pini.getEro() != null) {
                    needComputation = false;
                    this.log.info("Provision Simple LSP  with ERO");
                } else {
                    needComputation = true;
                    this.log.info("Provision Simple LSP that needs computation");
                }
                if (needComputation) {
                    fullEro = null;
                } else {
                    fullEro = pini.getEro();
                    this.log.info("XXXX fullEro=pini.getEro();" + fullEro);
                }
                piniToNode.setEro(fullEro);
                LSP lsp = new LSP();
                lsp.setSymbolicPathNameTLV_tlv(pini.getLsp().getSymbolicPathNameTLV_tlv());
                piniToNode.setLsp(lsp);
                LinkedList iniList = new LinkedList();
                Bandwidth bw = null;
                if (pini.getBandwidth() != null) {
                    bw = pini.getBandwidth().duplicate();
                }
                piniToNode.setBandwidth(bw);
                piniToNode.setEndPoint(pini.getEndPoint());
                PCEPInitiate pcepInitiate = new PCEPInitiate();
                pcepInitiate.getPcepIntiatedLSPList().add(piniToNode);
                this.log.info("INITIATE with info, sending to node");
                String miIP = this.getSourceIP(pini.getEndPoint());
                this.log.info("ver ip to socket connect: " + miIP);
                Inet4Address ip = (Inet4Address)Inet4Address.getByName(miIP);
                StateReport sr = this.iniManager.newIni(pcepInitiate, ip);
                if (sr == null) continue;
                int lspId = sr.getLSP().getLspId();
                StateReport srmd = new StateReport();
                SRP srpp = new SRP();
                srpp.setSRP_ID_number(sRP_ID_number);
                srmd.setSRP(srpp);
                LSP lspp = new LSP();
                lspp.setLspId(lspId);
                srmd.setLSP(lspp);
                Path p = new Path();
                p.setEro(fullEro);
                srmd.setPath(p);
                SymbolicPathNameTLV symbolicPathNameTLV_tlv = new SymbolicPathNameTLV();
                if (sr.getLSP().getSymbolicPathNameTLV_tlv() != null) {
                    symbolicPathNameTLV_tlv.setSymbolicPathNameID(sr.getLSP().getSymbolicPathNameTLV_tlv().getSymbolicPathNameID());
                    lspp.setSymbolicPathNameTLV_tlv(symbolicPathNameTLV_tlv);
                } else {
                    this.log.warn("NO SYMBOLIC PATH NAME TLV!!!");
                }
                PCEPReport rep = new PCEPReport();
                rep.getStateReportList().add(srmd);
                rep.encode();
                this.log.info("Send: " + rep.toString());
                iniReq.getOut().write(rep.getBytes());
                iniReq.getOut().flush();
                SD_LSP sd_lsp = new SD_LSP();
                sd_lsp.setpLSPID(lspId);
                sd_lsp.setFullERO(fullEro);
                sd_lsp.setStateRport(sr);
                sd_lsp.setEndpoints(pini.getEndPoint());
                this.singleDomainLSPDB.getSingleDomain_LSP_list().put(lspId, sd_lsp);
                if (!this.singleDomainLSPDB.isExportDb()) continue;
                this.savelsp.run();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error("PROBLEM SENDING THE INITIATES");
            }
        }
    }

    public String getSourceIP(Object endPoint) {
        String sourceIP = null;
        if (endPoint == null) {
            this.log.info(" endPoint es null");
        } else if (endPoint instanceof EndPointsIPv4) {
            this.log.info(" endPoint es de tipo EndPointsIPv4");
            sourceIP = ((EndPointsIPv4)endPoint).getSourceIP().toString();
        } else if (endPoint instanceof EndPointsUnnumberedIntf) {
            this.log.info("endPoint es de tipo EndPointsUnnumberedIntf");
            sourceIP = ((EndPointsUnnumberedIntf)endPoint).getSourceIP().toString();
        } else if (endPoint instanceof GeneralizedEndPoints) {
            this.log.info(" endPoint es de tipo GeneralizedEndPoints");
            EndPoint sourceEndPoint = ((GeneralizedEndPoints)endPoint).getP2PEndpoints().getSourceEndPoint();
            if (sourceEndPoint.getEndPointIPv4TLV() != null) {
                sourceIP = sourceEndPoint.getEndPointIPv4TLV().getIPv4address().getHostAddress();
            } else if (sourceEndPoint.getUnnumberedEndpoint() != null) {
                sourceIP = sourceEndPoint.getUnnumberedEndpoint().getIPv4address().getHostAddress();
            }
        } else {
            this.log.info(" endPoint NO es de tipo conocido");
        }
        return sourceIP;
    }

    public EndPoints getEndPoints(ExplicitRouteObject ero) {
        this.log.info("Getting EndPoints");
        Iterator eroi = ero.getEROSubobjectList().iterator();
        GeneralizedEndPoints gep = new GeneralizedEndPoints();
        P2PEndpoints p2pEndpoints = new P2PEndpoints();
        EndPoint sourceEndPoint = null;
        EndPoint destinationEndPoint = null;
        gep.setP2PEndpoints(p2pEndpoints);
        while (eroi.hasNext()) {
            EndPointIPv4TLV epipv4;
            EROSubobject eroso = (EROSubobject)eroi.next();
            if (eroso instanceof IPv4prefixEROSubobject) {
                if (sourceEndPoint == null) {
                    sourceEndPoint = new EndPoint();
                    epipv4 = new EndPointIPv4TLV();
                    epipv4.setIPv4address(((IPv4prefixEROSubobject)eroso).getIpv4address());
                    sourceEndPoint.setEndPointIPv4TLV(epipv4);
                    continue;
                }
                if (eroi.hasNext()) continue;
                destinationEndPoint = new EndPoint();
                epipv4 = new EndPointIPv4TLV();
                epipv4.setIPv4address(((IPv4prefixEROSubobject)eroso).getIpv4address());
                destinationEndPoint.setEndPointIPv4TLV(epipv4);
                continue;
            }
            if (!(eroso instanceof UnnumberIfIDEROSubobject)) continue;
            if (sourceEndPoint == null) {
                sourceEndPoint = new EndPoint();
                epipv4 = new UnnumberedEndpointTLV();
                epipv4.setIPv4address(((UnnumberIfIDEROSubobject)eroso).getRouterID());
                epipv4.setIfID(((UnnumberIfIDEROSubobject)eroso).getInterfaceID());
                sourceEndPoint.setUnnumberedEndpoint((UnnumberedEndpointTLV)epipv4);
                destinationEndPoint = new EndPoint();
                UnnumberedEndpointTLV epipv42 = new UnnumberedEndpointTLV();
                epipv42.setIPv4address(((UnnumberIfIDEROSubobject)eroso).getRouterID());
                epipv42.setIfID(((UnnumberIfIDEROSubobject)eroso).getInterfaceID());
                destinationEndPoint.setUnnumberedEndpoint(epipv42);
                continue;
            }
            destinationEndPoint = new EndPoint();
            epipv4 = new UnnumberedEndpointTLV();
            epipv4.setIPv4address(((UnnumberIfIDEROSubobject)eroso).getRouterID());
            epipv4.setIfID(((UnnumberIfIDEROSubobject)eroso).getInterfaceID());
            destinationEndPoint.setUnnumberedEndpoint((UnnumberedEndpointTLV)epipv4);
        }
        p2pEndpoints.setSourceEndpoint(sourceEndPoint);
        p2pEndpoints.setDestinationEndPoints(destinationEndPoint);
        return gep;
    }

    public void delete(int lspID, long sRP_ID_number, InitiationRequest iniReq) {
        this.log.info("GOING TO DELTE " + lspID);
        SD_LSP sdlsp = this.singleDomainLSPDB.getSingleDomain_LSP_list().get(lspID);
        if (sdlsp == null) {
            this.log.error("LSP is NULL!!");
        }
        LinkedList<PCEPInitiate> iniList = new LinkedList<PCEPInitiate>();
        if (sdlsp != null) {
            this.log.info("LSP OK in DB!!!");
            PCEPInitiate ini = new PCEPInitiate();
            PCEPIntiatedLSP inilsp = new PCEPIntiatedLSP();
            ini.getPcepIntiatedLSPList().add(inilsp);
            SRP srp = new SRP();
            srp.setSRP_ID_number((long)ParentPCESession.getNewReqIDCounter());
            inilsp.setRsp(srp);
            srp.setRFlag(true);
            LSP lsp = new LSP();
            SymbolicPathNameTLV symbolicPathNameTLV_tlv = new SymbolicPathNameTLV();
            StateReport SR = sdlsp.getStateRport();
            symbolicPathNameTLV_tlv.setSymbolicPathNameID(SR.getLSP().getSymbolicPathNameTLV_tlv().getSymbolicPathNameID());
            lsp.setLspId(sdlsp.getpLSPID());
            lsp.setSymbolicPathNameTLV_tlv(symbolicPathNameTLV_tlv);
            inilsp.setLsp(lsp);
            iniList.add(ini);
            try {
                String miIP = this.getSourceIP(sdlsp.getEndpoints());
                this.log.info("ver ip to socket connect: " + miIP);
                ExplicitRouteObject ero = new ExplicitRouteObject();
                ero.addEROSubobjectList(sdlsp.getFullERO().getEROSubobjectList());
                Path path = new Path();
                path.setEro(ero);
                Inet4Address ip = (Inet4Address)Inet4Address.getByName(miIP);
                this.log.info("GOING TO send the deletes of " + lspID);
                StateReport sr = this.iniManager.newIni(ini, ip);
                this.log.info("Removing SD LSP " + lspID);
                this.singleDomainLSPDB.getSingleDomain_LSP_list().remove(lspID);
                this.log.info(" XXXX State Report");
                StateReport srmd = new StateReport();
                SRP srpp = new SRP();
                srpp.setSRP_ID_number(sRP_ID_number);
                srpp.setRFlag(true);
                srmd.setSRP(srpp);
                LSP lspp = new LSP();
                lspp.setLspId(lspID);
                srmd.setLSP(lspp);
                srmd.setPath(path);
                symbolicPathNameTLV_tlv = new SymbolicPathNameTLV();
                if (sr.getLSP().getSymbolicPathNameTLV_tlv() != null) {
                    symbolicPathNameTLV_tlv.setSymbolicPathNameID(sr.getLSP().getSymbolicPathNameTLV_tlv().getSymbolicPathNameID());
                    lspp.setSymbolicPathNameTLV_tlv(symbolicPathNameTLV_tlv);
                } else {
                    this.log.warn("NO SYMBOLIC PATH NAME TLV!!!");
                }
                PCEPReport rep = new PCEPReport();
                rep.getStateReportList().add(srmd);
                rep.encode();
                this.log.info("Send Report to parent: " + rep.toString());
                iniReq.getOut().write(rep.getBytes());
                iniReq.getOut().flush();
            }
            catch (Exception e) {
                this.log.error("PROBLEM SENDING THE DELETES");
            }
        }
    }

    public static synchronized int getID() {
        return ++lspIdSeq;
    }
}

