/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.MDTEDB;
import es.tid.tedb.SimpleITTEDB;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSinglePathComputingSSON
implements ComputingAlgorithm {
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private TEDB ted;

    public DefaultSinglePathComputingSSON(ComputingRequest pathReq, TEDB ted) {
        this.ted = ted;
        try {
            if (ted.getClass().equals(SimpleTEDB.class)) {
                this.networkGraph = ((SimpleTEDB)ted).getDuplicatedNetworkGraph();
            } else if (ted.getClass().equals(MDTEDB.class)) {
                this.networkGraph = null;
            } else if (ted.getClass().equals(SimpleITTEDB.class)) {
                this.networkGraph = ((SimpleITTEDB)ted).getDuplicatedNetworkGraph();
            }
            this.pathReq = pathReq;
        }
        catch (Exception e) {
            this.pathReq = pathReq;
            this.networkGraph = null;
        }
    }

    @Override
    public ComputingResponse call() {
        UnnumberIfIDEROSubobject eroso;
        long tiempoini = System.nanoTime();
        ComputingResponse m_resp = new ComputingResponse();
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Processing Single Path Computing Request id: " + reqId);
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        if (this.networkGraph == null) {
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            m_resp.addResponse(response);
            return m_resp;
        }
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() == 2) {
            // empty if block
        }
        if (EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        this.log.info("Source: " + source_router_id_addr);
        this.log.info("Destination: " + dest_router_id_addr);
        this.log.debug("Check if we have source and destination in our TED");
        ((SimpleTEDB)this.ted).printTopology();
        if (!this.networkGraph.containsVertex((Object)source_router_id_addr) || !this.networkGraph.containsVertex((Object)dest_router_id_addr)) {
            this.log.warn("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.networkGraph.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.networkGraph.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            m_resp.addResponse(response);
            return m_resp;
        }
        this.log.debug("Computing path");
        DijkstraShortestPath dsp = new DijkstraShortestPath(this.networkGraph, (Object)source_router_id_addr, (Object)dest_router_id_addr);
        GraphPath gp = dsp.getPath();
        this.log.debug("Creating response");
        if (gp == null) {
            this.log.warn("No Path Found");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            response.setNoPath(noPath);
            m_resp.addResponse(response);
            return m_resp;
        }
        m_resp.addResponse(response);
        Path path = new Path();
        ExplicitRouteObject ero = new ExplicitRouteObject();
        List edge_list = gp.getEdgeList();
        for (int i = 0; i < edge_list.size(); ++i) {
            eroso = new UnnumberIfIDEROSubobject();
            eroso.setRouterID((Inet4Address)((IntraDomainEdge)edge_list.get(i)).getSource());
            eroso.setInterfaceID(((IntraDomainEdge)edge_list.get(i)).getSrc_if_id());
            eroso.setLoosehop(false);
            ero.addEROSubobject((EROSubobject)eroso);
        }
        eroso = new IPv4prefixEROSubobject();
        eroso.setIpv4address((Inet4Address)((IntraDomainEdge)edge_list.get(edge_list.size() - 1)).getTarget());
        eroso.setPrefix(32);
        ero.addEROSubobject((EROSubobject)eroso);
        path.setEro(ero);
        if (req.getMetricList().size() != 0) {
            Metric metric = new Metric();
            metric.setMetricType(((Metric)req.getMetricList().get(0)).getMetricType());
            this.log.debug("Number of hops " + edge_list.size());
            float metricValue = edge_list.size();
            metric.setMetricValue(metricValue);
            path.getMetricList().add(metric);
        }
        response.addPath(path);
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        Monitoring monitoring = this.pathReq.getMonitoring();
        if (monitoring == null || monitoring.isProcessingTimeBit()) {
            // empty if block
        }
        return m_resp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return null;
    }
}

