/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms;

import es.tid.pce.computingEngine.algorithms.GraphEndPoint;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;

public class GraphEndPoints {
    private GraphEndPoint source = new GraphEndPoint();
    private GraphEndPoint destination = new GraphEndPoint();

    public GraphEndPoints(EndPoints EP) {
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)EP;
            this.source.setVertex(ep.getSourceIP());
            this.destination.setVertex(ep.getDestIP());
        } else if (EP.getOT() == 2) {
            // empty if block
        }
        if (EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)EP;
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                this.source.setVertex(sourceep.getEndPointDataPathTLV().switchID);
                this.destination.setVertex(destep.getEndPointDataPathTLV().switchID);
            } else if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                this.source.setVertex(sourceep.getEndPointIPv4TLV().IPv4address);
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    this.source.setVertex(sourceep.getEndPointIPv4TLV().IPv4address);
                    this.destination.setVertex(destep.getEndPointIPv4TLV().IPv4address);
                }
            }
        }
    }

    public GraphEndPoint getSource() {
        return this.source;
    }

    public void setSource(GraphEndPoint source) {
        this.source = source;
    }

    public GraphEndPoint getDestination() {
        return this.destination;
    }

    public void setDestination(GraphEndPoint destination) {
        this.destination = destination;
    }
}

