/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms;

import es.tid.pce.pcep.objects.ExcludeRouteObject;
import es.tid.pce.pcep.objects.subobjects.UnnumberIfIDXROSubobject;
import es.tid.pce.pcep.objects.subobjects.XROSubobject;
import es.tid.tedb.IntraDomainEdge;
import java.net.Inet4Address;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFunctions {
    public static void processXRO(ExcludeRouteObject xro, SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graphLambda) {
        Logger log = LoggerFactory.getLogger((String)"PCEServer");
        try {
            if (xro != null) {
                log.info("XRO: Thre are " + xro.getXROSubobjectList().size() + " exclusions");
                for (int i = 0; i < xro.getXROSubobjectList().size(); ++i) {
                    XROSubobject eroso = (XROSubobject)xro.getXROSubobjectList().get(i);
                    if (eroso.getType() != 4) continue;
                    UnnumberIfIDXROSubobject eros = (UnnumberIfIDXROSubobject)eroso;
                    log.info("XRO: UNNUMBERED_IF_ID TO EXCLUDE: " + eros.getRouterID() + ":" + eros.getInterfaceID());
                    Inet4Address source_node_ip = eros.getRouterID();
                    log.info("XRO: IT BELONGS TO NODE " + source_node_ip);
                    boolean hasVertex = graphLambda.containsVertex((Object)source_node_ip);
                    log.info("XRO: EL GRAPH TIENE VERTEX " + hasVertex);
                    if (!hasVertex) continue;
                    log.info("%% 1: graphLambda:: " + graphLambda.toString());
                    graphLambda.removeVertex((Object)source_node_ip);
                    log.info("%% 2: graphLambda:: " + graphLambda.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

