/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmManagerSSON;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.tedb.TEDB;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalChildRequestManager {
    private Hashtable<Inet4Address, DataOutputStream> domainIdOutputStream;
    private Hashtable<Inet4Address, Inet4Address> domainIdpceId;
    public Hashtable<Long, Object> locks = new Hashtable();
    private Hashtable<Long, ComputingResponse> responses = new Hashtable();
    private ThreadPoolExecutor executor;
    private LinkedBlockingQueue<Runnable> workQueue;
    private Logger log;
    private Logger logGUI;

    public LocalChildRequestManager() {
        this.domainIdOutputStream = new Hashtable();
        this.domainIdpceId = new Hashtable();
        int corePoolSize = 5;
        int maximumPoolSize = 10;
        long keepAliveTime = 120L;
        this.workQueue = new LinkedBlockingQueue();
        this.executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, this.workQueue);
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.logGUI = LoggerFactory.getLogger((String)"GUILogger");
    }

    public LinkedList<ComputingResponse> executeRequests(LinkedList<PCEPRequest> requestList, LinkedList<Inet4Address> domainList, ComputingAlgorithmManagerSSON cam_sson, TEDB ted) {
        LinkedList<ComputingResponse> response = new LinkedList<ComputingResponse>();
        int mf = 0;
        LinkedList<FutureTask<ComputingResponse>> ftList = new LinkedList<FutureTask<ComputingResponse>>();
        for (int i = 0; i < requestList.size(); ++i) {
            ComputingRequest compRquest = new ComputingRequest();
            LinkedList<Request> requestList2 = new LinkedList<Request>();
            compRquest.setRequestList(requestList2);
            compRquest.getRequestList().add((Request)requestList.get(i).getRequestList().get(0));
            ComputingAlgorithm cpr = cam_sson.getComputingAlgorithm(compRquest, ted, mf);
            FutureTask<ComputingResponse> ft = new FutureTask<ComputingResponse>(cpr);
            ftList.add(ft);
            this.executor.execute(ft);
        }
        long time = 120000L;
        System.out.println("The time is " + time + " miliseconds");
        long timeIni = System.currentTimeMillis();
        for (int i = 0; i < requestList.size(); ++i) {
            long time2;
            ComputingResponse resp;
            try {
                System.out.println("Waiting " + time + " miliseconds for domain " + domainList.get(i));
                resp = (ComputingResponse)((FutureTask)ftList.get(i)).get(time, TimeUnit.MILLISECONDS);
                System.out.println("Response: " + resp.getResponse(0).toString());
                time2 = System.currentTimeMillis();
                long timePassed = time2 - timeIni;
                time = timePassed >= 120000L ? 0L : (time -= timePassed);
                response.add(resp);
                continue;
            }
            catch (TimeoutException e) {
                resp = null;
                time2 = System.currentTimeMillis();
                time = time - time2 - timeIni;
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return response;
    }
}

