/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms;

import es.tid.of.DataPathID;
import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExcludeRouteObject;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.Metric;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcep.objects.subobjects.UnnumberIfIDXROSubobject;
import es.tid.pce.pcep.objects.subobjects.XROSubobject;
import es.tid.pce.pcep.objects.tlvs.EndPointIPv4TLV;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberedDataPathIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.ITMDTEDB;
import es.tid.tedb.InterDomainEdge;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.MDTEDB;
import es.tid.tedb.ReachabilityManager;
import es.tid.tedb.SimpleTEDB;
import es.tid.tedb.TEDB;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDHPCEDelayAlgorithm
implements ComputingAlgorithm {
    private DirectedWeightedMultigraph<Object, InterDomainEdge> Graph;
    Hashtable<Inet4Address, DomainTEDB> intraTEDBs = null;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private ChildPCERequestManager childPCERequestManager;
    private ReachabilityManager reachabilityManager;
    FileWriter fstream = null;
    BufferedWriter bw = null;
    private boolean acceptIntraReq = true;

    public MDHPCEDelayAlgorithm(ComputingRequest pathReq, TEDB ted, ChildPCERequestManager cprm, ReachabilityManager rm) {
        this.Graph = ted.isITtedb() ? ((ITMDTEDB)ted).getDuplicatedMDNetworkGraph() : ((MDTEDB)ted).getDuplicatedMDNetworkGraph();
        this.reachabilityManager = rm;
        this.pathReq = pathReq;
        this.childPCERequestManager = cprm;
    }

    public MDHPCEDelayAlgorithm(ComputingRequest pathReq, TEDB ted, ChildPCERequestManager cprm, ReachabilityManager rm, Hashtable<Inet4Address, DomainTEDB> intra) {
        this.Graph = ted.isITtedb() ? ((ITMDTEDB)ted).getDuplicatedMDNetworkGraph() : ((MDTEDB)ted).getDuplicatedMDNetworkGraph();
        this.intraTEDBs = intra;
        this.reachabilityManager = rm;
        this.pathReq = pathReq;
        this.childPCERequestManager = cprm;
    }

    @Override
    public ComputingResponse call() throws Exception {
        long tiempoini = System.nanoTime();
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setReachabilityManager(this.reachabilityManager);
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() == 2) {
            // empty if block
        }
        if (EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        Inet4Address source_domain_id = this.reachabilityManager.getDomain(source_router_id_addr);
        Inet4Address dest_domain_id = this.reachabilityManager.getDomain(dest_router_id_addr);
        this.log.info("Check if SRC and Dest domains are OK");
        if (dest_domain_id == null || source_domain_id == null) {
            this.log.warn("One of the domains is not reachable, sending NOPATH");
            this.log.info("Source domain = " + source_domain_id);
            this.log.info("Dest domain = " + dest_domain_id);
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            response.setNoPath(noPath);
            m_resp.addResponse(response);
            return m_resp;
        }
        LinkedList reqList = new LinkedList();
        LinkedList<PCEPInitiate> initList = new LinkedList<PCEPInitiate>();
        LinkedList<Inet4Address> domainList = new LinkedList<Inet4Address>();
        if (source_domain_id.equals(dest_domain_id)) {
            UnnumberIfIDEROSubobject eroso;
            if (!this.acceptIntraReq) {
                this.log.warn("Not MD path: the two end points are in the same domain (" + source_domain_id + ")");
                NoPath noPath2 = new NoPath();
                noPath2.setNatureOfIssue(0);
                NoPathTLV noPathTLV = new NoPathTLV();
                noPath2.setNoPathTLV(noPathTLV);
                response.setNoPath(noPath2);
                m_resp.addResponse(response);
                return m_resp;
            }
            this.log.info("Not MD path (src and dst in the same domain): just for test purpose computation of the shortest delay path in domain (" + source_domain_id + ")");
            SimpleDirectedWeightedGraph srcgraph = null;
            SimpleTEDB ssTED = (SimpleTEDB)this.intraTEDBs.get(source_domain_id);
            srcgraph = ssTED.getDuplicatedNetworkGraph();
            for (IntraDomainEdge saa : srcgraph.edgeSet()) {
                srcgraph.setEdgeWeight((Object)saa, (double)saa.TE_info.getUndirLinkDelay().getDelay());
            }
            this.log.info("Computing path in src domain");
            DijkstraShortestPath sdsp = new DijkstraShortestPath((Graph)srcgraph, (Object)source_router_id_addr, (Object)dest_router_id_addr);
            GraphPath sgp1 = sdsp.getPath();
            if (sgp1 == null) {
                this.log.warn("No path between src and dst");
                NoPath noPath2 = new NoPath();
                noPath2.setNatureOfIssue(0);
                NoPathTLV noPathTLV = new NoPathTLV();
                noPath2.setNoPathTLV(noPathTLV);
                response.setNoPath(noPath2);
                m_resp.addResponse(response);
                return m_resp;
            }
            Path spath1 = new Path();
            ExplicitRouteObject serosrc = new ExplicitRouteObject();
            List slinks = sgp1.getEdgeList();
            for (int si = 0; si < slinks.size(); ++si) {
                if (((IntraDomainEdge)slinks.get(si)).getSource() instanceof Inet4Address) {
                    eroso = new UnnumberIfIDEROSubobject();
                    eroso.setRouterID((Inet4Address)((IntraDomainEdge)slinks.get(si)).getSource());
                    eroso.setLoosehop(false);
                    serosrc.addEROSubobject((EROSubobject)eroso);
                    continue;
                }
                if (((IntraDomainEdge)slinks.get(si)).getSource() instanceof DataPathID) {
                    eroso = new UnnumberedDataPathIDEROSubobject();
                    eroso.setDataPath((DataPathID)((IntraDomainEdge)slinks.get(si)).getSource());
                    eroso.setLoosehop(false);
                    serosrc.addEROSubobject((EROSubobject)eroso);
                    continue;
                }
                this.log.info("Edge instance error");
            }
            if (slinks.size() > 0) {
                if (((IntraDomainEdge)slinks.get(slinks.size() - 1)).getTarget() instanceof Inet4Address) {
                    eroso = new UnnumberIfIDEROSubobject();
                    eroso.setRouterID((Inet4Address)((IntraDomainEdge)slinks.get(slinks.size() - 1)).getTarget());
                    eroso.setLoosehop(false);
                    serosrc.addEROSubobject((EROSubobject)eroso);
                } else if (((IntraDomainEdge)slinks.get(slinks.size() - 1)).getTarget() instanceof DataPathID) {
                    eroso = new UnnumberedDataPathIDEROSubobject();
                    eroso.setDataPath((DataPathID)((IntraDomainEdge)slinks.get(slinks.size() - 1)).getTarget());
                    eroso.setLoosehop(false);
                    serosrc.addEROSubobject((EROSubobject)eroso);
                }
            } else {
                eroso = new UnnumberIfIDEROSubobject();
                eroso.setRouterID(source_router_id_addr);
                eroso.setLoosehop(false);
                serosrc.addEROSubobject((EROSubobject)eroso);
            }
            if (req.getMetricList().size() != 0) {
                Metric metric = new Metric();
                metric.setMetricType(((Metric)req.getMetricList().get(0)).getMetricType());
                this.log.debug("Number of hops " + slinks.size());
                float metricValue = slinks.size();
                metric.setMetricValue(metricValue);
                spath1.getMetricList().add(metric);
            }
            int delay = (int)sgp1.getWeight();
            this.log.info("The end to end delay in  " + source_domain_id + " is " + delay);
            PCEPInitiate sp_init_Src = new PCEPInitiate();
            PCEPIntiatedLSP slsp_inis = new PCEPIntiatedLSP();
            sp_init_Src.getPcepIntiatedLSPList().add(slsp_inis);
            this.log.info("Sending init");
            EndPointsIPv4 seps = new EndPointsIPv4();
            seps.setSourceIP(source_router_id_addr);
            seps.setDestIP(dest_router_id_addr);
            slsp_inis.setEndPoint((EndPoints)seps);
            SRP ssrps = new SRP();
            ssrps.setRFlag(false);
            slsp_inis.setRsp(ssrps);
            LSP slsps = new LSP();
            slsp_inis.setLsp(slsps);
            ssrps.setSRP_ID_number(1L);
            slsp_inis.setEro(serosrc);
            initList.add(sp_init_Src);
            domainList.add(source_domain_id);
            StateReport inireply = null;
            int skk = 0;
            if (skk < initList.size()) {
                try {
                    if (domainList.get(skk) != this.reachabilityManager.getDomain((Inet4Address)InetAddress.getByName("10.4.1.1"))) {
                        inireply = this.childPCERequestManager.newIni((PCEPInitiate)initList.get(skk), domainList.get(skk));
                    } else {
                        this.log.info("TID domain");
                        inireply = new StateReport();
                    }
                }
                catch (Exception e) {
                    this.log.error("PROBLEM SENDING THE INIT");
                    NoPath noPathx = new NoPath();
                    noPathx.setNatureOfIssue(0);
                    NoPathTLV snoPathTLV = new NoPathTLV();
                    noPathx.setNoPathTLV(snoPathTLV);
                    response.setNoPath(noPathx);
                    m_resp.addResponse(response);
                    return m_resp;
                }
                if (inireply == null) {
                    this.log.warn("Child for init " + (skk + 1) + " has failed");
                    NoPath snoPath = new NoPath();
                    response.setNoPath(snoPath);
                    m_resp.addResponse(response);
                    return m_resp;
                }
                this.log.info("Domain " + domainList.get(skk) + " replied to Initiate: " + inireply.toString());
                spath1.setEro(serosrc);
                response.addPath(spath1);
                m_resp.addResponse(response);
                return m_resp;
            }
        }
        this.log.info("MD Request from " + source_router_id_addr + " (domain " + source_domain_id + ") to " + dest_router_id_addr + " (domain " + dest_domain_id + ")");
        DirectedWeightedMultigraph networkGraph = null;
        networkGraph = (DirectedWeightedMultigraph)this.Graph.clone();
        for (InterDomainEdge edge : networkGraph.edgeSet()) {
            networkGraph.setEdgeWeight((Object)edge, (double)edge.TE_info.getUndirLinkDelay().getDelay());
        }
        if (!networkGraph.containsVertex((Object)source_domain_id) || !networkGraph.containsVertex((Object)dest_domain_id)) {
            Iterator it = networkGraph.vertexSet().iterator();
            this.log.warn("Source or destination domains are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!networkGraph.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source domain");
                noPathTLV.setUnknownSource(true);
            }
            if (!networkGraph.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination domain");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            m_resp.addResponse(response);
            return m_resp;
        }
        this.log.info("Computing MD Sequence of domains");
        KShortestPaths dsp = new KShortestPaths((Graph)networkGraph, (Object)source_domain_id, 4);
        List gps = dsp.getPaths((Object)dest_domain_id);
        if (gps == null) {
            this.log.error("Problem getting the domain sequence");
            NoPath noPath2 = new NoPath();
            noPath2.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath2.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath2);
            m_resp.addResponse(response);
            return m_resp;
        }
        this.log.info("Found " + gps.size() + " paths");
        boolean pathfound = false;
        int k = 0;
        int best_delay = 0;
        GraphPath gp = null;
        Path path = new Path();
        ExplicitRouteObject final_srcero = new ExplicitRouteObject();
        ExplicitRouteObject final_dstero = new ExplicitRouteObject();
        ExplicitRouteObject final_ero = new ExplicitRouteObject();
        Inet4Address dstdom_srcaddr = null;
        Inet4Address srcdom_dstaddr = null;
        while (k <= gps.size() - 1) {
            UnnumberIfIDEROSubobject eroso;
            UnnumberIfIDEROSubobject eroso2;
            int current_delay = 0;
            path = new Path();
            reqList = new LinkedList();
            initList = new LinkedList();
            gp = (GraphPath)gps.get(k);
            ++k;
            List edge_list = gp.getEdgeList();
            long tiempo2 = System.nanoTime();
            Inet4Address destIP = null;
            EndPointsIPv4 endpointsRequest = null;
            if (EP.getOT() == 1) {
                endpointsRequest = new EndPointsIPv4();
                endpointsRequest.setSourceIP(source_router_id_addr);
                destIP = (Inet4Address)((InterDomainEdge)edge_list.get(0)).getSrc_router_id();
                endpointsRequest.setDestIP(destIP);
            } else if (EP.getOT() == 2) {
                // empty if block
            }
            if (EP.getOT() == 5) {
                GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
                if (gep.getGeneralizedEndPointsType() == 0) {
                    EndPointIPv4TLV sourceIPv4TLV = new EndPointIPv4TLV();
                    EndPointIPv4TLV destIPv4TLV = new EndPointIPv4TLV();
                    sourceIPv4TLV.setIPv4address(source_router_id_addr);
                    destIP = (Inet4Address)((InterDomainEdge)edge_list.get(0)).getSrc_router_id();
                    destIPv4TLV.setIPv4address(destIP);
                    EndPoint sourceEP = new EndPoint();
                    EndPoint destEP = new EndPoint();
                    sourceEP.setEndPointIPv4TLV(sourceIPv4TLV);
                    destEP.setEndPointIPv4TLV(destIPv4TLV);
                    P2PEndpoints p2pep = new P2PEndpoints();
                    p2pep.setSourceEndpoint(sourceEP);
                    p2pep.setDestinationEndPoints(destEP);
                    endpointsRequest = new GeneralizedEndPoints();
                    ((GeneralizedEndPoints)endpointsRequest).setP2PEndpoints(p2pep);
                }
                if (gep.getGeneralizedEndPointsType() == 1) {
                    // empty if block
                }
            }
            Inet4Address domain = source_domain_id;
            boolean first_domain_equal = false;
            if (source_router_id_addr.equals(destIP)) {
                this.log.info("Origin and destination are the same");
                first_domain_equal = true;
            }
            SimpleDirectedWeightedGraph domaingraph = null;
            SimpleTEDB sTED = (SimpleTEDB)this.intraTEDBs.get(source_domain_id);
            domaingraph = sTED.getDuplicatedNetworkGraph();
            for (IntraDomainEdge aa : domaingraph.edgeSet()) {
                domaingraph.setEdgeWeight((Object)aa, (double)aa.TE_info.getUndirLinkDelay().getDelay());
            }
            this.log.info("Computing path in src domain");
            DijkstraShortestPath dsp1 = new DijkstraShortestPath((Graph)domaingraph, (Object)source_router_id_addr, (Object)destIP);
            GraphPath gp1 = dsp1.getPath();
            if (gp1 == null) {
                this.log.warn("No path between src and end-point");
                continue;
            }
            Path path1 = new Path();
            ExplicitRouteObject erosrc = new ExplicitRouteObject();
            ExplicitRouteObject totero = new ExplicitRouteObject();
            List links = gp1.getEdgeList();
            for (int i = 0; i < links.size(); ++i) {
                if (((IntraDomainEdge)links.get(i)).getSource() instanceof Inet4Address) {
                    eroso2 = new UnnumberIfIDEROSubobject();
                    eroso2.setRouterID((Inet4Address)((IntraDomainEdge)links.get(i)).getSource());
                    eroso2.setLoosehop(false);
                    erosrc.addEROSubobject((EROSubobject)eroso2);
                    totero.addEROSubobject((EROSubobject)eroso2);
                    continue;
                }
                if (((IntraDomainEdge)links.get(i)).getSource() instanceof DataPathID) {
                    eroso2 = new UnnumberedDataPathIDEROSubobject();
                    eroso2.setDataPath((DataPathID)((IntraDomainEdge)links.get(i)).getSource());
                    eroso2.setLoosehop(false);
                    erosrc.addEROSubobject((EROSubobject)eroso2);
                    totero.addEROSubobject((EROSubobject)eroso2);
                    continue;
                }
                this.log.info("Edge instance error");
            }
            if (links.size() > 0) {
                if (((IntraDomainEdge)links.get(links.size() - 1)).getTarget() instanceof Inet4Address) {
                    eroso2 = new UnnumberIfIDEROSubobject();
                    eroso2.setRouterID((Inet4Address)((IntraDomainEdge)links.get(links.size() - 1)).getTarget());
                    eroso2.setLoosehop(false);
                    erosrc.addEROSubobject((EROSubobject)eroso2);
                    totero.addEROSubobject((EROSubobject)eroso2);
                } else if (((IntraDomainEdge)links.get(links.size() - 1)).getTarget() instanceof DataPathID) {
                    eroso2 = new UnnumberedDataPathIDEROSubobject();
                    eroso2.setDataPath((DataPathID)((IntraDomainEdge)links.get(links.size() - 1)).getTarget());
                    eroso2.setLoosehop(false);
                    erosrc.addEROSubobject((EROSubobject)eroso2);
                    totero.addEROSubobject((EROSubobject)eroso2);
                }
            } else {
                this.log.info("no links on the path");
                eroso2 = new UnnumberIfIDEROSubobject();
                eroso2.setRouterID(source_router_id_addr);
                eroso2.setLoosehop(false);
                erosrc.addEROSubobject((EROSubobject)eroso2);
                totero.addEROSubobject((EROSubobject)eroso2);
            }
            this.log.info("Path " + k + " src ero: " + erosrc.toString());
            if (req.getMetricList().size() != 0) {
                Metric metric = new Metric();
                metric.setMetricType(((Metric)req.getMetricList().get(0)).getMetricType());
                this.log.debug("Number of hops " + links.size());
                float metricValue = links.size();
                metric.setMetricValue(metricValue);
                path1.getMetricList().add(metric);
            }
            current_delay = (int)gp1.getWeight();
            this.log.info("Path " + k + ": delay src domain " + gp1.getWeight());
            if (best_delay != 0 && (current_delay += ((InterDomainEdge)edge_list.get(0)).getTE_info().getUndirLinkDelay().getDelay()) > best_delay) {
                this.log.info("Delay of path " + k + " is greater than best delay. Go to next interdomain path!");
                continue;
            }
            Inet4Address srcIP = null;
            srcIP = (Inet4Address)((InterDomainEdge)edge_list.get(edge_list.size() - 1)).getDst_router_id();
            domain = dest_domain_id;
            this.log.info("Second part of the LSP is in domain: " + domain + " from " + srcIP + " to " + dest_router_id_addr);
            SimpleDirectedWeightedGraph domaingraphdest = null;
            SimpleTEDB dTED = (SimpleTEDB)this.intraTEDBs.get(dest_domain_id);
            domaingraphdest = dTED.getDuplicatedNetworkGraph();
            for (IntraDomainEdge bb : domaingraphdest.edgeSet()) {
                domaingraphdest.setEdgeWeight((Object)bb, (double)bb.TE_info.getUndirLinkDelay().getDelay());
            }
            this.log.info("Computing path in dest domain");
            DijkstraShortestPath dsp2 = new DijkstraShortestPath((Graph)domaingraphdest, (Object)srcIP, (Object)dest_router_id_addr);
            GraphPath gp2 = dsp2.getPath();
            if (gp2 == null) {
                this.log.warn("No path between end-point and dest");
                continue;
            }
            pathfound = true;
            ExplicitRouteObject erodest = new ExplicitRouteObject();
            List links2 = gp2.getEdgeList();
            for (int j = 0; j < links2.size(); ++j) {
                if (((IntraDomainEdge)links2.get(j)).getSource() instanceof Inet4Address) {
                    eroso = new UnnumberIfIDEROSubobject();
                    eroso.setRouterID((Inet4Address)((IntraDomainEdge)links2.get(j)).getSource());
                    eroso.setLoosehop(false);
                    erodest.addEROSubobject((EROSubobject)eroso);
                    totero.addEROSubobject((EROSubobject)eroso);
                    continue;
                }
                if (((IntraDomainEdge)links2.get(j)).getSource() instanceof DataPathID) {
                    eroso = new UnnumberedDataPathIDEROSubobject();
                    eroso.setDataPath((DataPathID)((IntraDomainEdge)links2.get(j)).getSource());
                    eroso.setLoosehop(false);
                    erodest.addEROSubobject((EROSubobject)eroso);
                    totero.addEROSubobject((EROSubobject)eroso);
                    continue;
                }
                this.log.info("Edge instance error");
            }
            if (links2.size() > 0) {
                if (((IntraDomainEdge)links2.get(links2.size() - 1)).getTarget() instanceof Inet4Address) {
                    eroso = new UnnumberIfIDEROSubobject();
                    eroso.setRouterID((Inet4Address)((IntraDomainEdge)links2.get(links2.size() - 1)).getTarget());
                    eroso.setLoosehop(false);
                    erodest.addEROSubobject((EROSubobject)eroso);
                    totero.addEROSubobject((EROSubobject)eroso);
                } else if (((IntraDomainEdge)links2.get(links2.size() - 1)).getTarget() instanceof DataPathID) {
                    eroso = new UnnumberedDataPathIDEROSubobject();
                    eroso.setDataPath((DataPathID)((IntraDomainEdge)links2.get(links2.size() - 1)).getTarget());
                    eroso.setLoosehop(false);
                    erodest.addEROSubobject((EROSubobject)eroso);
                    totero.addEROSubobject((EROSubobject)eroso);
                }
            } else {
                this.log.info("no links on the path");
                eroso = new UnnumberIfIDEROSubobject();
                eroso.setRouterID(dest_router_id_addr);
                eroso.setLoosehop(false);
                erodest.addEROSubobject((EROSubobject)eroso);
                totero.addEROSubobject((EROSubobject)eroso);
            }
            this.log.info("Path " + k + " dst ero: " + erodest.toString());
            if (req.getMetricList().size() != 0) {
                Metric metric = new Metric();
                metric.setMetricType(((Metric)req.getMetricList().get(0)).getMetricType());
                this.log.debug("Number of hops " + links2.size());
                float metricValue = links2.size();
                metric.setMetricValue(metricValue);
                path.getMetricList().add(metric);
            }
            if (best_delay != 0 && best_delay <= (current_delay += (int)gp2.getWeight())) continue;
            srcdom_dstaddr = destIP;
            dstdom_srcaddr = srcIP;
            best_delay = current_delay;
            final_ero = totero;
            final_dstero = erodest;
            final_srcero = erosrc;
            this.log.info("Path " + k + ": delay " + current_delay);
        }
        this.log.info("Final delay " + best_delay);
        if (!pathfound) {
            this.log.warn("No paths between src and dest");
            NoPath noPath = new NoPath();
            response.setNoPath(noPath);
            m_resp.addResponse(response);
        } else {
            this.log.info("Sending inits");
            long tiempofin = System.nanoTime();
            long tiempotot = tiempofin - tiempoini;
            this.log.info("Algo time " + tiempotot + " nsec");
            PCEPInitiate p_init_Src = new PCEPInitiate();
            PCEPIntiatedLSP lsp_inis = new PCEPIntiatedLSP();
            p_init_Src.getPcepIntiatedLSPList().add(lsp_inis);
            EndPointsIPv4 eps = new EndPointsIPv4();
            eps.setSourceIP(source_router_id_addr);
            eps.setDestIP(srcdom_dstaddr);
            lsp_inis.setEndPoint((EndPoints)eps);
            SRP srps = new SRP();
            srps.setRFlag(false);
            lsp_inis.setRsp(srps);
            LSP lsps = new LSP();
            lsp_inis.setLsp(lsps);
            srps.setSRP_ID_number(1L);
            lsp_inis.setEro(final_srcero);
            initList.add(p_init_Src);
            domainList.add(source_domain_id);
            PCEPInitiate p_init_Dst = new PCEPInitiate();
            PCEPIntiatedLSP lsp_inid = new PCEPIntiatedLSP();
            p_init_Dst.getPcepIntiatedLSPList().add(lsp_inid);
            EndPointsIPv4 epd = new EndPointsIPv4();
            epd.setSourceIP(dstdom_srcaddr);
            epd.setDestIP(dest_router_id_addr);
            lsp_inid.setEndPoint((EndPoints)epd);
            SRP srpd = new SRP();
            srpd.setRFlag(false);
            lsp_inid.setRsp(srpd);
            LSP lspd = new LSP();
            lsp_inid.setLsp(lspd);
            srpd.setSRP_ID_number(1L);
            lsp_inid.setEro(final_dstero);
            initList.add(p_init_Dst);
            domainList.add(dest_domain_id);
            boolean childrenFailed = false;
            StateReport inireply2 = null;
            for (int lkk = 0; lkk < initList.size(); ++lkk) {
                try {
                    inireply2 = domainList.get(lkk) != this.reachabilityManager.getDomain((Inet4Address)InetAddress.getByName("10.4.1.1")) ? this.childPCERequestManager.newIni((PCEPInitiate)initList.get(lkk), domainList.get(lkk)) : new StateReport();
                }
                catch (Exception e) {
                    this.log.error("PROBLEM SENDING THE INIT");
                    NoPath noPathx = new NoPath();
                    noPathx.setNatureOfIssue(0);
                    NoPathTLV snoPathTLV = new NoPathTLV();
                    noPathx.setNoPathTLV(snoPathTLV);
                    response.setNoPath(noPathx);
                    m_resp.addResponse(response);
                    return m_resp;
                }
                if (inireply2 == null) {
                    childrenFailed = true;
                    this.log.warn("Child for init " + (lkk + 1) + " has failed");
                    continue;
                }
                this.log.info("Domain " + domainList.get(lkk) + " replied to Initiate: " + inireply2.toString());
            }
            if (childrenFailed) {
                this.log.warn("Some child has failed");
                NoPath noPath = new NoPath();
                response.setNoPath(noPath);
                m_resp.addResponse(response);
            } else {
                path.setEro(final_ero);
                response.addPath(path);
                m_resp.addResponse(response);
            }
        }
        Monitoring monitoring = this.pathReq.getMonitoring();
        return m_resp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return null;
    }

    public void addXRO(ExcludeRouteObject xro, Request req) {
        req.setXro(xro);
    }

    public void processXRO(ExcludeRouteObject xro, DirectedWeightedMultigraph<Inet4Address, InterDomainEdge> networkGraph) {
        if (xro != null) {
            for (int i = 0; i < xro.getXROSubobjectList().size(); ++i) {
                UnnumberIfIDXROSubobject eros;
                boolean hasVertex;
                XROSubobject eroso = (XROSubobject)xro.getXROSubobjectList().get(i);
                if (eroso.getType() != 4 || !(hasVertex = networkGraph.containsVertex((Object)(eros = (UnnumberIfIDXROSubobject)eroso).getRouterID()))) continue;
                Set setEdges = networkGraph.edgesOf((Object)eros.getRouterID());
                for (InterDomainEdge edge : setEdges) {
                    if (edge.getSrc_if_id() != eros.getInterfaceID()) continue;
                    networkGraph.removeEdge((Object)edge);
                }
            }
        }
    }
}

