/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.multidomain.MDFunctions;
import es.tid.pce.parentPCE.ChildPCERequestManager;
import es.tid.pce.parentPCE.ParentPCESession;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.GeneralizedBandwidthSSON;
import es.tid.pce.pcep.constructs.NCF;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequestedGeneralizedBandwidth;
import es.tid.pce.pcep.objects.BitmapLabelSet;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExcludeRouteObject;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.Monitoring;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.ObjectiveFunction;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.subobjects.UnnumberIfIDXROSubobject;
import es.tid.pce.pcep.objects.subobjects.XROSubobject;
import es.tid.pce.pcep.objects.tlvs.EndPointIPv4TLV;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.pcep.objects.tlvs.UnnumberedEndpointTLV;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.ITMDTEDB;
import es.tid.tedb.InterDomainEdge;
import es.tid.tedb.MDTEDB;
import es.tid.tedb.ReachabilityManager;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDHPCEMinNumberDomainsAlgorithm
implements ComputingAlgorithm {
    private DirectedWeightedMultigraph<Object, InterDomainEdge> networkGraph;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private ComputingRequest pathReq;
    private ChildPCERequestManager childPCERequestManager;
    private ReachabilityManager reachabilityManager;
    public static int GENERIC_CHANNEL = 0;
    public static int MEDIA_CHANNEL = 1;
    public static int OF_CODE_MUTIDOMAIN_MEDIA_CHANNEL = 60000;
    public static int OF_CODE_MUTIDOMAIN_SBVT_CHANNEL = 60001;
    public static int OF_CODE_MEDIA_CHANNEL = 58000;
    public static int SBVT_CHANNEL = 2;
    public static int OF_CODE_SBVT_CHANNEL = 58020;
    public int channelType;
    public long reqId;
    boolean explicit_label = false;
    EndPoints original_end_points;

    public MDHPCEMinNumberDomainsAlgorithm(ComputingRequest pathReq, TEDB ted, ChildPCERequestManager cprm, ReachabilityManager rm) {
        this.networkGraph = ted.isITtedb() ? ((ITMDTEDB)ted).getDuplicatedMDNetworkGraph() : ((MDTEDB)ted).getDuplicatedMDNetworkGraph();
        this.reachabilityManager = rm;
        this.pathReq = pathReq;
        this.childPCERequestManager = cprm;
    }

    @Override
    public ComputingResponse call() throws Exception {
        NoPath noPath;
        LinkedList<ComputingResponse> respList;
        long tiempoini = System.nanoTime();
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setReachabilityManager(this.reachabilityManager);
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        int m = 0;
        Request req = this.pathReq.getRequestList().get(0);
        this.reqId = req.getRequestParameters().getRequestID();
        this.log.info("Processing MD Path Computing with MDHPCEMinNumberDomainsAlgorithm (Minimum transit Domains) with Request id: " + this.reqId);
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setRequestID(this.reqId);
        response.setRequestParameters(rp);
        this.original_end_points = req.getEndPoints();
        Inet4Address source_router_id_addr = this.getSourceRouter(this.original_end_points);
        long src_if_id = this.getSourceIfID(this.original_end_points);
        Inet4Address dest_router_id_addr = this.getDestRouter(this.original_end_points);
        long dst_if_id = this.getDestIfID(this.original_end_points);
        Inet4Address source_domain_id = this.reachabilityManager.getDomain(source_router_id_addr);
        Inet4Address dest_domain_id = this.reachabilityManager.getDomain(dest_router_id_addr);
        this.log.info("MD Request from " + source_router_id_addr + " (domain " + source_domain_id + ") to " + dest_router_id_addr + " (domain " + dest_domain_id + ")");
        this.log.debug("Check if SRC and Dest domains are OK");
        if (dest_domain_id == null || source_domain_id == null) {
            this.log.warn("One of the domains is not reachable, sending NOPATH");
            NoPath noPath2 = new NoPath();
            noPath2.setNatureOfIssue(0);
            response.setNoPath(noPath2);
            m_resp.addResponse(response);
            return m_resp;
        }
        if (!this.networkGraph.containsVertex((Object)source_domain_id) || !this.networkGraph.containsVertex((Object)dest_domain_id)) {
            Iterator it = this.networkGraph.vertexSet().iterator();
            while (it.hasNext()) {
                this.log.info(it.next().toString());
            }
            this.log.warn("Source or destination domains are NOT in the TED");
            NoPath noPath3 = new NoPath();
            noPath3.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.networkGraph.containsVertex((Object)source_router_id_addr)) {
                this.log.debug("Unknown source domain");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.networkGraph.containsVertex((Object)dest_router_id_addr)) {
                this.log.debug("Unknown destination domain");
                noPathTLV.setUnknownDestination(true);
            }
            noPath3.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath3);
            m_resp.addResponse(response);
            return m_resp;
        }
        int of = -1;
        if (req.getObjectiveFunction() != null) {
            of = req.getObjectiveFunction().getOFcode();
            if (of == OF_CODE_MUTIDOMAIN_MEDIA_CHANNEL) {
                this.channelType = MEDIA_CHANNEL;
                this.log.info("We are dealing with a MEDIA CHANNEL");
            } else if (of == OF_CODE_MUTIDOMAIN_SBVT_CHANNEL) {
                this.channelType = SBVT_CHANNEL;
                this.log.info("We are dealing with a SBVT CHANNEL");
            } else {
                this.channelType = GENERIC_CHANNEL;
                this.log.info("We are dealing with a GENERIC CHANNEL");
            }
        } else {
            this.channelType = GENERIC_CHANNEL;
            this.log.info("We are dealing with a GENERIC CHANNEL AS NO OF WAS RECEIVED");
        }
        if (this.channelType == MEDIA_CHANNEL) {
            this.pruneSVBTs(this.networkGraph);
        }
        this.log.info("Processing XRO");
        MDFunctions.processXRO(req.getXro(), this.reachabilityManager, this.networkGraph);
        this.log.info("Computing MD Sequence of domains");
        DijkstraShortestPath dsp = new DijkstraShortestPath(this.networkGraph, (Object)source_domain_id, (Object)dest_domain_id);
        LinkedList<PCEPRequest> reqList = new LinkedList<PCEPRequest>();
        LinkedList<Object> domainList = new LinkedList<Object>();
        GraphPath gp = dsp.getPath();
        if (gp == null) {
            this.log.error("Problem getting the domain sequence");
            NoPath noPath2 = new NoPath();
            noPath2.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath2.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath2);
            m_resp.addResponse(response);
            return m_resp;
        }
        List edge_list = gp.getEdgeList();
        boolean first_domain_equal = false;
        if (source_domain_id.equals(dest_domain_id)) {
            PCEPRequest pcreqToDomain = this.createRequest(this.channelType, req.getXro(), this.pathReq.getRequestList().get(0).getBandwidth().duplicate(), this.pathReq.getRequestList().get(0).getEndPoints());
            reqList.add(pcreqToDomain);
            domainList.add(source_domain_id);
            this.log.info("Sending ONLY ONE request: " + pcreqToDomain.toString() + " to domain " + source_domain_id);
        } else {
            ObjectiveFunction objectiveFunction;
            int i = 0;
            Inet4Address destIP = null;
            EndPointsIPv4 endpointsRequest = null;
            if (this.original_end_points.getOT() == 1) {
                endpointsRequest = new EndPointsIPv4();
                endpointsRequest.setSourceIP(source_router_id_addr);
                destIP = (Inet4Address)((InterDomainEdge)edge_list.get(0)).getSrc_router_id();
                endpointsRequest.setDestIP(destIP);
            } else if (this.original_end_points.getOT() == 2) {
                // empty if block
            }
            if (this.original_end_points.getOT() == 5) {
                GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
                EndPoint sourceEP = new EndPoint();
                EndPoint destEP = new EndPoint();
                if (gep.getGeneralizedEndPointsType() == 0) {
                    EndPointIPv4TLV destIPv4TLV;
                    EndPointIPv4TLV sourceIPv4TLV;
                    if (gep.getP2PEndpoints().getSourceEndPoint().getEndPointIPv4TLV() != null) {
                        source_router_id_addr = gep.getP2PEndpoints().getSourceEndPoint().getEndPointIPv4TLV().getIPv4address();
                        sourceIPv4TLV = new EndPointIPv4TLV();
                        destIPv4TLV = new EndPointIPv4TLV();
                        sourceIPv4TLV.setIPv4address(source_router_id_addr);
                        destIP = (Inet4Address)((InterDomainEdge)edge_list.get(0)).getSrc_router_id();
                        destIPv4TLV.setIPv4address(destIP);
                        sourceEP.setEndPointIPv4TLV(sourceIPv4TLV);
                        destEP.setEndPointIPv4TLV(destIPv4TLV);
                    } else if (gep.getP2PEndpoints().getSourceEndPoint().getUnnumberedEndpoint() != null) {
                        source_router_id_addr = gep.getP2PEndpoints().getSourceEndPoint().getUnnumberedEndpoint().getIPv4address();
                        sourceIPv4TLV = new UnnumberedEndpointTLV();
                        destIPv4TLV = new UnnumberedEndpointTLV();
                        sourceIPv4TLV.setIPv4address(source_router_id_addr);
                        destIP = (Inet4Address)((InterDomainEdge)edge_list.get(0)).getSrc_router_id();
                        sourceIPv4TLV.setIfID(gep.getP2PEndpoints().getSourceEndPoint().getUnnumberedEndpoint().getIfID());
                        destIPv4TLV.setIPv4address(destIP);
                        destIPv4TLV.setIfID(((InterDomainEdge)edge_list.get(0)).getSrc_if_id());
                        sourceEP.setUnnumberedEndpoint((UnnumberedEndpointTLV)sourceIPv4TLV);
                        destEP.setUnnumberedEndpoint((UnnumberedEndpointTLV)destIPv4TLV);
                    }
                    P2PEndpoints p2pep = new P2PEndpoints();
                    p2pep.setSourceEndpoint(sourceEP);
                    p2pep.setDestinationEndPoints(destEP);
                    endpointsRequest = new GeneralizedEndPoints();
                    ((GeneralizedEndPoints)endpointsRequest).setP2PEndpoints(p2pep);
                }
            }
            Inet4Address domain = (Inet4Address)((InterDomainEdge)edge_list.get(0)).getSource();
            this.log.info("First part of the LSP is in domain: " + domain + " from " + source_router_id_addr + " to " + destIP);
            if (source_router_id_addr.equals(destIP)) {
                this.log.info("Origin and destination are the same");
                first_domain_equal = true;
            } else {
                ObjectiveFunction objectiveFunction2;
                PCEPRequest pcreqToFirstDomain = new PCEPRequest();
                if (this.pathReq.getMonitoring() != null) {
                    pcreqToFirstDomain.setMonitoring(this.pathReq.getMonitoring());
                }
                if (this.pathReq.getPccReqId() != null) {
                    pcreqToFirstDomain.setPccReqId(this.pathReq.getPccReqId());
                }
                Request requestToFirstDomain = new Request();
                this.log.info("Llega BW " + this.pathReq.getRequestList().get(0).getBandwidth().toString());
                Request req1 = this.pathReq.getRequestList().get(0);
                BandwidthRequestedGeneralizedBandwidth bw = null;
                if (req1.getBandwidth() instanceof BandwidthRequestedGeneralizedBandwidth && (bw = (BandwidthRequestedGeneralizedBandwidth)req1.getBandwidth()).getGeneralizedBandwidth() != null && bw.getGeneralizedBandwidth() instanceof GeneralizedBandwidthSSON) {
                    GeneralizedBandwidthSSON a = (GeneralizedBandwidthSSON)bw.getGeneralizedBandwidth();
                    m = a.getM();
                }
                requestToFirstDomain.setBandwidth(this.pathReq.getRequestList().get(0).getBandwidth().duplicate());
                if (this.pathReq.getRequestList().get(0).getReservation() != null) {
                    requestToFirstDomain.setReservation(this.pathReq.getRequestList().get(0).getReservation());
                }
                this.addXRO(req.getXro(), requestToFirstDomain);
                requestToFirstDomain.setEndPoints((EndPoints)endpointsRequest);
                RequestParameters rpFirstDomain = new RequestParameters();
                long requestID = ParentPCESession.getNewReqIDCounter();
                rpFirstDomain.setRequestID(requestID);
                rpFirstDomain.setPbit(true);
                requestToFirstDomain.setRequestParameters(rpFirstDomain);
                if (this.channelType == MEDIA_CHANNEL) {
                    objectiveFunction2 = new ObjectiveFunction();
                    objectiveFunction2.setOFcode(OF_CODE_MEDIA_CHANNEL);
                    requestToFirstDomain.setObjectiveFunction(objectiveFunction2);
                } else if (this.channelType == SBVT_CHANNEL) {
                    objectiveFunction2 = new ObjectiveFunction();
                    objectiveFunction2.setOFcode(OF_CODE_SBVT_CHANNEL);
                    requestToFirstDomain.setObjectiveFunction(objectiveFunction2);
                }
                pcreqToFirstDomain.addRequest(requestToFirstDomain);
                reqList.add(pcreqToFirstDomain);
                domainList.add(domain);
                this.log.info("Sending 1st request" + requestToFirstDomain.toString() + " to domain " + domain);
            }
            for (i = 1; i < edge_list.size(); ++i) {
                ObjectiveFunction objectiveFunction3;
                domain = (Inet4Address)((InterDomainEdge)edge_list.get(i)).getSource();
                if (this.original_end_points.getOT() == 1) {
                    endpointsRequest = new EndPointsIPv4();
                    endpointsRequest.setSourceIP((Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id());
                    endpointsRequest.setDestIP((Inet4Address)((InterDomainEdge)edge_list.get(i)).getSrc_router_id());
                } else if (this.original_end_points.getOT() == 2) {
                    // empty if block
                }
                if (this.original_end_points.getOT() == 5) {
                    GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
                    if (gep.getGeneralizedEndPointsType() == 0) {
                        EndPointIPv4TLV destIPv4TLV;
                        EndPointIPv4TLV sourceIPv4TLV;
                        EndPoint sourceEP = new EndPoint();
                        EndPoint destEP = new EndPoint();
                        if (gep.getP2PEndpoints().getSourceEndPoint().getEndPointIPv4TLV() != null) {
                            sourceIPv4TLV = new EndPointIPv4TLV();
                            destIPv4TLV = new EndPointIPv4TLV();
                            sourceIPv4TLV.setIPv4address((Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id());
                            destIP = (Inet4Address)((InterDomainEdge)edge_list.get(i)).getSrc_router_id();
                            destIPv4TLV.setIPv4address(destIP);
                            sourceEP.setEndPointIPv4TLV(sourceIPv4TLV);
                            destEP.setEndPointIPv4TLV(destIPv4TLV);
                        } else if (gep.getP2PEndpoints().getSourceEndPoint().getUnnumberedEndpoint() != null) {
                            sourceIPv4TLV = new UnnumberedEndpointTLV();
                            destIPv4TLV = new UnnumberedEndpointTLV();
                            sourceIPv4TLV.setIPv4address((Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id());
                            destIP = (Inet4Address)((InterDomainEdge)edge_list.get(i)).getSrc_router_id();
                            sourceIPv4TLV.setIfID(((InterDomainEdge)edge_list.get(i - 1)).getDst_if_id());
                            destIPv4TLV.setIPv4address(destIP);
                            destIPv4TLV.setIfID(((InterDomainEdge)edge_list.get(i)).getSrc_if_id());
                            sourceEP.setUnnumberedEndpoint((UnnumberedEndpointTLV)sourceIPv4TLV);
                            destEP.setUnnumberedEndpoint((UnnumberedEndpointTLV)destIPv4TLV);
                        }
                        P2PEndpoints p2pep = new P2PEndpoints();
                        p2pep.setSourceEndpoint(sourceEP);
                        p2pep.setDestinationEndPoints(destEP);
                        endpointsRequest = new GeneralizedEndPoints();
                        ((GeneralizedEndPoints)endpointsRequest).setP2PEndpoints(p2pep);
                    }
                    if (gep.getGeneralizedEndPointsType() == 1) {
                        // empty if block
                    }
                }
                this.log.info("New part of the LSP is in domain: " + domain + " from " + ((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id() + " to " + ((InterDomainEdge)edge_list.get(i)).getSrc_router_id());
                PCEPRequest pcreq = new PCEPRequest();
                if (this.pathReq.getMonitoring() != null) {
                    pcreq.setMonitoring(this.pathReq.getMonitoring());
                }
                if (this.pathReq.getPccReqId() != null) {
                    pcreq.setPccReqId(this.pathReq.getPccReqId());
                }
                Request request = new Request();
                request.setBandwidth(this.pathReq.getRequestList().get(0).getBandwidth());
                if (this.pathReq.getRequestList().get(0).getReservation() != null) {
                    request.setReservation(this.pathReq.getRequestList().get(0).getReservation());
                }
                this.addXRO(req.getXro(), request);
                request.setEndPoints((EndPoints)endpointsRequest);
                RequestParameters rp2 = new RequestParameters();
                long requestID = ParentPCESession.getNewReqIDCounter();
                rp2.setRequestID(requestID);
                rp2.setPbit(true);
                request.setRequestParameters(rp2);
                if (this.channelType == MEDIA_CHANNEL) {
                    objectiveFunction3 = new ObjectiveFunction();
                    objectiveFunction3.setOFcode(OF_CODE_MEDIA_CHANNEL);
                    request.setObjectiveFunction(objectiveFunction3);
                } else if (this.channelType == SBVT_CHANNEL) {
                    objectiveFunction3 = new ObjectiveFunction();
                    objectiveFunction3.setOFcode(OF_CODE_SBVT_CHANNEL);
                    request.setObjectiveFunction(objectiveFunction3);
                }
                pcreq.addRequest(request);
                reqList.add(pcreq);
                domainList.add(domain);
                this.log.info("Sending request " + i + " to domain " + domain);
            }
            EndPointsIPv4 endpointsLastDomain = null;
            Inet4Address Last_domain = (Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getTarget();
            Inet4Address last_source_IP = (Inet4Address)((InterDomainEdge)edge_list.get(i - 1)).getDst_router_id();
            this.log.info("Last part of the LSP is in domain: " + Last_domain + " from " + last_source_IP + " to " + dest_router_id_addr);
            if (this.original_end_points.getOT() == 1) {
                endpointsLastDomain = new EndPointsIPv4();
                endpointsLastDomain.setDestIP(dest_router_id_addr);
                endpointsLastDomain.setSourceIP(last_source_IP);
            } else if (this.original_end_points.getOT() == 2) {
                // empty if block
            }
            if (this.original_end_points.getOT() == 5) {
                GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
                if (gep.getGeneralizedEndPointsType() == 0) {
                    EndPointIPv4TLV destIPv4TLV;
                    EndPointIPv4TLV sourceIPv4TLV;
                    EndPoint sourceEP = new EndPoint();
                    EndPoint destEP = new EndPoint();
                    if (gep.getP2PEndpoints().getSourceEndPoint().getEndPointIPv4TLV() != null) {
                        sourceIPv4TLV = new EndPointIPv4TLV();
                        destIPv4TLV = new EndPointIPv4TLV();
                        sourceIPv4TLV.setIPv4address(last_source_IP);
                        destIPv4TLV.setIPv4address(dest_router_id_addr);
                        sourceEP.setEndPointIPv4TLV(sourceIPv4TLV);
                        destEP.setEndPointIPv4TLV(destIPv4TLV);
                    } else if (gep.getP2PEndpoints().getSourceEndPoint().getUnnumberedEndpoint() != null) {
                        sourceIPv4TLV = new UnnumberedEndpointTLV();
                        destIPv4TLV = new UnnumberedEndpointTLV();
                        sourceIPv4TLV.setIPv4address(last_source_IP);
                        sourceIPv4TLV.setIfID(((InterDomainEdge)edge_list.get(i - 1)).getDst_if_id());
                        destIPv4TLV.setIPv4address(dest_router_id_addr);
                        destIPv4TLV.setIfID(dst_if_id);
                        sourceEP.setUnnumberedEndpoint((UnnumberedEndpointTLV)sourceIPv4TLV);
                        destEP.setUnnumberedEndpoint((UnnumberedEndpointTLV)destIPv4TLV);
                    }
                    P2PEndpoints p2pep = new P2PEndpoints();
                    p2pep.setSourceEndpoint(sourceEP);
                    p2pep.setDestinationEndPoints(destEP);
                    endpointsLastDomain = new GeneralizedEndPoints();
                    ((GeneralizedEndPoints)endpointsLastDomain).setP2PEndpoints(p2pep);
                }
                if (gep.getGeneralizedEndPointsType() == 1) {
                    // empty if block
                }
            }
            PCEPRequest pcreqToLastDomain = new PCEPRequest();
            if (this.pathReq.getMonitoring() != null) {
                pcreqToLastDomain.setMonitoring(this.pathReq.getMonitoring());
            }
            if (this.pathReq.getPccReqId() != null) {
                pcreqToLastDomain.setPccReqId(this.pathReq.getPccReqId());
            }
            Request requestToLastDomain = new Request();
            requestToLastDomain.setBandwidth(this.pathReq.getRequestList().get(0).getBandwidth());
            if (this.pathReq.getRequestList().get(0).getReservation() != null) {
                this.log.info("Objeto reservation: " + this.pathReq.getRequestList().get(0).getReservation());
                requestToLastDomain.setReservation(this.pathReq.getRequestList().get(0).getReservation());
                this.log.info("Objeto reservation al hijo: " + requestToLastDomain.getReservation());
            }
            this.addXRO(req.getXro(), requestToLastDomain);
            requestToLastDomain.setEndPoints((EndPoints)endpointsLastDomain);
            RequestParameters rpLastDomain = new RequestParameters();
            long requestID = ParentPCESession.getNewReqIDCounter();
            rpLastDomain.setRequestID(requestID);
            rpLastDomain.setPbit(true);
            requestToLastDomain.setRequestParameters(rpLastDomain);
            if (this.channelType == MEDIA_CHANNEL) {
                objectiveFunction = new ObjectiveFunction();
                objectiveFunction.setOFcode(OF_CODE_MEDIA_CHANNEL);
                requestToLastDomain.setObjectiveFunction(objectiveFunction);
            } else if (this.channelType == SBVT_CHANNEL) {
                objectiveFunction = new ObjectiveFunction();
                objectiveFunction.setOFcode(OF_CODE_SBVT_CHANNEL);
                requestToLastDomain.setObjectiveFunction(objectiveFunction);
            }
            pcreqToLastDomain.addRequest(requestToLastDomain);
            this.log.info("Sending last request to domain " + edge_list.get(i - 1));
            reqList.add(pcreqToLastDomain);
            domainList.add(Last_domain);
        }
        long tiempo3 = System.nanoTime();
        try {
            respList = this.childPCERequestManager.executeRequests(reqList, domainList);
        }
        catch (Exception e) {
            this.log.error("PROBLEM SENDING THE REQUESTS");
            NoPath noPath2 = new NoPath();
            noPath2.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath2.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath2);
            m_resp.addResponse(response);
            return m_resp;
        }
        m_resp.addResponse(response);
        Path path = new Path();
        ExplicitRouteObject ero = new ExplicitRouteObject();
        int j = 0;
        if (first_domain_equal && this.channelType != SBVT_CHANNEL) {
            IPv4prefixEROSubobject sobjt4 = new IPv4prefixEROSubobject();
            sobjt4.setIpv4address(source_router_id_addr);
            sobjt4.setPrefix(32);
            ero.addEROSubobject((EROSubobject)sobjt4);
            UnnumberIfIDEROSubobject idLink = new UnnumberIfIDEROSubobject();
            idLink.setInterfaceID(((InterDomainEdge)edge_list.get(0)).getSrc_if_id());
            idLink.setRouterID((Inet4Address)((InterDomainEdge)edge_list.get(0)).getSrc_router_id());
            ero.addEROSubobject((EROSubobject)idLink);
            ++j;
        }
        boolean childrenFailed = false;
        boolean use_elc = true;
        boolean label_continuity = false;
        boolean remove_elcs = true;
        boolean first = false;
        boolean last = false;
        boolean removeFirstNode = true;
        byte[] bitmap = null;
        DWDMWavelengthLabel label = null;
        DWDMWavelengthLabel label2 = null;
        boolean no_lambda = false;
        LinkedList<ExplicitRouteObject> eroList = new LinkedList<ExplicitRouteObject>();
        LinkedList<ExplicitRouteObject> eroList2 = new LinkedList<ExplicitRouteObject>();
        for (int i = 0; i < respList.size(); ++i) {
            if (respList.get(i) == null) {
                childrenFailed = true;
                continue;
            }
            if (respList.get(i).getResponse(0).getNoPath() != null) {
                this.log.info("ALGUIEN RESPONDIO NOPATH");
                childrenFailed = true;
                continue;
            }
            this.log.info("Respuesta de " + i + " es: " + respList.get(i).toString());
            ExplicitRouteObject eroInternal = respList.get(i).getResponse(0).getPath(0).geteRO();
            this.log.info(" " + eroInternal.toString());
            if (i == 0) {
                first = true;
            } else if (i == respList.size() - 1) {
                last = true;
            }
            if (this.channelType == SBVT_CHANNEL) {
                ero.addEROSubobjectList(eroInternal.getEROSubobjectList());
                continue;
            }
            if (this.channelType == MEDIA_CHANNEL) {
                label_continuity = true;
            } else if (this.channelType == SBVT_CHANNEL) {
                label_continuity = false;
            }
            ExplicitRouteObject cleanEro = this.prepareERO(eroInternal, this.channelType, remove_elcs, this.original_end_points, first, last, removeFirstNode);
            if (label_continuity) {
                if (i == 0) {
                    if (respList.get(i).getResponse(0).getPath(0).getLabelSet() != null) {
                        this.log.info("TENEMOS BITMAP LABEL SET");
                        bitmap = new byte[((BitmapLabelSet)respList.get(i).getResponse(0).getPath(0).getLabelSet()).getBytesBitmap().length];
                        label = new DWDMWavelengthLabel();
                        label.setM(m);
                        System.arraycopy(((BitmapLabelSet)respList.get(i).getResponse(0).getPath(0).getLabelSet()).getBytesBitmap(), 0, bitmap, 0, ((BitmapLabelSet)respList.get(i).getResponse(0).getPath(0).getLabelSet()).getBytesBitmap().length);
                    } else {
                        this.log.info("NO TENEMOS LABEL SET");
                    }
                    if (respList.get(i).getResponse(0).getPath(0).getSuggestedLabel() != null) {
                        this.log.info("TENEMOS SUGGESTED LABEL");
                        label = respList.get(i).getResponse(0).getPath(0).getSuggestedLabel().getDwdmWavelengthLabel();
                    }
                } else if (respList.get(i).getResponse(0).getPath(0).getLabelSet() != null) {
                    this.restrictBitmap(bitmap, ((BitmapLabelSet)respList.get(i).getResponse(0).getPath(0).getLabelSet()).getBytesBitmap());
                } else {
                    label2 = this.getELCfromERO(eroInternal);
                    if (label == null) {
                        label = label2;
                    } else if (label != label2) {
                        no_lambda = true;
                    }
                }
            }
            ExplicitRouteObject ero2 = new ExplicitRouteObject();
            ero2.addEROSubobjectList(cleanEro.getEROSubobjectList());
            eroList.add(ero2);
            ero.addEROSubobjectList(cleanEro.getEROSubobjectList());
            if (this.channelType == SBVT_CHANNEL) continue;
            UnnumberIfIDEROSubobject unnumberIfDEROSubobj = new UnnumberIfIDEROSubobject();
            if (edge_list == null || j >= edge_list.size()) continue;
            unnumberIfDEROSubobj.setInterfaceID(((InterDomainEdge)edge_list.get(j)).getSrc_if_id());
            unnumberIfDEROSubobj.setRouterID((Inet4Address)((InterDomainEdge)edge_list.get(j)).getSrc_router_id());
            this.log.debug(" eroExternal " + unnumberIfDEROSubobj.toString());
            this.addEROifnotexists(ero, unnumberIfDEROSubobj);
            this.addEROifnotexists(ero2, unnumberIfDEROSubobj);
            ++j;
        }
        if (childrenFailed) {
            this.log.warn("Some child has failed");
            noPath = new NoPath();
            response.setNoPath(noPath);
        } else if (label_continuity) {
            if (use_elc) {
                if (label != null) {
                    this.explicit_label = true;
                    if (no_lambda) {
                        this.log.warn("NO LABEL!!!");
                        noPath = new NoPath();
                        response.setNoPath(noPath);
                    } else if (this.explicit_label) {
                        ero = this.addELC(ero, label, this.original_end_points, this.channelType);
                        Iterator it = eroList.iterator();
                        int k = 0;
                        while (it.hasNext()) {
                            ExplicitRouteObject erori = (ExplicitRouteObject)it.next();
                            ExplicitRouteObject ero3 = this.addELC(erori, label, reqList.get(k).getRequest(0).getEndPoints(), this.channelType);
                            eroList2.add(ero3);
                        }
                        path.setEro(ero);
                        response.addPath(path);
                    } else {
                        this.log.warn("NO LABEL!!!");
                        noPath = new NoPath();
                        response.setNoPath(noPath);
                    }
                } else {
                    this.log.warn("NO LABEL!!!");
                    noPath = new NoPath();
                    response.setNoPath(noPath);
                }
            }
        } else {
            path.setEro(ero);
            response.addPath(path);
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Finish processing request " + this.reqId + "in " + tiempotot + " nanosegundos");
        Monitoring monitoring = this.pathReq.getMonitoring();
        if (monitoring == null || monitoring.isProcessingTimeBit()) {
            // empty if block
        }
        return m_resp;
    }

    private DWDMWavelengthLabel getELCfromERO(ExplicitRouteObject eroInternal) {
        DWDMWavelengthLabel label = null;
        for (EROSubobject eroSubobject : eroInternal.getEROSubobjectList()) {
            if (!(eroSubobject instanceof GeneralizedLabelEROSubobject)) continue;
            label = ((GeneralizedLabelEROSubobject)eroSubobject).getDwdmWavelengthLabel();
        }
        return label;
    }

    private ExplicitRouteObject prepareERO(ExplicitRouteObject ero, int channelType, boolean removeELC, EndPoints ep, boolean first, boolean last, boolean removeFirstNode) {
        ExplicitRouteObject eroClean = new ExplicitRouteObject();
        if (channelType == MEDIA_CHANNEL) {
            return ero;
        }
        if (channelType == SBVT_CHANNEL) {
            return ero;
        }
        for (int i = 0; i < ero.getEROSubobjectList().size(); ++i) {
            if (ero.getEROSubobjectList().get(i) instanceof GeneralizedLabelEROSubobject) {
                this.log.info("VEMOS UNA LABEL...");
                if (!removeELC) {
                    eroClean.addEROSubobject((EROSubobject)ero.getEROSubobjectList().get(i));
                    continue;
                }
                this.log.info("LA CEPILLAMOS...");
                continue;
            }
            eroClean.addEROSubobject((EROSubobject)ero.getEROSubobjectList().get(i));
        }
        return eroClean;
    }

    public void addEROifnotexists(ExplicitRouteObject ero, UnnumberIfIDEROSubobject unnumberIfDEROSubobj) {
        if (ero.getEROSubobjectList().getLast() instanceof UnnumberIfIDEROSubobject) {
            if (!((UnnumberIfIDEROSubobject)ero.getEROSubobjectList().getLast()).getRouterID().equals(unnumberIfDEROSubobj.getRouterID())) {
                ero.getEROSubobjectList().add(unnumberIfDEROSubobj);
            }
        } else {
            ero.getEROSubobjectList().add(unnumberIfDEROSubobj);
        }
    }

    public LinkedList<NCF> restrictNCFList(LinkedList<NCF> ncflist, LinkedList<NCF> restrict) {
        LinkedList<NCF> list = new LinkedList<NCF>();
        for (int i = 0; i < ncflist.size(); ++i) {
            if (!restrict.contains(ncflist.get(i))) continue;
            list.add(ncflist.get(i));
        }
        return list;
    }

    public void restrictBitmap(byte[] bitmap, byte[] bitmap2) {
        if (bitmap2 == null) {
            this.log.info("BORRAAAANDO");
            for (int i = 0; i < bitmap.length; ++i) {
                bitmap[i] = 0;
            }
        } else {
            for (int i = 0; i < bitmap.length; ++i) {
                bitmap[i] = (byte)(bitmap[i] & 0xFF & (bitmap2[i] & 0xFF));
            }
        }
    }

    public boolean isLabelFree(byte[] bitmap) {
        boolean isFree = false;
        if (bitmap == null) {
            isFree = true;
        } else {
            for (int i = 0; i < bitmap.length; ++i) {
                if ((bitmap[i] & 0xFF) <= 0) continue;
                isFree = true;
            }
        }
        return isFree;
    }

    public int getFirstN(byte[] bitmap, int m) {
        int n = -1;
        int max_lambdas = bitmap.length * 8;
        for (int i = m; i < max_lambdas; ++i) {
            boolean free = true;
            for (int j = i - m; j < i + m; ++j) {
                int num_byte = j / 8;
                if ((bitmap[num_byte] & 128 >>> j % 8) == 128 >>> j % 8) continue;
                free = false;
            }
            if (!free) continue;
            return i;
        }
        return n;
    }

    public ExplicitRouteObject addELC(ExplicitRouteObject ero, DWDMWavelengthLabel dwdmWavelengthLabel, EndPoints ep, int channelType) {
        ExplicitRouteObject ero2 = new ExplicitRouteObject();
        int i = 0;
        if (channelType == MEDIA_CHANNEL) {
            for (i = 0; i < ero.getEROSubobjectList().size(); ++i) {
                if (i == 0) {
                    ero2.addEROSubobject((EROSubobject)ero.getEROSubobjectList().get(i));
                    continue;
                }
                if (i == ero.getEROSubobjectList().size() - 1) {
                    ero2.addEROSubobject((EROSubobject)ero.getEROSubobjectList().get(i));
                    continue;
                }
                ero2.addEROSubobject((EROSubobject)ero.getEROSubobjectList().get(i));
                if (!(ero.getEROSubobjectList().get(i) instanceof UnnumberIfIDEROSubobject)) continue;
                GeneralizedLabelEROSubobject ge = new GeneralizedLabelEROSubobject();
                ge.setDwdmWavelengthLabel(dwdmWavelengthLabel);
                ero2.addEROSubobject((EROSubobject)ge);
            }
        } else {
            for (i = 0; i < ero.getEROSubobjectList().size(); ++i) {
                ero2.addEROSubobject((EROSubobject)ero.getEROSubobjectList().get(i));
                if (!(ero.getEROSubobjectList().get(i) instanceof UnnumberIfIDEROSubobject)) continue;
                GeneralizedLabelEROSubobject ge = new GeneralizedLabelEROSubobject();
                ge.setDwdmWavelengthLabel(dwdmWavelengthLabel);
                ero2.addEROSubobject((EROSubobject)ge);
            }
        }
        return ero2;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return null;
    }

    public void addXRO(ExcludeRouteObject xro, Request req) {
        req.setXro(xro);
    }

    public void processXRO(ExcludeRouteObject xro, DirectedWeightedMultigraph<Inet4Address, InterDomainEdge> networkGraph) {
        if (xro != null) {
            for (int i = 0; i < xro.getXROSubobjectList().size(); ++i) {
                UnnumberIfIDXROSubobject eros;
                boolean hasVertex;
                XROSubobject eroso = (XROSubobject)xro.getXROSubobjectList().get(i);
                if (eroso.getType() != 4 || !(hasVertex = networkGraph.containsVertex((Object)(eros = (UnnumberIfIDXROSubobject)eroso).getRouterID()))) continue;
                Set setEdges = networkGraph.edgesOf((Object)eros.getRouterID());
                for (InterDomainEdge edge : setEdges) {
                    if (edge.getSrc_if_id() != eros.getInterfaceID()) continue;
                    networkGraph.removeEdge((Object)edge);
                }
            }
        }
    }

    public Inet4Address getSourceRouter(EndPoints EP) {
        Inet4Address source_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)EP;
            source_router_id_addr = ep.getSourceIP();
        } else if (EP.getOT() == 2) {
            // empty if block
        }
        if (EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)EP;
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                if (sourceep.getEndPointIPv4TLV() != null) {
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().getIPv4address();
                } else if (sourceep.getUnnumberedEndpoint() != null) {
                    source_router_id_addr = sourceep.getUnnumberedEndpoint().getIPv4address();
                }
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        return source_router_id_addr;
    }

    public long getSourceIfID(EndPoints EP) {
        GeneralizedEndPoints gep;
        long if_id = -1L;
        if (EP.getOT() == 5 && (gep = (GeneralizedEndPoints)EP).getGeneralizedEndPointsType() == 0 && gep.getP2PEndpoints().getSourceEndPoint().getUnnumberedEndpoint() != null) {
            if_id = gep.getP2PEndpoints().getSourceEndPoint().getUnnumberedEndpoint().getIfID();
        }
        return if_id;
    }

    public long getDestIfID(EndPoints EP) {
        GeneralizedEndPoints gep;
        long if_id = -1L;
        if (EP.getOT() == 5 && (gep = (GeneralizedEndPoints)EP).getGeneralizedEndPointsType() == 0 && gep.getP2PEndpoints().getDestinationEndPoint().getUnnumberedEndpoint() != null) {
            if_id = gep.getP2PEndpoints().getDestinationEndPoint().getUnnumberedEndpoint().getIfID();
        }
        return if_id;
    }

    public Inet4Address getDestRouter(EndPoints EP) {
        GeneralizedEndPoints gep;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)EP;
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() == 2) {
            // empty if block
        }
        if (EP.getOT() == 5 && (gep = (GeneralizedEndPoints)EP).getGeneralizedEndPointsType() == 0) {
            P2PEndpoints p2pep = gep.getP2PEndpoints();
            EndPoint sourceep = p2pep.getSourceEndPoint();
            EndPoint destep = p2pep.getDestinationEndPoint();
            if (destep.getEndPointIPv4TLV() != null) {
                dest_router_id_addr = destep.getEndPointIPv4TLV().getIPv4address();
            } else if (destep.getUnnumberedEndpoint() != null) {
                dest_router_id_addr = destep.getUnnumberedEndpoint().getIPv4address();
            }
        }
        return dest_router_id_addr;
    }

    public ExplicitRouteObject checkMediaChannel(ExplicitRouteObject ero) {
        return ero;
    }

    private PCEPRequest createRequest(int channelType, ExcludeRouteObject xro, Bandwidth bw, EndPoints ep) {
        PCEPRequest pcreqToDomain = new PCEPRequest();
        if (this.pathReq.getMonitoring() != null) {
            pcreqToDomain.setMonitoring(this.pathReq.getMonitoring());
        }
        if (this.pathReq.getPccReqId() != null) {
            pcreqToDomain.setPccReqId(this.pathReq.getPccReqId());
        }
        Request requestToDomain = new Request();
        if (bw != null) {
            requestToDomain.setBandwidth(bw);
        }
        this.addXRO(xro, requestToDomain);
        requestToDomain.setEndPoints(ep);
        RequestParameters rpDomain = new RequestParameters();
        int newRequestID = ParentPCESession.getNewReqIDCounter();
        rpDomain.setRequestID((long)newRequestID);
        rpDomain.setPbit(true);
        requestToDomain.setRequestParameters(rpDomain);
        if (channelType == MEDIA_CHANNEL) {
            ObjectiveFunction objectiveFunction = new ObjectiveFunction();
            objectiveFunction.setOFcode(OF_CODE_MEDIA_CHANNEL);
            requestToDomain.setObjectiveFunction(objectiveFunction);
        } else if (channelType == SBVT_CHANNEL) {
            ObjectiveFunction objectiveFunction = new ObjectiveFunction();
            objectiveFunction.setOFcode(OF_CODE_SBVT_CHANNEL);
            requestToDomain.setObjectiveFunction(objectiveFunction);
        }
        pcreqToDomain.addRequest(requestToDomain);
        return pcreqToDomain;
    }

    public void pruneSVBTs(DirectedWeightedMultigraph<Object, InterDomainEdge> graph) {
        Iterator it = graph.edgeSet().iterator();
        LinkedList<InterDomainEdge> delList = new LinkedList<InterDomainEdge>();
        while (it.hasNext()) {
            InterDomainEdge edge = (InterDomainEdge)it.next();
            if (edge.getTE_info() == null || edge.getTE_info().getMfOTF() == null) continue;
            delList.add(edge);
        }
        for (int i = 0; i < delList.size(); ++i) {
            graph.removeEdge(delList.get(i));
        }
    }
}

