/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms;

import es.tid.of.DataPathID;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.AvailableLabels;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.LabelSetField;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.objects.Metric;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.TE_Information;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPUtils {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");

    public static void completeMetric(Path path, Request req, List<IntraDomainEdge> edge_list) {
        block4: for (int i = 0; i < req.getMetricList().size(); ++i) {
            if (!((Metric)req.getMetricList().get(i)).isComputedMetricBit()) continue;
            int metric_type = ((Metric)req.getMetricList().get(i)).getMetricType();
            switch (metric_type) {
                case 3: {
                    Metric metric = new Metric();
                    metric.setMetricType(3);
                    float metricValue = edge_list.size();
                    metric.setMetricValue(metricValue);
                    path.getMetricList().add(metric);
                    continue block4;
                }
                case 13: {
                    Metric metricLat = new Metric();
                    metricLat.setMetricType(13);
                    float metricValueLat = 0.0f;
                    for (int j = 0; j < edge_list.size(); ++j) {
                        metricValueLat = (float)((double)metricValueLat + edge_list.get(j).getDelay_ms());
                    }
                    metricLat.setMetricValue(metricValueLat);
                    path.getMetricList().add(metricLat);
                }
            }
        }
    }

    public static SimpleDirectedWeightedGraph<Object, IntraDomainEdge> duplicateTEDDB(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph) {
        SimpleDirectedWeightedGraph networkGraphDuplicated = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
        Set nodes = networkGraph.vertexSet();
        Iterator iter = nodes.iterator();
        Set fiberEdges = networkGraph.edgeSet();
        DataPathID dpid = new DataPathID();
        while (iter.hasNext()) {
            networkGraphDuplicated.addVertex(iter.next());
        }
        for (IntraDomainEdge fiberEdge : fiberEdges) {
            IntraDomainEdge edge = new IntraDomainEdge();
            TE_Information informationTEDB = new TE_Information();
            edge.setTE_info(informationTEDB);
            informationTEDB.setAvailableLabels(new AvailableLabels());
            BitmapLabelSet newBitmapLabelSet = new BitmapLabelSet();
            int numLabels = fiberEdge.getTE_info().getAvailableLabels().getLabelSet().getNumLabels();
            newBitmapLabelSet.createBytesBitMap(((BitmapLabelSet)fiberEdge.getTE_info().getAvailableLabels().getLabelSet()).getBytesBitMap());
            int numberBytes = numLabels / 8;
            if (numberBytes * 8 < numLabels) {
                ++numberBytes;
            }
            byte[] bytesBitMapReserved = new byte[numberBytes];
            for (int i = 0; i < numberBytes; ++i) {
                bytesBitMapReserved[i] = 0;
            }
            newBitmapLabelSet.setBytesBitmapReserved(bytesBitMapReserved);
            newBitmapLabelSet.setNumLabels(numLabels);
            informationTEDB.getAvailableLabels().setLabelSet((LabelSetField)newBitmapLabelSet);
            networkGraphDuplicated.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)edge);
        }
        return networkGraphDuplicated;
    }
}

