/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.mpls;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.mpls.EncodeEroMPLS;
import es.tid.pce.computingEngine.algorithms.mpls.MPLS_MinTH_AlgorithmPreComputation;
import es.tid.pce.computingEngine.algorithms.multiLayer.BFS_from_dst;
import es.tid.pce.computingEngine.algorithms.multiLayer.BFS_from_src;
import es.tid.pce.computingEngine.algorithms.multiLayer.Operacion2;
import es.tid.pce.computingEngine.algorithms.multiLayer.Operacion3;
import es.tid.pce.computingEngine.algorithms.multiLayer.OperationsCounter;
import es.tid.pce.computingEngine.algorithms.wson.GenericLambdaReservation;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPLS_MinTH_Algorithm
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private Logger log_OP = LoggerFactory.getLogger((String)"OpMultiLayer");
    private ComputingRequest pathReq;
    private MPLS_MinTH_AlgorithmPreComputation preComp;
    static Operacion3 op3;
    static BFS_from_src Op4a;
    static BFS_from_dst Op4b;
    private ReservationManager reservationManager;
    private DomainTEDB ted;
    private GenericLambdaReservation reserv;
    private OperationsCounter OP_Counter;
    private Lock graphLock;
    private ArrayList<SimpleDirectedWeightedGraph<Inet4Address, IntraDomainEdge>> networkGraphs_precomp;

    public MPLS_MinTH_Algorithm(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager, OperationsCounter OPcounter) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
        this.OP_Counter = OPcounter;
    }

    @Override
    public ComputingResponse call() {
        this.log.debug("Starting Multilayer Min Ligth Paths Algorithm");
        this.graphLock = this.preComp.getGraphLock();
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        long tiempoini = System.nanoTime();
        ComputingResponse m_resp_individual = new ComputingResponse();
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setBidirect(req.getRequestParameters().isBidirect());
        rp.setRequestID(reqId);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        BandwidthRequested bandwidth = new BandwidthRequested();
        bandwidth.setBw(((BandwidthRequested)req.getBandwidth()).getBw());
        response.setBandwidth((Bandwidth)bandwidth);
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
        } else if (EP.getOT() != 2 && EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        this.log.error("Source: " + source_router_id_addr + "; Destination:" + dest_router_id_addr);
        if (!this.ted.containsVertex((Object)source_router_id_addr) || !this.ted.containsVertex((Object)dest_router_id_addr)) {
            this.log.error("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!this.ted.containsVertex((Object)source_router_id_addr)) {
                this.log.error("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!this.ted.containsVertex((Object)dest_router_id_addr)) {
                this.log.error("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> GraphIP = this.preComp.getnetworkGraphIP();
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> InterlayerGraph = this.preComp.getInterLayerGraph();
        ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs = this.preComp.getNetworkGraphs();
        boolean nopath = true;
        GraphPath<Object, IntraDomainEdge> gp_chosen = null;
        float bwt_req = ((BandwidthRequested)req.getBandwidth()).getBw();
        GraphPath<Object, IntraDomainEdge> gp = Operacion2.get_op2(GraphIP, source_router_id_addr, dest_router_id_addr, bwt_req, this.graphLock);
        if (gp != null) {
            this.log.warn("Multiple LigthPath found at Operation 2--");
            nopath = false;
            gp_chosen = gp;
        }
        if (nopath) {
            this.log.debug("No path found");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        if (!nopath) {
            Path path = new Path();
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list = gp_chosen.getEdgeList();
            path.setEro(ero);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.addPath(path);
            EncodeEroMPLS.createEroMpls(ero, edge_list);
            LinkedList<Object> sourceVertexList = new LinkedList<Object>();
            LinkedList<Object> targetVertexList = new LinkedList<Object>();
            for (int i = 0; i < edge_list.size(); ++i) {
                sourceVertexList.add(((IntraDomainEdge)edge_list.get(i)).getSource());
                targetVertexList.add(((IntraDomainEdge)edge_list.get(i)).getTarget());
            }
            if (req.getReservation() != null) {
                this.reserv = new GenericLambdaReservation();
                this.reserv.setResp(m_resp);
                this.reserv.setReservation(req.getReservation());
                this.reserv.setSourceVertexList(sourceVertexList);
                this.reserv.setTargetVertexList(targetVertexList);
                this.reserv.setBidirectional(rp.isBidirect());
                this.reserv.setReservationManager(this.reservationManager);
            } else {
                this.log.info("Reservation is FALSE");
            }
        }
        long tiempofin = System.nanoTime();
        long tiempotot = tiempofin - tiempoini;
        this.log.info("Ha tardado " + tiempotot + " nanosegundos");
        return m_resp;
    }

    public void setPreComp(MPLS_MinTH_AlgorithmPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Inet4Address> sourceVertexList, LinkedList<Inet4Address> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Inet4Address, IntraDomainEdge> networkGraph = this.networkGraphs_precomp.get(wavelength);
            for (int i = 0; i < sourceVertexList.size(); ++i) {
                networkGraph.removeEdge((Object)sourceVertexList.get(i), (Object)targetVertexList.get(i));
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }
}

