/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.mpls;

import es.tid.ospf.ospfv2.lsa.tlv.subtlv.complexFields.BitmapLabelSet;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmPreComputation;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.MultiLayerTEDB;
import es.tid.tedb.TEDB;
import es.tid.tedb.TE_Information;
import es.tid.tedb.WSONInformation;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPLS_MinTH_AlgorithmPreComputation
implements ComputingAlgorithmPreComputation {
    private ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> networkGraphs;
    private int numLambdas;
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private Lock graphLock;
    private DomainTEDB ted;
    private WSONInformation WSONInfo;
    private Integer MaxNodesOptical;
    public Hashtable<Integer, InfoNodo> infoTable;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> NetworkGraphIP;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> OpticalnetworkGraph;
    private SimpleDirectedWeightedGraph<Object, IntraDomainEdge> InterLayerGraph;
    public Hashtable<Object, Hashtable<Object, List<GraphPath<Object, IntraDomainEdge>>>> routeTable;

    public Integer getMaxNodesOptical() {
        return this.MaxNodesOptical;
    }

    @Override
    public void initialize() {
        this.log.info("Initializing Multilayer Algorithm");
        System.out.println("Resgistramos el algoritmo Multilayer");
        this.numLambdas = this.ted.getWSONinfo().getNumLambdas();
        this.graphLock = new ReentrantLock();
        Set nodes1 = this.OpticalnetworkGraph.vertexSet();
        Set fiberEdges = this.OpticalnetworkGraph.edgeSet();
        if (this.numLambdas > 0) {
            this.networkGraphs = new ArrayList(this.numLambdas);
            for (int i = 0; i < this.numLambdas; ++i) {
                this.log.info("Adding graph of lambda " + i);
                System.out.println("Adding graph of lambda " + i);
                SimpleDirectedWeightedGraph graph_lambda = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
                this.networkGraphs.add(i, (SimpleDirectedWeightedGraph<Object, IntraDomainEdge>)graph_lambda);
                Iterator iter = nodes1.iterator();
                while (iter.hasNext()) {
                    graph_lambda.addVertex(iter.next());
                }
                for (IntraDomainEdge fiberEdge : fiberEdges) {
                    IntraDomainEdge edge = new IntraDomainEdge();
                    edge.setDelay_ms(fiberEdge.getDelay_ms());
                    graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)edge);
                }
            }
        } else {
            this.log.info("REGISTERING MULTILAYER ALGORITHM WITHOUT KNOWN NUMBER OF LAMBDAS");
        }
    }

    @Override
    public void setTEDB(TEDB ted) {
        try {
            this.NetworkGraphIP = ((MultiLayerTEDB)ted).getUpperLayerGraph();
            this.OpticalnetworkGraph = ((MultiLayerTEDB)ted).getDuplicatedLowerLayerkGraph();
            this.InterLayerGraph = ((MultiLayerTEDB)ted).getDuplicatedInterLayerGraph();
            this.log.info("Using MultiLayerTEDB");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        this.WSONInfo = ((DomainTEDB)ted).getWSONinfo();
        this.ted = (DomainTEDB)ted;
        this.numLambdas = this.WSONInfo.getNumLambdas();
    }

    @Override
    public ArrayList<SimpleDirectedWeightedGraph<Object, IntraDomainEdge>> getNetworkGraphs() {
        return this.networkGraphs;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getnetworkGraphIP() {
        return this.NetworkGraphIP;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getOpticalnetworkGraph() {
        return this.OpticalnetworkGraph;
    }

    public void setOpticalnetworkGraph(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> opticalNetworkGraph) {
        this.OpticalnetworkGraph = opticalNetworkGraph;
    }

    public void setnetworkGraphIP(SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraphIP) {
        this.NetworkGraphIP = networkGraphIP;
    }

    public SimpleDirectedWeightedGraph<Object, IntraDomainEdge> getInterLayerGraph() {
        return this.InterLayerGraph;
    }

    public Hashtable<Integer, InfoNodo> getInfoTable() {
        return this.infoTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs.get(wavelength);
            for (int i = 0; i < sourceVertexList.size() - 1; ++i) {
                networkGraph.removeEdge(sourceVertexList.get(i), targetVertexList.get(i));
                System.out.println("EDGE OUT");
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthEndReservation(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength) {
        this.graphLock.lock();
        try {
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph = this.networkGraphs.get(wavelength);
            for (int i = 0; i < sourceVertexList.size() - 1; ++i) {
                if (!((IntraDomainEdge)this.OpticalnetworkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i))).getTE_info().isWavelengthFree(wavelength)) continue;
                IntraDomainEdge edge = new IntraDomainEdge();
                edge.setDelay_ms(((IntraDomainEdge)this.OpticalnetworkGraph.getEdge(sourceVertexList.get(i), targetVertexList.get(i))).getDelay_ms());
                networkGraph.addEdge(sourceVertexList.get(i), targetVertexList.get(i), (Object)edge);
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public Lock getGraphLock() {
        return this.graphLock;
    }

    public void setGraphLock(Lock graphLock) {
        this.graphLock = graphLock;
    }

    public WSONInformation getWSONInfo() {
        return this.WSONInfo;
    }

    public void setWSONInfo(WSONInformation wSONInfo) {
        this.WSONInfo = wSONInfo;
    }

    public void notifyNewVertex(Object vertex) {
        for (int i = 0; i < this.numLambdas; ++i) {
            this.log.info("Adding graph of lambda " + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            graph_lambda.addVertex(vertex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTEDBFullUpdate() {
        this.graphLock.lock();
        try {
            Set nodes = this.OpticalnetworkGraph.vertexSet();
            Set fiberEdges = this.OpticalnetworkGraph.edgeSet();
            if (this.numLambdas > 0) {
                this.networkGraphs = new ArrayList(this.numLambdas);
                for (int i = 0; i < this.numLambdas; ++i) {
                    this.log.info("Looking at graph of lambda " + i);
                    SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
                    Iterator iter = nodes.iterator();
                    for (IntraDomainEdge fiberEdge : fiberEdges) {
                        if (graph_lambda.containsEdge(fiberEdge.getSource(), fiberEdge.getTarget()) || !fiberEdge.getTE_info().isWavelengthFree(i) || !fiberEdge.getTE_info().isWavelengthUnreserved(i)) continue;
                        graph_lambda.addEdge(fiberEdge.getSource(), fiberEdge.getTarget(), (Object)fiberEdge);
                    }
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public void notifyNewEdge(Object source, Object destination) {
        for (int i = 0; i < this.numLambdas; ++i) {
            this.log.info("Adding graph of lambda " + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            graph_lambda.addEdge(source, destination, this.OpticalnetworkGraph.getEdge(source, destination));
        }
    }

    public void notifyNewLSP(Object source, Object destination) {
        for (int i = 0; i < this.numLambdas; ++i) {
            this.log.info("Adding graph of lambda " + i);
            SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph_lambda = this.networkGraphs.get(i);
            IntraDomainEdge edge = new IntraDomainEdge();
            edge.setDelay_ms(((IntraDomainEdge)this.OpticalnetworkGraph.getEdge(source, destination)).getDelay_ms());
            graph_lambda.addEdge(source, destination, (Object)edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWavelengthStatusChange(Object source, Object destination, BitmapLabelSet previousBitmapLabelSet, BitmapLabelSet newBitmapLabelSet) {
        previousBitmapLabelSet.getNumLabels();
        int num_bytes = previousBitmapLabelSet.getBytesBitMap().length;
        int wavelength_to_occupy = -1;
        int wavelength_to_free = -1;
        try {
            this.graphLock.lock();
            for (int i = 0; i < num_bytes; ++i) {
                if (previousBitmapLabelSet.getBytesBitMap()[i] == newBitmapLabelSet.getBytesBitMap()[i]) continue;
                for (int k = 0; k < 8; ++k) {
                    SimpleDirectedWeightedGraph<Object, IntraDomainEdge> networkGraph;
                    if ((newBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) > (previousBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k)) {
                        wavelength_to_occupy = k + i * 8;
                        networkGraph = this.networkGraphs.get(wavelength_to_occupy);
                        networkGraph.removeEdge(source, destination);
                        continue;
                    }
                    if ((newBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) >= (previousBitmapLabelSet.getBytesBitMap()[i] & 128 >>> k) || (newBitmapLabelSet.getBytesBitmapReserved()[i] & 128 >>> k) != 0) continue;
                    wavelength_to_free = k + i * 8;
                    networkGraph = this.networkGraphs.get(wavelength_to_free);
                    networkGraph.addEdge(source, destination);
                }
            }
        }
        finally {
            this.graphLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewEdgeIP(Object source, Object destination, TE_Information informationTEDB) {
        try {
            this.graphLock.lock();
            IntraDomainEdge edge = new IntraDomainEdge();
            edge.setTE_info(informationTEDB);
            this.NetworkGraphIP.addEdge(source, destination, (Object)edge);
        }
        finally {
            this.graphLock.unlock();
        }
    }

    public void notificationEdgeIP_AuxGraph(Object src, Object dst, TE_Information informationTEDB) {
    }

    public void notificationEdgeOPTICAL_AuxGraph(Object src, Object dst, int lambda) {
    }

    @Override
    public void setGrooming_policie(int groomingPolicie) {
    }

    @Override
    public ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> getNetworkMultiGraphs() {
        return null;
    }

    @Override
    public boolean isMultifiber() {
        return false;
    }

    @Override
    public String printBaseTopology() {
        return null;
    }

    @Override
    public String printTopology(int lambda) {
        return null;
    }

    @Override
    public void setMultifiber(boolean multifiber) {
    }

    @Override
    public void setNetworkMultiGraphs(ArrayList<DirectedMultigraph<Object, IntraDomainEdge>> networkMultiGraphs) {
    }

    public class InfoNodo {
        private int numLayer;
        private int I_O;
        private Object IPnode;

        public int getnumLayer() {
            return this.numLayer;
        }

        public void setnumLayer(int numLayer) {
            this.numLayer = numLayer;
        }

        public int getI_O() {
            return this.I_O;
        }

        public void setI_O(int I_O) {
            this.I_O = I_O;
        }

        public Object getIPnode() {
            return this.IPnode;
        }

        public void setIPnode(Object IPnode) {
            this.IPnode = IPnode;
        }
    }
}

