/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.multiLayer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.graph.GraphPathImpl;
import org.jgrapht.traverse.ClosestFirstIterator;

public final class Dijkstra<V, E> {
    private GraphPath<V, E> path;

    public Dijkstra(Graph<V, E> graph, V startVertex, V endVertex) {
        this(graph, startVertex, endVertex, Double.POSITIVE_INFINITY);
    }

    public Dijkstra(Graph<V, E> graph, V startVertex, V endVertex, double radius) {
        if (!graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("graph must contain the end vertex");
        }
        ClosestFirstIterator iter = new ClosestFirstIterator(graph, startVertex, radius);
        while (iter.hasNext()) {
            Object vertex = iter.next();
            if (!vertex.equals(endVertex)) continue;
            this.createEdgeList(graph, iter, startVertex, endVertex);
            return;
        }
        this.path = null;
    }

    public List<E> getPathEdgeList() {
        if (this.path == null) {
            return null;
        }
        return this.path.getEdgeList();
    }

    public GraphPath<V, E> getPath() {
        return this.path;
    }

    public double getPathLength() {
        if (this.path == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.path.getWeight();
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V startVertex, V endVertex) {
        Dijkstra<V, E> alg = new Dijkstra<V, E>(graph, startVertex, endVertex);
        return alg.getPathEdgeList();
    }

    private void createEdgeList(Graph<V, E> graph, ClosestFirstIterator<V, E> iter, V startVertex, V endVertex) {
        Object edge;
        ArrayList<Object> edgeList = new ArrayList<Object>();
        Object v = endVertex;
        while ((edge = iter.getSpanningTreeEdge(v)) != null) {
            edgeList.add(edge);
            v = Graphs.getOppositeVertex(graph, (Object)edge, v);
        }
        Collections.reverse(edgeList);
        double pathLength = iter.getShortestPathLength(endVertex);
        this.path = new GraphPathImpl(graph, startVertex, endVertex, edgeList, pathLength);
    }
}

