/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.computingEngine.algorithms.multiLayer;

import es.tid.pce.computingEngine.ComputingRequest;
import es.tid.pce.computingEngine.ComputingResponse;
import es.tid.pce.computingEngine.algorithms.AlgorithmReservation;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithm;
import es.tid.pce.computingEngine.algorithms.PCEPUtils;
import es.tid.pce.computingEngine.algorithms.multiLayer.Multilayer_Algorithm_auxGraphPreComputation;
import es.tid.pce.computingEngine.algorithms.multiLayer.OperationsCounter;
import es.tid.pce.computingEngine.algorithms.wson.GenericLambdaReservation;
import es.tid.pce.pcep.constructs.EndPoint;
import es.tid.pce.pcep.constructs.EndPointAndRestrictions;
import es.tid.pce.pcep.constructs.P2MPEndpoints;
import es.tid.pce.pcep.constructs.P2PEndpoints;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.Response;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.GeneralizedEndPoints;
import es.tid.pce.pcep.objects.NoPath;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.tlvs.NoPathTLV;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.gmpls.DWDMWavelengthLabel;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.GeneralizedLabelEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.ServerLayerInfo;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.tedb.IntraDomainEdge;
import es.tid.tedb.MultiLayerTEDB;
import es.tid.tedb.TEDB;
import java.net.Inet4Address;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Multilayer_Algorithm_auxGraph
implements ComputingAlgorithm {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private Logger log_OP = LoggerFactory.getLogger((String)"OpMultiLayer");
    private ComputingRequest pathReq;
    private Multilayer_Algorithm_auxGraphPreComputation preComp;
    private Lock graphLock;
    private ReservationManager reservationManager;
    private Lock contadoresLock;
    private DomainTEDB ted;
    private GenericLambdaReservation reserv;
    private OperationsCounter OP_Counter;

    public Multilayer_Algorithm_auxGraph(ComputingRequest pathReq, TEDB ted, ReservationManager reservationManager, OperationsCounter OPcounter) {
        this.pathReq = pathReq;
        this.reservationManager = reservationManager;
        this.ted = (DomainTEDB)ted;
        this.OP_Counter = OPcounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputingResponse call() {
        GraphPath gp;
        this.graphLock = this.preComp.getGraphLock();
        int num_Layer_changes = 0;
        long tiempoini = System.nanoTime();
        this.log.info("Starting AURE Algorithm, new path Request!");
        ComputingResponse m_resp = new ComputingResponse();
        m_resp.setEncodingType(this.pathReq.getEcodingType());
        Request req = this.pathReq.getRequestList().get(0);
        long reqId = req.getRequestParameters().getRequestID();
        this.log.info("Request id: " + reqId + ", getting endpoints");
        Response response = new Response();
        RequestParameters rp = new RequestParameters();
        rp.setBidirect(req.getRequestParameters().isBidirect());
        rp.setRequestID(reqId);
        BandwidthRequested bandwidth = new BandwidthRequested();
        bandwidth.setBw(((BandwidthRequested)req.getBandwidth()).getBw());
        response.setBandwidth((Bandwidth)bandwidth);
        response.setRequestParameters(rp);
        m_resp.addResponse(response);
        EndPoints EP = req.getEndPoints();
        Inet4Address source_router_id_addr = null;
        Inet4Address dest_router_id_addr = null;
        Object source_aux_graph = null;
        Object dest_aux_graph = null;
        SimpleDirectedWeightedGraph<Object, IntraDomainEdge> graph = this.preComp.getbaseSimplegraph();
        if (EP.getOT() == 1) {
            EndPointsIPv4 ep = (EndPointsIPv4)req.getEndPoints();
            source_router_id_addr = ep.getSourceIP();
            dest_router_id_addr = ep.getDestIP();
            this.preComp.getRelation_access_nodes();
            source_aux_graph = this.preComp.getRelation_access_nodes().get(source_router_id_addr);
            Integer number_src_out = this.preComp.getInfo_IPv4_IntNodes().get(source_aux_graph) + 1;
            source_aux_graph = this.preComp.getinfo_IntNodes_IPv4().get(number_src_out);
            dest_aux_graph = this.preComp.getRelation_access_nodes().get(dest_router_id_addr);
        } else if (EP.getOT() != 2 && EP.getOT() == 5) {
            GeneralizedEndPoints gep = (GeneralizedEndPoints)req.getEndPoints();
            if (gep.getGeneralizedEndPointsType() == 0) {
                P2PEndpoints p2pep = gep.getP2PEndpoints();
                EndPoint sourceep = p2pep.getSourceEndPoint();
                EndPoint destep = p2pep.getDestinationEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
            }
            if (gep.getGeneralizedEndPointsType() == 1) {
                P2MPEndpoints p2mpep = gep.getP2MPEndpoints();
                EndPointAndRestrictions epandrest = p2mpep.getEndPointAndRestrictions();
                EndPoint sourceep = epandrest.getEndPoint();
                source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                int cont = 0;
                while (cont <= p2mpep.getEndPointAndRestrictionsList().size()) {
                    epandrest = (EndPointAndRestrictions)p2mpep.getEndPointAndRestrictionsList().get(cont);
                    EndPoint destep = epandrest.getEndPoint();
                    source_router_id_addr = sourceep.getEndPointIPv4TLV().IPv4address;
                    dest_router_id_addr = destep.getEndPointIPv4TLV().IPv4address;
                }
            }
        }
        this.log.debug("Source: " + source_aux_graph + "; Destination:" + dest_aux_graph);
        if (!this.ted.containsVertex(source_aux_graph) || !this.ted.containsVertex(dest_aux_graph)) {
            this.log.warn("Source or destination are NOT in the TED");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            if (!((MultiLayerTEDB)this.ted).containsVertex(source_aux_graph)) {
                this.log.info("Unknown source");
                noPathTLV.setUnknownSource(true);
            }
            if (!((MultiLayerTEDB)this.ted).containsVertex(dest_aux_graph)) {
                this.log.info("Unknown destination");
                noPathTLV.setUnknownDestination(true);
            }
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            return m_resp;
        }
        boolean nopath = true;
        int lambda_chosen = 0;
        GraphPath gp_chosen = null;
        SimpleDirectedWeightedGraph constrained_graph = new SimpleDirectedWeightedGraph(IntraDomainEdge.class);
        this.graphLock.lock();
        try {
            constrained_graph = (SimpleDirectedWeightedGraph)graph.clone();
            Set links1 = graph.edgeSet();
            for (IntraDomainEdge link1 : links1) {
                if (link1.getTE_info() == null || !(link1.getTE_info().getMaximumReservableBandwidth().maximumReservableBandwidth < ((BandwidthRequested)req.getBandwidth()).getBw())) continue;
                constrained_graph.removeEdge((Object)link1);
            }
            DijkstraShortestPath dsp = new DijkstraShortestPath((Graph)constrained_graph, source_aux_graph, dest_aux_graph);
            gp = dsp.getPath();
        }
        finally {
            this.graphLock.unlock();
        }
        if (gp != null) {
            nopath = false;
            gp_chosen = gp;
        }
        if (nopath) {
            this.log.info("No path found");
            NoPath noPath = new NoPath();
            noPath.setNatureOfIssue(0);
            NoPathTLV noPathTLV = new NoPathTLV();
            noPath.setNoPathTLV(noPathTLV);
            response.setNoPath(noPath);
            this.log_OP.info("NumOP_1: " + this.OP_Counter.getNum_op1());
            this.log_OP.info("NumOP_2: " + this.OP_Counter.getNum_op2());
            this.log_OP.info("NumOP_3: " + this.OP_Counter.getNum_op3());
            this.log_OP.info("NumOP_4: " + this.OP_Counter.getNum_op4());
            this.log_OP.info("MeanLayerChanges: " + this.OP_Counter.getMean_layer_changes() + "\n\n");
            return m_resp;
        }
        int NumLambdas = this.ted.getWSONinfo().getNumLambdas();
        Hashtable<Object, Integer> Info_IPv4_IntNodes = this.preComp.getInfo_IPv4_IntNodes();
        Hashtable<Integer, Multilayer_Algorithm_auxGraphPreComputation.InfoNodo> infoTable = this.preComp.getInfoTable();
        if (!nopath) {
            Path path = new Path();
            boolean traffic_hops = false;
            ExplicitRouteObject ero = new ExplicitRouteObject();
            List edge_list = gp_chosen.getEdgeList();
            boolean flag = false;
            int j = 0;
            for (j = 0; j < edge_list.size(); ++j) {
                IPv4prefixEROSubobject eroso;
                IntraDomainEdge link_aux = (IntraDomainEdge)edge_list.get(j);
                Object Nodo_aux_actual_IP = ((IntraDomainEdge)edge_list.get(j)).getSource();
                Integer Nodo_aux_actual = Info_IPv4_IntNodes.get(Nodo_aux_actual_IP);
                Object node_aux_target_IP = link_aux.getTarget();
                Integer node_aux_target = Info_IPv4_IntNodes.get(node_aux_target_IP);
                Multilayer_Algorithm_auxGraphPreComputation.InfoNodo info_actual = infoTable.get(Nodo_aux_actual);
                Multilayer_Algorithm_auxGraphPreComputation.InfoNodo info_next = infoTable.get(node_aux_target);
                if (info_actual.getnumLayer() == NumLambdas + 2) {
                    if (info_next.getnumLayer() <= NumLambdas && info_next.getnumLayer() >= 1) {
                        ++num_Layer_changes;
                        eroso = new IPv4prefixEROSubobject();
                        eroso.setIpv4address((Inet4Address)info_actual.getIPnode());
                        eroso.setLoosehop(false);
                        ero.addEROSubobject((EROSubobject)eroso);
                        ServerLayerInfo eroso1 = new ServerLayerInfo();
                        eroso1.setEncoding(8);
                        eroso1.setSwitchingCap(150);
                        ero.addEROSubobject((EROSubobject)eroso1);
                        lambda_chosen = info_next.getnumLayer() - 1;
                        continue;
                    }
                    if (info_next.getnumLayer() == NumLambdas + 1) {
                        if (!flag) {
                            eroso = new IPv4prefixEROSubobject();
                            eroso.setIpv4address((Inet4Address)info_actual.getIPnode());
                            eroso.setLoosehop(false);
                            ero.addEROSubobject((EROSubobject)eroso);
                            continue;
                        }
                        flag = false;
                        continue;
                    }
                    if (info_next.getnumLayer() != NumLambdas + 2) continue;
                    Nodo_aux_actual = node_aux_target;
                    continue;
                }
                if (info_actual.getnumLayer() >= 1 && info_actual.getnumLayer() <= NumLambdas) {
                    DWDMWavelengthLabel WDMlabel;
                    GeneralizedLabelEROSubobject genLabel;
                    if (info_actual.getIPnode() != info_next.getIPnode() && info_actual.getnumLayer() == info_next.getnumLayer()) {
                        eroso = new UnnumberIfIDEROSubobject();
                        eroso.setRouterID((Inet4Address)info_actual.getIPnode());
                        eroso.setInterfaceID(((IntraDomainEdge)this.preComp.getOpticalgraph().getEdge(info_actual.getIPnode(), info_next.getIPnode())).getSrc_if_id());
                        eroso.setLoosehop(false);
                        ero.addEROSubobject((EROSubobject)eroso);
                        genLabel = new GeneralizedLabelEROSubobject();
                        ero.addEROSubobject((EROSubobject)genLabel);
                        WDMlabel = new DWDMWavelengthLabel();
                        WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                        WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                        WDMlabel.setN(lambda_chosen + this.preComp.getWSONInfo().getnMin());
                        WDMlabel.setIdentifier(0);
                        try {
                            WDMlabel.encode();
                        }
                        catch (RSVPProtocolViolationException e) {
                            e.printStackTrace();
                        }
                        genLabel.setLabel(WDMlabel.getBytes());
                    } else if (info_actual.getIPnode() != info_next.getIPnode() && info_actual.getnumLayer() != info_next.getnumLayer()) {
                        ++num_Layer_changes;
                        eroso = new UnnumberIfIDEROSubobject();
                        eroso.setRouterID((Inet4Address)info_actual.getIPnode());
                        eroso.setInterfaceID(0L);
                        eroso.setLoosehop(false);
                        ero.addEROSubobject((EROSubobject)eroso);
                        genLabel = new GeneralizedLabelEROSubobject();
                        ero.addEROSubobject((EROSubobject)genLabel);
                        WDMlabel = new DWDMWavelengthLabel();
                        WDMlabel.setGrid(this.preComp.getWSONInfo().getGrid());
                        WDMlabel.setChannelSpacing(this.preComp.getWSONInfo().getCs());
                        WDMlabel.setN(lambda_chosen + this.preComp.getWSONInfo().getnMin());
                        WDMlabel.setIdentifier(0);
                        try {
                            WDMlabel.encode();
                        }
                        catch (RSVPProtocolViolationException e) {
                            e.printStackTrace();
                        }
                        genLabel.setLabel(WDMlabel.getBytes());
                        ServerLayerInfo eroso1 = new ServerLayerInfo();
                        eroso1.setEncoding(8);
                        eroso1.setSwitchingCap(150);
                        ero.addEROSubobject((EROSubobject)eroso1);
                    }
                    if (j != edge_list.size() - 1) continue;
                    eroso = new IPv4prefixEROSubobject();
                    eroso.setIpv4address((Inet4Address)info_next.getIPnode());
                    eroso.setPrefix(32);
                    ero.addEROSubobject((EROSubobject)eroso);
                    continue;
                }
                if (info_actual.getnumLayer() != NumLambdas + 1 || info_next.getnumLayer() == NumLambdas + 1 || info_next.getnumLayer() != NumLambdas + 2) continue;
                eroso = new IPv4prefixEROSubobject();
                eroso.setIpv4address((Inet4Address)info_next.getIPnode());
                eroso.setPrefix(32);
                ero.addEROSubobject((EROSubobject)eroso);
                flag = true;
            }
            path.setEro(ero);
            PCEPUtils.completeMetric(path, req, edge_list);
            response.addPath(path);
            this.OP_Counter.setTotal_layer_changes(num_Layer_changes);
            if (num_Layer_changes == 0) {
                if (edge_list.size() > 3) {
                    this.OP_Counter.setNum_op2();
                    this.OP_Counter.setTraffic_hops(ero.getEROSubobjectList().size() - 1);
                } else {
                    this.OP_Counter.setNum_op1();
                    this.OP_Counter.setTraffic_hops(1.0);
                }
            } else if (num_Layer_changes == 2) {
                this.OP_Counter.setNum_op3();
                this.OP_Counter.setTraffic_hops(1.0);
            } else if (num_Layer_changes > 2) {
                this.OP_Counter.setNum_op4();
                this.OP_Counter.setTraffic_hops(7.3);
            }
            this.OP_Counter.setMean_layer_changes();
            this.log_OP.info("NumOP_1: " + this.OP_Counter.getNum_op1());
            this.log_OP.info("NumOP_2: " + this.OP_Counter.getNum_op2());
            this.log_OP.info("NumOP_3: " + this.OP_Counter.getNum_op3());
            this.log_OP.info("NumOP_4: " + this.OP_Counter.getNum_op4());
            this.log_OP.info("MeanLayerChanges: " + this.OP_Counter.getMean_layer_changes() + "\n\n");
            this.log_OP.info("Total Traffic Hops: " + this.OP_Counter.getTraffic_hops());
        }
        return m_resp;
    }

    public void setPreComp(Multilayer_Algorithm_auxGraphPreComputation preComp) {
        this.preComp = preComp;
    }

    @Override
    public AlgorithmReservation getReserv() {
        return this.reserv;
    }
}

